/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.gcs.follow.FollowLocationSource;
import com.o3dr.services.android.lib.model.action.Action;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.ArduSolo;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.drone.variables.GuidedPoint;
import org.droidplanner.services.android.impl.core.drone.variables.State;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.follow.LocationRelay;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import timber.log.Timber;

public class Follow
implements DroneInterfaces.OnDroneListener<MavLinkDrone>,
Location.LocationReceiver {
    private static final String TAG = Follow.class.getSimpleName();
    private Location lastLocation;
    private FollowLocationSource mLocationSource;
    private FollowStates state = FollowStates.FOLLOW_INVALID_STATE;
    private final MavLinkDroneManager droneMgr;
    private final Location.LocationFinder locationFinder;
    private FollowAlgorithm followAlgorithm;
    private final LocationRelay mLocationRelay;

    public Follow(MavLinkDroneManager droneMgr, Handler handler, Location.LocationFinder locationFinder) {
        this.droneMgr = droneMgr;
        MavLinkDrone drone = (MavLinkDrone)droneMgr.getDrone();
        if (drone != null) {
            drone.addDroneListener(this);
        }
        this.followAlgorithm = drone instanceof ArduSolo ? FollowAlgorithm.FollowModes.SOLO_SHOT.getAlgorithmType(droneMgr, handler) : FollowAlgorithm.FollowModes.LEASH.getAlgorithmType(droneMgr, handler);
        this.locationFinder = locationFinder;
        this.mLocationRelay = new LocationRelay();
    }

    public void enableFollowMe(FollowLocationSource source) {
        if (!this.isEnabled()) {
            State droneState;
            MavLinkDrone drone = (MavLinkDrone)this.droneMgr.getDrone();
            State state = droneState = drone != null ? drone.getState() : null;
            if (droneState == null) {
                Timber.w((String)"No drone for enableFollowMe(%s)", (Object[])new Object[]{source});
                this.state = FollowStates.FOLLOW_INVALID_STATE;
                return;
            }
            if (this.droneMgr.isConnected()) {
                if (droneState.isArmed()) {
                    GuidedPoint.changeToGuidedMode(drone, null);
                    this.state = FollowStates.FOLLOW_START;
                    this.followAlgorithm.enableFollow();
                    this.droneMgr.onAttributeEvent("com.o3dr.services.android.lib.attribute.event.FOLLOW_START", null);
                } else {
                    this.state = FollowStates.FOLLOW_DRONE_NOT_ARMED;
                }
            } else {
                this.state = FollowStates.FOLLOW_DRONE_DISCONNECTED;
            }
        }
        this.setLocationSource(source);
    }

    public void disableFollowMe() {
        MavLinkDrone drone;
        Timber.i((String)"disableFollowMe(): state=%s", (Object[])new Object[]{this.state});
        this.followAlgorithm.disableFollow();
        this.setLocationSource(FollowLocationSource.NONE);
        this.lastLocation = null;
        if (this.isEnabled()) {
            this.state = FollowStates.FOLLOW_END;
            this.droneMgr.onAttributeEvent("com.o3dr.services.android.lib.attribute.event.FOLLOW_STOP", null);
        }
        if (GuidedPoint.isGuidedMode(drone = (MavLinkDrone)this.droneMgr.getDrone()) && this.followAlgorithm.getType() != FollowAlgorithm.FollowModes.SOLO_SHOT) {
            ((MavLinkDrone)this.droneMgr.getDrone()).executeAsyncAction(new Action("com.o3dr.services.android.lib.drone.action.control.action.SEND_BRAKE_VEHICLE"), null);
        }
    }

    public boolean isEnabled() {
        return this.state == FollowStates.FOLLOW_RUNNING || this.state == FollowStates.FOLLOW_START;
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case MODE: {
                if (!this.isEnabled() || GuidedPoint.isGuidedMode(drone)) break;
                Timber.i((String)"Follow enabled, but current mode is not guided. Disable follow", (Object[])new Object[0]);
                this.disableFollowMe();
                break;
            }
            case HEARTBEAT_TIMEOUT: 
            case DISCONNECTED: {
                if (!this.isEnabled()) break;
                this.disableFollowMe();
            }
        }
    }

    public void onFollowNewLocation(android.location.Location location) {
        Timber.d((String)"onFollowNewLocation(%s)", (Object[])new Object[]{location});
        Location loc = this.mLocationRelay.toGcsLocation(location);
        if (loc != null && this.mLocationSource == FollowLocationSource.CLIENT_SPECIFIED) {
            this.onLocationUpdate(loc);
        }
    }

    @Override
    public void onLocationUpdate(Location location) {
        Timber.d((String)"onLocationUpdate(): lat/lng=%.4f/%.4f accurate=%s", (Object[])new Object[]{location.getCoord().getLatitude(), location.getCoord().getLongitude(), location.isAccurate()});
        if (location.isAccurate()) {
            this.state = FollowStates.FOLLOW_RUNNING;
            this.lastLocation = location;
            Timber.d((String)("Sending location to followAlgorithm " + this.followAlgorithm), (Object[])new Object[0]);
            this.followAlgorithm.onLocationReceived(location);
        } else {
            Timber.d((String)"Location not accurate", (Object[])new Object[0]);
            this.state = FollowStates.FOLLOW_START;
        }
        this.droneMgr.onAttributeEvent("com.o3dr.services.android.lib.attribute.event.FOLLOW_UPDATE", null);
    }

    @Override
    public void onLocationUnavailable() {
        this.disableFollowMe();
    }

    public void setAlgorithm(FollowAlgorithm algorithm) {
        Timber.i((String)("setAlgorithm(): algo=" + algorithm), (Object[])new Object[0]);
        if (this.followAlgorithm != null && this.followAlgorithm != algorithm) {
            Timber.i((String)"%s.disableFollow()", (Object[])new Object[]{this.followAlgorithm});
            this.followAlgorithm.disableFollow();
        }
        this.followAlgorithm = algorithm;
        if (this.isEnabled()) {
            Timber.i((String)"%s.enableFollow()", (Object[])new Object[]{this.followAlgorithm});
            this.followAlgorithm.enableFollow();
            if (this.lastLocation != null) {
                this.followAlgorithm.onLocationReceived(this.lastLocation);
            }
        }
        this.droneMgr.onAttributeEvent("com.o3dr.services.android.lib.attribute.event.FOLLOW_UPDATE", null);
    }

    public FollowAlgorithm getFollowAlgorithm() {
        return this.followAlgorithm;
    }

    public FollowStates getState() {
        return this.state;
    }

    private void setLocationSource(FollowLocationSource source) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mLocationSource != source) {
            switch (source) {
                case CLIENT_SPECIFIED: {
                    Timber.d((String)"Switch to client-specified locations", (Object[])new Object[0]);
                    this.locationFinder.disableLocationUpdates(TAG);
                    this.mLocationRelay.onFollowStart();
                    break;
                }
                case INTERNAL: {
                    Timber.d((String)"Switch to internal locations", (Object[])new Object[0]);
                    this.locationFinder.enableLocationUpdates(TAG, this);
                    break;
                }
                default: {
                    this.locationFinder.disableLocationUpdates(TAG);
                }
            }
            this.mLocationSource = source;
        }
    }

    public static enum FollowStates {
        FOLLOW_INVALID_STATE,
        FOLLOW_DRONE_NOT_ARMED,
        FOLLOW_DRONE_DISCONNECTED,
        FOLLOW_START,
        FOLLOW_RUNNING,
        FOLLOW_END;

    }
}

