/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import android.os.Handler;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_heartbeat;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import timber.log.Timber;

public class HeartBeat
extends DroneVariable
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    public static final long HEARTBEAT_NORMAL_TIMEOUT = 5000L;
    private static final long HEARTBEAT_LOST_TIMEOUT = 15000L;
    public static final int INVALID_MAVLINK_VERSION = -1;
    protected static final int FIRST_HEARTBEAT = 0;
    protected static final int LOST_HEARTBEAT = 1;
    protected static final int NORMAL_HEARTBEAT = 2;
    protected int heartbeatState = 0;
    private short sysid = 1;
    private short compid = 1;
    private short mMavlinkVersion = (short)-1;
    public final Handler watchdog;
    public final Runnable watchdogCallback = new Runnable(){

        @Override
        public void run() {
            HeartBeat.this.onHeartbeatTimeout();
        }
    };

    public HeartBeat(MavLinkDrone myDrone, Handler handler) {
        super(myDrone);
        this.watchdog = handler;
        myDrone.addDroneListener(this);
    }

    public short getSysid() {
        return this.sysid;
    }

    public short getCompid() {
        return this.compid;
    }

    public short getMavlinkVersion() {
        return this.mMavlinkVersion;
    }

    public void onHeartbeat(MAVLinkMessage msg) {
        msg_heartbeat heartBeatMsg;
        msg_heartbeat msg_heartbeat2 = heartBeatMsg = msg instanceof msg_heartbeat ? (msg_heartbeat)msg : null;
        if (heartBeatMsg != null) {
            this.sysid = HeartBeat.validateToUnsignedByteRange(msg.sysid);
            this.compid = HeartBeat.validateToUnsignedByteRange(msg.compid);
            this.mMavlinkVersion = heartBeatMsg.mavlink_version;
        }
        switch (this.heartbeatState) {
            case 0: {
                if (heartBeatMsg == null) break;
                Timber.i((String)"Received first heartbeat.", (Object[])new Object[0]);
                this.heartbeatState = 2;
                this.restartWatchdog(5000L);
                this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.HEARTBEAT_FIRST);
                break;
            }
            case 1: {
                this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.HEARTBEAT_RESTORED);
            }
            default: {
                this.heartbeatState = 2;
                this.restartWatchdog(5000L);
            }
        }
    }

    public boolean hasHeartbeat() {
        return this.heartbeatState != 0;
    }

    public boolean isConnectionAlive() {
        return this.heartbeatState != 1;
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case DISCONNECTED: {
                this.notifyDisconnected();
                break;
            }
        }
    }

    private void notifyDisconnected() {
        this.watchdog.removeCallbacks(this.watchdogCallback);
        this.heartbeatState = 0;
        this.mMavlinkVersion = (short)-1;
    }

    protected void onHeartbeatTimeout() {
        switch (this.heartbeatState) {
            case 0: {
                Timber.i((String)"First heartbeat timeout.", (Object[])new Object[0]);
                this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.HEARTBEAT_TIMEOUT);
                break;
            }
            default: {
                this.heartbeatState = 1;
                this.restartWatchdog(15000L);
                this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.HEARTBEAT_TIMEOUT);
            }
        }
    }

    protected void restartWatchdog(long timeout) {
        this.watchdog.removeCallbacks(this.watchdogCallback);
        this.watchdog.postDelayed(this.watchdogCallback, timeout);
    }
}

