/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.manager;

import android.os.Handler;
import android.os.RemoteException;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_command_ack;
import com.MAVLink.common.msg_command_long;
import com.MAVLink.common.msg_set_mode;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.util.concurrent.ConcurrentHashMap;
import timber.log.Timber;

public class DroneCommandTracker {
    private static final long COMMAND_TIMEOUT_PERIOD = 2000L;
    private final Handler handler;
    private final ConcurrentHashMap<Integer, CallbackKey> keyStore = new ConcurrentHashMap();
    private final ConcurrentHashMap<CallbackKey, AckCallback> callbackStore = new ConcurrentHashMap();

    DroneCommandTracker(Handler handler) {
        this.handler = handler;
    }

    public void onCommandSubmitted(MAVLinkMessage command, ICommandListener listener) {
        if (command == null || listener == null) {
            return;
        }
        if (command instanceof msg_command_long) {
            this.onCommandSubmittedImpl((msg_command_long)command, listener);
        } else if (command instanceof msg_set_mode) {
            this.onCommandSubmittedImpl((msg_set_mode)command, listener);
        }
    }

    private void onCommandSubmittedImpl(msg_command_long command, ICommandListener listener) {
        int commandId = command.command;
        CallbackKey<msg_command_ack> key = new CallbackKey<msg_command_ack>(commandId){

            @Override
            public int checkAckResult(msg_command_ack result) {
                return result.result;
            }
        };
        AckCallback callback = new AckCallback(listener, commandId);
        this.keyStore.put(commandId, key);
        this.callbackStore.put(key, callback);
        this.handler.postDelayed((Runnable)callback, 2000L);
    }

    private void onCommandSubmittedImpl(msg_set_mode command, ICommandListener listener) {
        int commandId = command.msgid;
        CallbackKey<msg_command_ack> key = new CallbackKey<msg_command_ack>(commandId){

            @Override
            public int checkAckResult(msg_command_ack result) {
                return result.result;
            }
        };
        AckCallback callback = new AckCallback(listener, commandId);
        this.keyStore.put(commandId, key);
        this.callbackStore.put(key, callback);
        this.handler.postDelayed((Runnable)callback, 2000L);
    }

    public void onCommandAck(int commandId, Object ack) {
        switch (commandId) {
            case 77: {
                this.onCommandAckImpl((msg_command_ack)ack);
            }
        }
    }

    private void onCommandAckImpl(msg_command_ack ack) {
        CallbackKey key = this.keyStore.get(ack.command);
        if (key == null) {
            return;
        }
        AckCallback callback = this.callbackStore.remove(key);
        if (callback != null) {
            this.handler.removeCallbacks((Runnable)callback);
            callback.setAckResult(key.checkAckResult(ack));
            this.handler.post((Runnable)callback);
        }
    }

    private class AckCallback
    implements Runnable {
        private static final int COMMAND_TIMED_OUT = -1;
        private static final int COMMAND_SUCCEED = 0;
        private int ackResult = -1;
        private final ICommandListener listener;
        private final int ackId;

        AckCallback(ICommandListener listener, int ackId) {
            this.listener = listener;
            this.ackId = ackId;
        }

        void setAckResult(int result) {
            this.ackResult = result;
        }

        @Override
        public void run() {
            if (this.listener == null) {
                return;
            }
            CallbackKey key = (CallbackKey)DroneCommandTracker.this.keyStore.remove(this.ackId);
            if (key != null) {
                DroneCommandTracker.this.callbackStore.remove(key);
            }
            Timber.d((String)"Callback with ack result %d", (Object[])new Object[]{this.ackResult});
            try {
                switch (this.ackResult) {
                    case -1: {
                        this.listener.onTimeout();
                        break;
                    }
                    case 0: {
                        this.listener.onSuccess();
                        break;
                    }
                    default: {
                        this.listener.onError(this.ackResult);
                        break;
                    }
                }
            }
            catch (RemoteException e) {
                Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    private static abstract class CallbackKey<T> {
        private final int commandId;

        CallbackKey(int commandId) {
            this.commandId = commandId;
        }

        public abstract int checkAckResult(T var1);

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallbackKey)) {
                return false;
            }
            CallbackKey that = (CallbackKey)o;
            return this.commandId == that.commandId;
        }

        public int hashCode() {
            return this.commandId;
        }
    }
}

