/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.sololink;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import com.o3dr.android.client.utils.connection.TcpConnection;
import com.o3dr.android.client.utils.connection.UdpConnection;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSetting;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingGetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingSetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproRequestState;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageShotManagerError;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVMessageParser;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.SimpleCommandListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.AbstractLinkManager;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.sololink.SoloLinkListener;
import org.droidplanner.services.android.impl.utils.connection.SshConnection;
import timber.log.Timber;

public class SoloLinkManager
extends AbstractLinkManager<SoloLinkListener> {
    public static final String SOLO_LINK_IP = "10.1.1.10";
    public static final int SOLO_LINK_TCP_PORT = 5507;
    private static final int SHOT_FOLLOW_UDP_PORT = 14558;
    private static final String SOLO_VERSION_FILENAME = "/VERSION";
    private static final String PIXHAWK_VERSION_FILENAME = "/PIX_VERSION";
    private static final String GIMBAL_VERSION_FILENAME = "/AXON_VERSION";
    private final UdpConnection followDataConn;
    private final SshConnection sshLink;
    private final SoloButtonSettingGetter presetButtonAGetter = new SoloButtonSettingGetter(4, 0);
    private final SoloButtonSettingGetter presetButtonBGetter = new SoloButtonSettingGetter(5, 0);
    private final SoloGoproRequestState goproStateGetter = new SoloGoproRequestState();
    private final AtomicReference<SoloButtonSetting> loadedPresetButtonA = new AtomicReference();
    private final AtomicReference<SoloButtonSetting> loadedPresetButtonB = new AtomicReference();
    private final AtomicReference<String> vehicleVersion = new AtomicReference<String>("");
    private final AtomicReference<String> pixhawkVersion = new AtomicReference<String>("");
    private final AtomicReference<String> gimbalVersion = new AtomicReference<String>("");
    private final Runnable soloLinkVersionRetriever = new Runnable(){

        @Override
        public void run() {
            String version = SoloLinkManager.this.retrieveVersion(SoloLinkManager.SOLO_VERSION_FILENAME);
            if (version != null) {
                SoloLinkManager.this.vehicleVersion.set(version);
            }
            if (SoloLinkManager.this.linkListener != null && SoloLinkManager.this.areVersionsSet()) {
                SoloLinkManager.this.linkListener.onVersionsUpdated();
            }
        }
    };
    private final Runnable pixhawkVersionRetriever = new Runnable(){

        @Override
        public void run() {
            String version = SoloLinkManager.this.retrieveVersion(SoloLinkManager.PIXHAWK_VERSION_FILENAME);
            if (version != null) {
                SoloLinkManager.this.pixhawkVersion.set(version);
            }
            if (SoloLinkManager.this.linkListener != null && SoloLinkManager.this.areVersionsSet()) {
                SoloLinkManager.this.linkListener.onVersionsUpdated();
            }
        }
    };
    private final Runnable gimbalVersionRetriever = new Runnable(){

        @Override
        public void run() {
            String version = SoloLinkManager.this.retrieveVersion(SoloLinkManager.GIMBAL_VERSION_FILENAME);
            if (version != null) {
                SoloLinkManager.this.gimbalVersion.set(version);
            }
            if (SoloLinkManager.this.linkListener != null && SoloLinkManager.this.areVersionsSet()) {
                SoloLinkManager.this.linkListener.onVersionsUpdated();
            }
        }
    };
    private SoloLinkListener linkListener;

    public SoloLinkManager(Context context, Handler handler, ExecutorService asyncExecutor, DataLink.DataLinkProvider mavClient) {
        super(context, new TcpConnection(handler, SoloLinkManager.getSoloLinkIp(), 5507), handler, asyncExecutor, mavClient);
        this.sshLink = new SshConnection(SoloLinkManager.getSoloLinkIp(), "root", "TjSDBkAu", mavClient);
        UdpConnection dataConn = null;
        try {
            dataConn = new UdpConnection(handler, SoloLinkManager.getSoloLinkIp(), 14558, 14557);
        }
        catch (UnknownHostException e) {
            Timber.e((Throwable)e, (String)"Error while creating follow udp connection.", (Object[])new Object[0]);
        }
        this.followDataConn = dataConn;
    }

    public static String getSoloLinkIp() {
        return SOLO_LINK_IP;
    }

    public String getVehicleVersion() {
        return this.vehicleVersion.get();
    }

    public String getPixhawkVersion() {
        return this.pixhawkVersion.get();
    }

    public String getGimbalVersion() {
        return this.gimbalVersion.get();
    }

    public boolean areVersionsSet() {
        return !TextUtils.isEmpty((CharSequence)this.vehicleVersion.get()) && !TextUtils.isEmpty((CharSequence)this.pixhawkVersion.get());
    }

    @Override
    public void start(SoloLinkListener listener) {
        if (!this.isStarted()) {
            Timber.i((String)"Starting solo link manager", (Object[])new Object[0]);
        }
        super.start(listener);
        this.linkListener = listener;
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            Timber.i((String)"Stopping solo link manager", (Object[])new Object[0]);
        }
        super.stop();
    }

    @Override
    public void refreshState() {
        Timber.d((String)"Connected to sololink.", (Object[])new Object[0]);
        this.loadMacAddress();
        this.loadPresetButtonSettings();
        this.loadGoproState();
        this.refreshSoloLinkVersions();
    }

    @Override
    protected SshConnection getSshLink() {
        return this.sshLink;
    }

    @Override
    public void onIpDisconnected() {
        Timber.d((String)"Disconnected from sololink.", (Object[])new Object[0]);
        super.onIpDisconnected();
    }

    @Override
    public void onPacketReceived(ByteBuffer packetBuffer) {
        List<TLVPacket> tlvMsgs = TLVMessageParser.parseTLVPacket(packetBuffer);
        if (tlvMsgs.isEmpty()) {
            return;
        }
        for (TLVPacket tlvMsg : tlvMsgs) {
            int messageType = tlvMsg.getMessageType();
            Timber.d((String)("Received tlv message: " + messageType), (Object[])new Object[0]);
            switch (messageType) {
                case 1000: {
                    Timber.w((String)((SoloMessageShotManagerError)tlvMsg).getExceptionInfo(), (Object[])new Object[0]);
                    break;
                }
                case 5: {
                    SoloButtonSettingGetter receivedPresetButton = (SoloButtonSettingGetter)tlvMsg;
                    this.handleReceivedPresetButton(receivedPresetButton);
                }
            }
            if (this.linkListener == null) continue;
            this.linkListener.onTlvPacketReceived(tlvMsg);
        }
    }

    private void sendPacket(byte[] payload, int payloadSize, ICommandListener listener) {
        this.linkConn.sendPacket(payload, payloadSize, listener);
    }

    private void sendFollowPacket(byte[] payload, int payloadSize, ICommandListener listener) {
        if (this.followDataConn == null) {
            throw new IllegalStateException("Unable to send follow data.");
        }
        this.followDataConn.sendPacket(payload, payloadSize, listener);
    }

    public void sendTLVPacket(TLVPacket packet, ICommandListener listener) {
        this.sendTLVPacket(packet, false, listener);
    }

    public void sendTLVPacket(TLVPacket packet, boolean useFollowLink, ICommandListener listener) {
        if (packet == null) {
            return;
        }
        byte[] messagePayload = packet.toBytes();
        if (useFollowLink) {
            this.sendFollowPacket(messagePayload, messagePayload.length, listener);
        } else {
            this.sendPacket(messagePayload, messagePayload.length, listener);
        }
    }

    public void loadPresetButtonSettings() {
        this.sendTLVPacket(this.presetButtonAGetter, new SimpleCommandListener(){

            @Override
            public void onSuccess() {
                SoloLinkManager.this.sendTLVPacket(SoloLinkManager.this.presetButtonBGetter, null);
            }
        });
    }

    private void loadGoproState() {
        this.sendTLVPacket(this.goproStateGetter, null);
    }

    private void handleReceivedPresetButton(SoloButtonSetting presetButton) {
        int buttonType = presetButton.getButton();
        switch (buttonType) {
            case 4: {
                this.loadedPresetButtonA.set(presetButton);
                if (this.linkListener == null) break;
                this.linkListener.onPresetButtonLoaded(buttonType, presetButton);
                break;
            }
            case 5: {
                this.loadedPresetButtonB.set(presetButton);
                if (this.linkListener == null) break;
                this.linkListener.onPresetButtonLoaded(buttonType, presetButton);
            }
        }
    }

    public SoloButtonSetting getLoadedPresetButton(int buttonType) {
        switch (buttonType) {
            case 4: {
                return this.loadedPresetButtonA.get();
            }
            case 5: {
                return this.loadedPresetButtonB.get();
            }
        }
        return null;
    }

    public void pushPresetButtonSettings(final SoloButtonSettingSetter buttonSetter, final ICommandListener listener) {
        if (!this.isLinkConnected() || buttonSetter == null) {
            return;
        }
        this.sendTLVPacket(buttonSetter, new SimpleCommandListener(){

            @Override
            public void onSuccess() {
                SoloLinkManager.this.postSuccessEvent(listener);
                SoloLinkManager.this.handleReceivedPresetButton(buttonSetter);
            }

            @Override
            public void onTimeout() {
                SoloLinkManager.this.postTimeoutEvent(listener);
            }
        });
    }

    public void disableFollowDataConnection() {
        if (this.followDataConn != null) {
            this.followDataConn.disconnect();
        }
    }

    public void enableFollowDataConnection() {
        if (this.followDataConn != null) {
            this.followDataConn.connect(this.linkProvider.getConnectionExtras());
        }
    }

    public boolean updateSololinkWifi(CharSequence wifiSsid, CharSequence password) {
        Timber.d((String)String.format(Locale.US, "Updating solo wifi ssid to %s with password %s", wifiSsid, password), (Object[])new Object[0]);
        try {
            String ssidUpdateResult = this.sshLink.execute("/usr/bin/sololink_config --set-wifi-ssid " + wifiSsid);
            String passwordUpdateResult = this.sshLink.execute("/usr/bin/sololink_config --set-wifi-password " + password);
            String restartResult = this.sshLink.execute("/usr/bin/sololink_config --reboot");
            return true;
        }
        catch (IOException e) {
            Timber.e((Throwable)e, (String)"Error occurred while updating the sololink wifi ssid.", (Object[])new Object[0]);
            return false;
        }
    }

    private void updateSoloLinkVersion() {
        this.postAsyncTask(this.soloLinkVersionRetriever);
    }

    private void updatePixhawkVersion() {
        this.postAsyncTask(this.pixhawkVersionRetriever);
    }

    private void updateGimbalVersion() {
        this.postAsyncTask(this.gimbalVersionRetriever);
    }

    private String retrieveVersion(String versionFile) {
        try {
            String version = this.sshLink.execute("cat " + versionFile);
            if (TextUtils.isEmpty((CharSequence)version)) {
                Timber.d((String)"No version file was found", (Object[])new Object[0]);
                return "";
            }
            return version.split("\n")[0];
        }
        catch (IOException e) {
            Timber.e((String)"Unable to retrieve the current version.", (Object[])new Object[]{e});
            return null;
        }
    }

    public void refreshSoloLinkVersions() {
        this.updateSoloLinkVersion();
        this.updatePixhawkVersion();
        this.updateGimbalVersion();
    }
}

