/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink;

import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_heartbeat;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.firmware.FirmwareType;

public class MavLinkMsgHandler {
    public static final int AUTOPILOT_COMPONENT_ID = 1;
    private final MavLinkDroneManager droneMgr;

    public MavLinkMsgHandler(MavLinkDroneManager droneMgr) {
        this.droneMgr = droneMgr;
    }

    public void receiveData(MAVLinkMessage msg) {
        if (msg.compid != 1) {
            return;
        }
        switch (msg.msgid) {
            case 0: {
                msg_heartbeat msg_heart = (msg_heartbeat)msg;
                this.handleHeartbeat(msg_heart);
                break;
            }
        }
    }

    private void handleHeartbeat(msg_heartbeat heartbeat) {
        switch (heartbeat.autopilot) {
            case 3: {
                switch (heartbeat.type) {
                    case 1: {
                        this.droneMgr.onVehicleTypeReceived(FirmwareType.ARDU_PLANE);
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.droneMgr.onVehicleTypeReceived(FirmwareType.ARDU_COPTER);
                        break;
                    }
                    case 10: 
                    case 11: {
                        this.droneMgr.onVehicleTypeReceived(FirmwareType.ARDU_ROVER);
                    }
                }
                break;
            }
            case 12: {
                this.droneMgr.onVehicleTypeReceived(FirmwareType.PX4_NATIVE);
                break;
            }
            default: {
                this.droneMgr.onVehicleTypeReceived(FirmwareType.GENERIC);
            }
        }
    }
}

