/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Parameter
implements DroneAttribute,
Comparable<Parameter> {
    public static final int RANGE_LOW = 0;
    public static final int RANGE_HIGH = 1;
    private static final DecimalFormat formatter = (DecimalFormat)DecimalFormat.getInstance();
    private String name;
    private double value;
    private int type;
    private String displayName;
    private String description;
    private String units;
    private String range;
    private String values;
    public static final Parcelable.Creator<Parameter> CREATOR;

    public Parameter(String name, double value, int type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return formatter.format(this.value);
    }

    public void setValue(double value) {
        this.value = value;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public boolean hasInfo() {
        return this.description != null && !this.description.isEmpty() || this.values != null && !this.values.isEmpty();
    }

    public double[] parseRange() throws ParseException {
        double[] outRange;
        DecimalFormat format = formatter;
        String[] parts = this.range.split("( to |\\s+|-)");
        if (parts.length < 2) {
            throw new IllegalArgumentException();
        }
        outRange = new double[]{format.parse(parts[0]).doubleValue(), format.parse(parts[outRange.length - 1]).doubleValue()};
        return outRange;
    }

    public Map<Double, String> parseValues() throws ParseException {
        DecimalFormat format = formatter;
        LinkedHashMap<Double, String> outValues = new LinkedHashMap<Double, String>();
        if (this.values != null) {
            String[] tparts;
            for (String tpart : tparts = this.values.split(",")) {
                String[] parts = tpart.split(":");
                if (parts.length != 2) {
                    throw new IllegalArgumentException();
                }
                outValues.put(format.parse(parts[0].trim()).doubleValue(), parts[1].trim());
            }
        }
        return outValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return !(this.name == null ? parameter.name != null : !this.name.equals(parameter.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeDouble(this.value);
        dest.writeInt(this.type);
        dest.writeString(this.displayName);
        dest.writeString(this.description);
        dest.writeString(this.units);
        dest.writeString(this.range);
        dest.writeString(this.values);
    }

    private Parameter(Parcel in) {
        this.name = in.readString();
        this.value = in.readDouble();
        this.type = in.readInt();
        this.displayName = in.readString();
        this.description = in.readString();
        this.units = in.readString();
        this.range = in.readString();
        this.values = in.readString();
    }

    @Override
    public int compareTo(Parameter another) {
        return this.name.compareTo(another.name);
    }

    static {
        formatter.applyPattern("0.###");
        CREATOR = new Parcelable.Creator<Parameter>(){

            public Parameter createFromParcel(Parcel source) {
                return new Parameter(source);
            }

            public Parameter[] newArray(int size) {
                return new Parameter[size];
            }
        };
    }
}

