/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.os.Bundle;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class CalibrationApi
extends Api {
    private static final ConcurrentHashMap<Drone, CalibrationApi> calibrationApiCache = new ConcurrentHashMap();
    private static final Api.Builder<CalibrationApi> apiBuilder = new Api.Builder<CalibrationApi>(){

        @Override
        public CalibrationApi build(Drone drone) {
            return new CalibrationApi(drone);
        }
    };
    private final Drone drone;

    public static CalibrationApi getApi(Drone drone) {
        return CalibrationApi.getApi(drone, calibrationApiCache, apiBuilder);
    }

    private CalibrationApi(Drone drone) {
        this.drone = drone;
    }

    public void startIMUCalibration() {
        this.startIMUCalibration(null);
    }

    public void startIMUCalibration(AbstractCommandListener listener) {
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.START_IMU_CALIBRATION"), listener);
    }

    public void sendIMUAck(int step) {
        Bundle params = new Bundle();
        params.putInt("extra_step", step);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.SEND_IMU_CALIBRATION_ACK", params));
    }

    public void startMagnetometerCalibration() {
        this.startMagnetometerCalibration(false, true, 0);
    }

    public void startMagnetometerCalibration(boolean retryOnFailure, boolean saveAutomatically, int startDelay) {
        Bundle params = new Bundle();
        params.putBoolean("extra_retry_on_failure", retryOnFailure);
        params.putBoolean("extra_save_automatically", saveAutomatically);
        params.putInt("extra_start_delay", startDelay);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.START_MAGNETOMETER_CALIBRATION", params));
    }

    public void acceptMagnetometerCalibration() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.ACCEPT_MAGNETOMETER_CALIBRATION"));
    }

    public void cancelMagnetometerCalibration() {
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.CANCEL_MAGNETOMETER_CALIBRATION"));
    }
}

