/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.o3dr.android.client.ApiAvailability;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.DroneApiListener;
import com.o3dr.android.client.interfaces.TowerListener;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.model.IDroidPlannerServices;
import com.o3dr.services.android.lib.model.IDroneApi;
import java.util.concurrent.atomic.AtomicBoolean;

public class ControlTower {
    private static final String TAG = ControlTower.class.getSimpleName();
    private final IBinder.DeathRecipient binderDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            ControlTower.this.notifyTowerDisconnected();
        }
    };
    private final ServiceConnection o3drServicesConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            ControlTower.this.isServiceConnecting.set(false);
            ControlTower.this.o3drServices = IDroidPlannerServices.Stub.asInterface(service);
            try {
                ControlTower.this.o3drServices.asBinder().linkToDeath(ControlTower.this.binderDeathRecipient, 0);
                ControlTower.this.notifyTowerConnected();
            }
            catch (RemoteException e) {
                ControlTower.this.notifyTowerDisconnected();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            ControlTower.this.isServiceConnecting.set(false);
            ControlTower.this.notifyTowerDisconnected();
        }
    };
    private final AtomicBoolean isServiceConnecting = new AtomicBoolean(false);
    private final Context context;
    private final DroneApiListener apiListener;
    private TowerListener towerListener;
    private IDroidPlannerServices o3drServices;

    public ControlTower(Context context) {
        this.context = context;
        this.apiListener = new DroneApiListener(this.context);
    }

    public boolean isTowerConnected() {
        return this.o3drServices != null && this.o3drServices.asBinder().pingBinder();
    }

    void notifyTowerConnected() {
        if (this.towerListener == null) {
            return;
        }
        this.towerListener.onTowerConnected();
    }

    void notifyTowerDisconnected() {
        if (this.towerListener == null) {
            return;
        }
        this.towerListener.onTowerDisconnected();
    }

    public Bundle[] getConnectedApps() {
        Bundle[] connectedApps = new Bundle[]{};
        if (this.isTowerConnected()) {
            try {
                connectedApps = this.o3drServices.getConnectedApps(this.getApplicationId());
                if (connectedApps != null) {
                    ClassLoader classLoader = ConnectionParameter.class.getClassLoader();
                    for (Bundle appInfo : connectedApps) {
                        appInfo.setClassLoader(classLoader);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
        return connectedApps;
    }

    public void registerDrone(Drone drone, Handler handler) {
        if (drone == null) {
            return;
        }
        if (!this.isTowerConnected()) {
            throw new IllegalStateException("Control Tower must be connected.");
        }
        drone.init(this, handler);
        drone.start();
    }

    public void unregisterDrone(Drone drone) {
        if (drone != null) {
            drone.destroy();
        }
    }

    public void connect(TowerListener listener) {
        if (this.towerListener != null && (this.isServiceConnecting.get() || this.isTowerConnected())) {
            return;
        }
        if (listener == null) {
            throw new IllegalArgumentException("ServiceListener argument cannot be null.");
        }
        this.towerListener = listener;
        if (!this.isTowerConnected() && !this.isServiceConnecting.get()) {
            Intent serviceIntent = ApiAvailability.getInstance().getAvailableServicesInstance(this.context);
            this.isServiceConnecting.set(this.context.bindService(serviceIntent, this.o3drServicesConnection, 1));
        }
    }

    public void disconnect() {
        if (this.o3drServices != null) {
            this.o3drServices.asBinder().unlinkToDeath(this.binderDeathRecipient, 0);
            this.o3drServices = null;
        }
        this.notifyTowerDisconnected();
        this.towerListener = null;
        try {
            this.context.unbindService(this.o3drServicesConnection);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error occurred while unbinding from DroneKit-Android.");
        }
    }

    IDroneApi registerDroneApi() throws RemoteException {
        return this.o3drServices.registerDroneApi(this.apiListener, this.getApplicationId());
    }

    void releaseDroneApi(IDroneApi droneApi) throws RemoteException {
        this.o3drServices.releaseDroneApi(droneApi);
    }

    private String getApplicationId() {
        return this.context.getPackageName();
    }
}

