/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.survey;

import java.util.Locale;
import org.droidplanner.services.android.impl.core.helpers.units.Area;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;
import org.droidplanner.services.android.impl.core.survey.Footprint;

public class SurveyData {
    private CameraInfo camera = new CameraInfo();
    private double altitude;
    private Double angle;
    private Double overlap;
    private Double sidelap;
    private boolean lockOrientation;
    private Footprint footprint;

    public SurveyData() {
        this.update(0.0, 50.0, 50.0, 60.0, false);
    }

    public void update(double angle, double altitude, double overlap, double sidelap, boolean lockOrientation) {
        this.angle = angle;
        this.overlap = overlap;
        this.sidelap = sidelap;
        this.setAltitude(altitude);
        this.lockOrientation = lockOrientation;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
        this.footprint = new Footprint(this.camera, this.altitude);
    }

    public void setCameraInfo(CameraInfo info) {
        this.camera = info;
        this.footprint = new Footprint(this.camera, this.altitude);
        this.tryToLoadOverlapFromCamera();
    }

    public CameraInfo getCameraInfo() {
        return this.camera;
    }

    public void setLockOrientation(boolean lockOrientation) {
        this.lockOrientation = lockOrientation;
    }

    private void tryToLoadOverlapFromCamera() {
        if (this.camera.overlap != null) {
            this.overlap = this.camera.overlap;
        }
        if (this.camera.sidelap != null) {
            this.sidelap = this.camera.sidelap;
        }
    }

    public double getLongitudinalPictureDistance() {
        return this.getLongitudinalFootPrint() * (1.0 - this.overlap * 0.01);
    }

    public double getLateralPictureDistance() {
        return this.getLateralFootPrint() * (1.0 - this.sidelap * 0.01);
    }

    public double getAltitude() {
        return this.altitude;
    }

    public Double getAngle() {
        return this.angle;
    }

    public double getSidelap() {
        return this.sidelap;
    }

    public double getOverlap() {
        return this.overlap;
    }

    public double getLateralFootPrint() {
        return this.footprint.getLateralSize();
    }

    public double getLongitudinalFootPrint() {
        return this.footprint.getLongitudinalSize();
    }

    public Area getGroundResolution() {
        return new Area(this.footprint.getGSD() * 0.01);
    }

    public String getCameraName() {
        return this.camera.name;
    }

    public boolean getLockOrientation() {
        return this.lockOrientation;
    }

    public String toString() {
        return String.format(Locale.US, "Altitude: %f Angle %f Overlap: %f Sidelap: %f Locked Orientation: %b", this.altitude, this.angle, this.overlap, this.sidelap, this.lockOrientation);
    }
}

