/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.srtm;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.droidplanner.services.android.impl.core.srtm.Srtm;
import org.droidplanner.services.android.impl.core.srtm.SrtmDownloader;

public class SrtmRegions {
    static final String[] REGIONS = new String[]{"Eurasia", "Africa", "Australia", "Islands", "North_America", "South_America"};
    private Map<String, Integer> regionMap = new HashMap<String, Integer>();
    private String path;

    public SrtmRegions(String path) {
        this.path = path;
    }

    public String findRegion(String fname, Srtm.OnProgressListner listner) throws Exception {
        String name;
        if (this.regionMap.isEmpty()) {
            this.fillRegionData(listner);
        }
        if (this.regionMap.containsKey(name = fname.replace(".hgt", ""))) {
            return REGIONS[this.regionMap.get(name)];
        }
        throw new Exception("Null Region");
    }

    private void fillRegionData(Srtm.OnProgressListner listner) throws Exception {
        for (int i = 0; i < REGIONS.length; ++i) {
            File indexFile;
            String region;
            String indexPath = region = REGIONS[i];
            indexPath = SrtmDownloader.getIndexPath(this.path) + indexPath;
            File indexDir = new File(indexPath);
            if (!indexDir.exists()) {
                indexDir.mkdirs();
            }
            if (!(indexFile = new File(indexPath = indexPath + ".index.html")).exists()) {
                try {
                    new SrtmDownloader(listner).downloadRegionIndex(i, this.path);
                }
                catch (IOException e) {
                    this.regionMap.clear();
                    throw new Exception("Null Region");
                }
            }
            Scanner scanner = new Scanner(indexFile);
            while (scanner.hasNext()) {
                String srtm;
                String line = scanner.next();
                if (!line.contains("href=\"")) continue;
                int index = line.indexOf(".hgt.zip") - 7;
                if (index >= 0) {
                    srtm = line.substring(index, index + 7);
                    this.regionMap.put(srtm, i);
                    continue;
                }
                index = line.indexOf("hgt.zip") - 7;
                if (index < 0) continue;
                srtm = line.substring(index, index + 7);
                this.regionMap.put(srtm, i);
            }
            scanner.close();
        }
    }
}

