/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.geoTools;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.coordinates.CoordBounds;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineLatLong;
import org.droidplanner.services.android.impl.core.helpers.geoTools.PointTools;

public class LineTools {
    public static LineLatLong findExternalPoints(ArrayList<LatLong> crosses) {
        LatLong meanCoord = new CoordBounds(crosses).getMiddle();
        LatLong start = PointTools.findFarthestPoint(crosses, meanCoord);
        LatLong end = PointTools.findFarthestPoint(crosses, start);
        return new LineLatLong(start, end);
    }

    public static LatLong FindLineIntersection(LineLatLong first, LineLatLong second) {
        double denom = (first.getEnd().getLatitude() - first.getStart().getLatitude()) * (second.getEnd().getLongitude() - second.getStart().getLongitude()) - (first.getEnd().getLongitude() - first.getStart().getLongitude()) * (second.getEnd().getLatitude() - second.getStart().getLatitude());
        if (denom == 0.0) {
            return null;
        }
        double numer = (first.getStart().getLongitude() - second.getStart().getLongitude()) * (second.getEnd().getLatitude() - second.getStart().getLatitude()) - (first.getStart().getLatitude() - second.getStart().getLatitude()) * (second.getEnd().getLongitude() - second.getStart().getLongitude());
        double r = numer / denom;
        double numer2 = (first.getStart().getLongitude() - second.getStart().getLongitude()) * (first.getEnd().getLatitude() - first.getStart().getLatitude()) - (first.getStart().getLatitude() - second.getStart().getLatitude()) * (first.getEnd().getLongitude() - first.getStart().getLongitude());
        double s = numer2 / denom;
        if (r < 0.0 || r > 1.0 || s < 0.0 || s > 1.0) {
            return null;
        }
        double x = first.getStart().getLatitude() + r * (first.getEnd().getLatitude() - first.getStart().getLatitude());
        double y = first.getStart().getLongitude() + r * (first.getEnd().getLongitude() - first.getStart().getLongitude());
        return new LatLong(x, y);
    }

    public static LineLatLong findClosestLineToPoint(LatLong point, List<LineLatLong> list) {
        LineLatLong answer = list.get(0);
        double shortest = Double.MAX_VALUE;
        for (LineLatLong line : list) {
            double ans2;
            double ans1 = GeoTools.getAproximatedDistance(point, line.getStart());
            LatLong latLong = ans1 < (ans2 = GeoTools.getAproximatedDistance(point, line.getEnd()).doubleValue()) ? line.getStart() : line.getEnd();
            LatLong shorterpnt = latLong;
            if (!(shortest > GeoTools.getAproximatedDistance(point, shorterpnt))) continue;
            answer = line;
            shortest = GeoTools.getAproximatedDistance(point, shorterpnt);
        }
        return answer;
    }
}

