/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs;

import android.os.Bundle;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import com.o3dr.services.android.lib.drone.property.Home;
import com.o3dr.services.android.lib.gcs.returnToMe.ReturnToMeState;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.atomic.AtomicBoolean;
import org.droidplanner.services.android.impl.core.MAVLink.command.doCmd.MavLinkDoCmds;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;
import timber.log.Timber;

public class ReturnToMe
implements DroneInterfaces.OnDroneListener<MavLinkDrone>,
Location.LocationReceiver {
    public static final int UPDATE_MINIMAL_DISPLACEMENT = 5;
    private static final String TAG = ReturnToMe.class.getSimpleName();
    private static final Action requestHomeUpdateAction = new Action("org.droidplanner.services.android.core.drone.autopilot.action.REQUEST_HOME_UPDATE");
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    private final ReturnToMeState currentState;
    private final MavLinkDroneManager droneMgr;
    private final Location.LocationFinder locationFinder;
    private final DroneInterfaces.AttributeEventListener attributeListener;
    private ICommandListener commandListener;

    public ReturnToMe(MavLinkDroneManager droneMgr, Location.LocationFinder locationFinder, DroneInterfaces.AttributeEventListener listener) {
        this.droneMgr = droneMgr;
        this.locationFinder = locationFinder;
        this.attributeListener = listener;
        this.currentState = new ReturnToMeState();
        MavLinkDrone drone = (MavLinkDrone)droneMgr.getDrone();
        drone.addDroneListener(this);
    }

    public void enable(ICommandListener listener) {
        if (this.isEnabled.compareAndSet(false, true)) {
            this.commandListener = listener;
            Home droneHome = this.getHome();
            if (droneHome.isValid()) {
                this.currentState.setOriginalHomeLocation(droneHome.getCoordinate());
            }
            Timber.i((String)"Enabling return to me.", (Object[])new Object[0]);
            this.locationFinder.enableLocationUpdates(TAG, this);
            this.updateCurrentState(3);
        }
    }

    public void disable() {
        if (this.isEnabled.compareAndSet(true, false)) {
            Timber.i((String)"Disabling return to me.", (Object[])new Object[0]);
            this.locationFinder.disableLocationUpdates(TAG);
            this.currentState.setCurrentHomeLocation(null);
            final LatLongAlt originalHomeLocation = this.currentState.getOriginalHomeLocation();
            if (originalHomeLocation != null) {
                MavLinkDoCmds.setVehicleHome((MavLinkDrone)this.droneMgr.getDrone(), originalHomeLocation, new AbstractCommandListener(){

                    @Override
                    public void onSuccess() {
                        Timber.i((String)"Updated vehicle home location to %s", (Object[])new Object[]{originalHomeLocation.toString()});
                        ((MavLinkDrone)ReturnToMe.this.droneMgr.getDrone()).executeAsyncAction(requestHomeUpdateAction, null);
                    }

                    @Override
                    public void onError(int executionError) {
                        Timber.e((String)"Unable to update vehicle home location: %d", (Object[])new Object[]{executionError});
                    }

                    @Override
                    public void onTimeout() {
                        Timber.w((String)"Vehicle home update timed out!", (Object[])new Object[0]);
                    }
                });
            }
            this.updateCurrentState(0);
            this.commandListener = null;
        }
    }

    @Override
    public void onLocationUpdate(Location location) {
        if (location.isAccurate()) {
            Home home = this.getHome();
            if (!home.isValid()) {
                this.updateCurrentState(3);
                return;
            }
            LatLongAlt homePosition = home.getCoordinate();
            final LatLongAlt locationCoord = location.getCoord();
            float[] results = new float[3];
            android.location.Location.distanceBetween((double)homePosition.getLatitude(), (double)homePosition.getLongitude(), (double)locationCoord.getLatitude(), (double)locationCoord.getLongitude(), (float[])results);
            float displacement = results[0];
            if (displacement >= 5.0f) {
                MavLinkDoCmds.setVehicleHome((MavLinkDrone)this.droneMgr.getDrone(), new LatLongAlt(locationCoord.getLatitude(), locationCoord.getLongitude(), homePosition.getAltitude()), new AbstractCommandListener(){

                    @Override
                    public void onSuccess() {
                        Timber.i((String)"Updated vehicle home location to %s", (Object[])new Object[]{locationCoord.toString()});
                        ((MavLinkDrone)ReturnToMe.this.droneMgr.getDrone()).executeAsyncAction(requestHomeUpdateAction, null);
                        CommonApiUtils.postSuccessEvent(ReturnToMe.this.commandListener);
                        ReturnToMe.this.updateCurrentState(4);
                    }

                    @Override
                    public void onError(int executionError) {
                        Timber.e((String)"Unable to update vehicle home location: %d", (Object[])new Object[]{executionError});
                        CommonApiUtils.postErrorEvent(executionError, ReturnToMe.this.commandListener);
                        ReturnToMe.this.updateCurrentState(5);
                    }

                    @Override
                    public void onTimeout() {
                        Timber.w((String)"Vehicle home update timed out!", (Object[])new Object[0]);
                        CommonApiUtils.postTimeoutEvent(ReturnToMe.this.commandListener);
                        ReturnToMe.this.updateCurrentState(5);
                    }
                });
            }
        } else {
            this.updateCurrentState(2);
        }
    }

    private Home getHome() {
        return (Home)((MavLinkDrone)this.droneMgr.getDrone()).getAttribute("com.o3dr.services.android.lib.attribute.HOME");
    }

    @Override
    public void onLocationUnavailable() {
        if (this.isEnabled.get()) {
            this.updateCurrentState(1);
            this.disable();
        }
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case DISCONNECTED: {
                this.disable();
                break;
            }
            case HOME: {
                if (!this.isEnabled.get()) break;
                LatLongAlt homeCoord = this.getHome().getCoordinate();
                if (this.currentState.getOriginalHomeLocation() == null) {
                    this.currentState.setOriginalHomeLocation(homeCoord);
                    break;
                }
                this.currentState.setCurrentHomeLocation(homeCoord);
            }
        }
    }

    private void updateCurrentState(int state) {
        this.currentState.setState(state);
        if (this.attributeListener != null) {
            Bundle eventInfo = new Bundle();
            eventInfo.putInt("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_RETURN_TO_ME_STATE", state);
            this.attributeListener.onAttributeEvent("com.o3dr.services.android.lib.attribute.event.RETURN_TO_ME_STATE_UPDATE", eventInfo);
        }
    }

    public DroneAttribute getState() {
        return this.currentState;
    }
}

