/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.connection;

import android.os.Bundle;
import android.os.Handler;
import com.o3dr.android.client.utils.connection.AbstractIpConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.droidplanner.services.android.impl.utils.NetworkUtils;

public class TcpConnection
extends AbstractIpConnection {
    private final String serverIp;
    private final int serverPort;
    private Socket socket;
    private BufferedOutputStream connOut;
    private BufferedInputStream connIn;

    public TcpConnection(Handler handler, String serverIp, int serverPort) {
        super(handler);
        this.serverIp = serverIp;
        this.serverPort = serverPort;
    }

    @Override
    protected void open(Bundle extras) throws IOException {
        InetAddress serverAddr = InetAddress.getByName(this.serverIp);
        this.socket = new Socket();
        this.socket.setReuseAddress(true);
        NetworkUtils.bindSocketToNetwork(extras, this.socket);
        this.socket.connect(new InetSocketAddress(serverAddr, this.serverPort), 15000);
        this.connOut = new BufferedOutputStream(this.socket.getOutputStream());
        this.connIn = new BufferedInputStream(this.socket.getInputStream());
    }

    @Override
    protected int read(ByteBuffer buffer) throws IOException {
        return this.connIn.read(buffer.array());
    }

    @Override
    protected void send(AbstractIpConnection.PacketData data) throws IOException {
        this.connOut.write(data.data, 0, data.dataLength);
        this.connOut.flush();
    }

    @Override
    protected void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

