/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink;

import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_command_long;
import com.MAVLink.common.msg_manual_control;
import com.MAVLink.common.msg_mission_item;
import com.MAVLink.common.msg_set_mode;
import com.MAVLink.common.msg_set_position_target_global_int;
import com.MAVLink.common.msg_set_position_target_local_ned;
import com.o3dr.services.android.lib.model.ICommandListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.variables.ApmModes;

public class MavLinkCommands {
    public static final int EMERGENCY_DISARM_MAGIC_NUMBER = 21196;
    private static final int MAVLINK_SET_POS_TYPE_MASK_POS_IGNORE = 7;
    private static final int MAVLINK_SET_POS_TYPE_MASK_VEL_IGNORE = 56;
    private static final int MAVLINK_SET_POS_TYPE_MASK_ACC_IGNORE = 448;

    public static void changeMissionSpeed(MavLinkDrone drone, float speed, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 178;
        msg.param1 = 0.0f;
        msg.param2 = speed;
        msg.param3 = 0.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void setGuidedMode(MavLinkDrone drone, double latitude, double longitude, double d) {
        msg_mission_item msg = new msg_mission_item();
        msg.seq = 0;
        msg.current = (short)2;
        msg.frame = (short)3;
        msg.command = 16;
        msg.param1 = 0.0f;
        msg.param2 = 0.0f;
        msg.param3 = 0.0f;
        msg.param4 = 0.0f;
        msg.x = (float)latitude;
        msg.y = (float)longitude;
        msg.z = (float)d;
        msg.autocontinue = 1;
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, null);
    }

    public static void sendGuidedPosition(MavLinkDrone drone, double latitude, double longitude, double altitude) {
        msg_set_position_target_global_int msg = new msg_set_position_target_global_int();
        msg.type_mask = 504;
        msg.coordinate_frame = (short)6;
        msg.lat_int = (int)(latitude * 1.0E7);
        msg.lon_int = (int)(longitude * 1.0E7);
        msg.alt = (float)altitude;
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, null);
    }

    public static void sendGuidedVelocity(MavLinkDrone drone, double xVel, double yVel, double zVel) {
        msg_set_position_target_global_int msg = new msg_set_position_target_global_int();
        msg.type_mask = 455;
        msg.coordinate_frame = (short)6;
        msg.vx = (float)xVel;
        msg.vy = (float)yVel;
        msg.vz = (float)zVel;
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, null);
    }

    public static void setVelocityInLocalFrame(MavLinkDrone drone, float xVel, float yVel, float zVel, ICommandListener listener) {
        msg_set_position_target_local_ned msg = new msg_set_position_target_local_ned();
        msg.type_mask = 455;
        msg.vx = xVel;
        msg.vy = yVel;
        msg.vz = zVel;
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendGuidedPositionAndVelocity(MavLinkDrone drone, double latitude, double longitude, double altitude, double xVel, double yVel, double zVel) {
        msg_set_position_target_global_int msg = new msg_set_position_target_global_int();
        msg.type_mask = 448;
        msg.coordinate_frame = (short)6;
        msg.lat_int = (int)(latitude * 1.0E7);
        msg.lon_int = (int)(longitude * 1.0E7);
        msg.alt = (float)altitude;
        msg.vx = (float)xVel;
        msg.vy = (float)yVel;
        msg.vz = (float)zVel;
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, null);
    }

    public static void changeFlightMode(MavLinkDrone drone, ApmModes mode, ICommandListener listener) {
        msg_set_mode msg = new msg_set_mode();
        msg.target_system = drone.getSysid();
        msg.base_mode = 1;
        msg.custom_mode = mode.getNumber();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void setConditionYaw(MavLinkDrone drone, float targetAngle, float yawRate, boolean isClockwise, boolean isRelative, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 115;
        msg.param1 = targetAngle;
        msg.param2 = yawRate;
        msg.param3 = isClockwise ? 1.0f : -1.0f;
        msg.param4 = isRelative ? 1.0f : 0.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendManualControl(MavLinkDrone drone, short x, short y, short z, short r, int buttons, ICommandListener listener) {
        msg_manual_control msg = new msg_manual_control();
        msg.target = drone.getSysid();
        msg.x = x;
        msg.y = y;
        msg.z = z;
        msg.r = r;
        msg.buttons = buttons;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendTakeoff(MavLinkDrone drone, double alt, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 22;
        msg.param7 = (float)alt;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendNavLand(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 21;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendNavRTL(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 20;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendPause(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 252;
        msg.param1 = 0.0f;
        msg.param2 = 2.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void startMission(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 300;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendArmMessage(MavLinkDrone drone, boolean arm, boolean emergencyDisarm, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 400;
        msg.param1 = arm ? 1.0f : 0.0f;
        msg.param2 = emergencyDisarm ? 21196.0f : 0.0f;
        msg.param3 = 0.0f;
        msg.param4 = 0.0f;
        msg.param5 = 0.0f;
        msg.param6 = 0.0f;
        msg.param7 = 0.0f;
        msg.confirmation = 0;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void sendFlightTermination(MavLinkDrone drone, ICommandListener listener) {
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 185;
        msg.param1 = 1.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }
}

