/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.Surface;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class CameraApi
extends Api {
    private static final ConcurrentHashMap<Drone, CameraApi> apiCache = new ConcurrentHashMap();
    private static final Api.Builder<CameraApi> apiBuilder = new Api.Builder<CameraApi>(){

        @Override
        public CameraApi build(Drone drone) {
            return new CameraApi(drone);
        }
    };
    public static final String VIDEO_PROPS_UDP_PORT = "extra_video_props_udp_port";
    public static final String VIDEO_ENABLE_LOCAL_RECORDING = "extra_video_enable_local_recording";
    public static final String VIDEO_LOCAL_RECORDING_FILENAME = "extra_video_local_recording_filename";
    private final Drone drone;

    public static CameraApi getApi(Drone drone) {
        return CameraApi.getApi(drone, apiCache, apiBuilder);
    }

    private CameraApi(Drone drone) {
        this.drone = drone;
    }

    public void startVideoStream(@NonNull Surface surface, String tag, @NonNull Bundle videoProps, AbstractCommandListener listener) {
        if (surface == null || videoProps == null) {
            CameraApi.postErrorEvent(4, listener);
            return;
        }
        Bundle params = new Bundle();
        params.putParcelable("extra_video_display", (Parcelable)surface);
        params.putString("extra_video_tag", tag);
        params.putBundle("extra_video_properties", videoProps);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.camera.START_VIDEO_STREAM", params), listener);
    }

    public void stopVideoStream(String tag, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putString("extra_video_tag", tag);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.companion.solo.action.camera.STOP_VIDEO_STREAM", params), listener);
    }
}

