/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.video;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import com.o3dr.android.client.utils.connection.IpConnectionListener;
import com.o3dr.android.client.utils.connection.UdpConnection;
import com.o3dr.android.client.utils.video.DecoderListener;
import com.o3dr.android.client.utils.video.MediaCodecManager;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.utils.video.StreamRecorder;
import timber.log.Timber;

public class VideoManager
implements IpConnectionListener {
    private static final String TAG = VideoManager.class.getSimpleName();
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.US);
    private static final String NO_VIDEO_OWNER = "no_video_owner";
    protected static final long RECONNECT_COUNTDOWN = 1000L;
    public static final int ARTOO_UDP_PORT = 5600;
    private static final int UDP_BUFFER_SIZE = 1500;
    private final AtomicBoolean videoStreamObserverUsed = new AtomicBoolean(false);
    private final DataLink.DataLinkProvider linkProvider;
    private final Runnable reconnectTask = new Runnable(){

        @Override
        public void run() {
            VideoManager.this.handler.removeCallbacks(VideoManager.this.reconnectTask);
            if (VideoManager.this.linkConn != null) {
                VideoManager.this.linkConn.connect(VideoManager.this.linkProvider.getConnectionExtras());
            }
        }
    };
    private LinkListener linkListener;
    protected final Handler handler;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicBoolean wasConnected = new AtomicBoolean(false);
    private final AtomicReference<String> videoOwnerId = new AtomicReference<String>("no_video_owner");
    private final AtomicReference<String> videoTagRef = new AtomicReference<String>("");
    protected UdpConnection linkConn;
    private final MediaCodecManager mediaCodecManager;
    private final StreamRecorder streamRecorder;
    private int linkPort = -1;

    public VideoManager(Context context, Handler handler, DataLink.DataLinkProvider linkProvider) {
        this.streamRecorder = new StreamRecorder(context);
        this.handler = handler;
        this.mediaCodecManager = new MediaCodecManager(handler);
        this.mediaCodecManager.setNaluChunkListener(this.streamRecorder);
        this.linkProvider = linkProvider;
    }

    private void enableLocalRecording(String filename) {
        this.streamRecorder.enableRecording(filename);
    }

    private void disableLocalRecording() {
        this.streamRecorder.disableRecording();
    }

    public void startDecoding(int udpPort, final Surface surface, final DecoderListener listener) {
        this.start(udpPort, null);
        Surface currentSurface = this.mediaCodecManager.getSurface();
        if (surface == currentSurface) {
            if (listener != null) {
                listener.onDecodingStarted();
            }
            return;
        }
        Log.i((String)TAG, (String)"Setting up video stream decoding.");
        this.mediaCodecManager.stopDecoding(new DecoderListener(){

            @Override
            public void onDecodingStarted() {
            }

            @Override
            public void onDecodingError() {
            }

            @Override
            public void onDecodingEnded() {
                block2: {
                    try {
                        Log.i((String)TAG, (String)"Video decoding set up complete. Starting...");
                        VideoManager.this.mediaCodecManager.startDecoding(surface, listener);
                    }
                    catch (IOException | IllegalStateException e) {
                        Log.e((String)TAG, (String)"Unable to create media codec.", (Throwable)e);
                        if (listener == null) break block2;
                        listener.onDecodingError();
                    }
                }
            }
        });
    }

    public void reset() {
        Timber.d((String)"Resetting video tag (%s) and owner id (%s)", (Object[])new Object[]{this.videoTagRef.get(), this.videoOwnerId.get()});
        this.videoTagRef.set("");
        this.videoOwnerId.set(NO_VIDEO_OWNER);
        this.disableLocalRecording();
        this.stopDecoding(null);
    }

    public void stopDecoding(DecoderListener listener) {
        Log.i((String)TAG, (String)"Aborting video decoding process.");
        this.mediaCodecManager.stopDecoding(listener);
        this.stop();
    }

    public boolean isLinkConnected() {
        return this.linkConn != null && this.linkConn.getConnectionStatus() == 2;
    }

    private void start(int udpPort, LinkListener listener) {
        if (this.linkConn == null || udpPort != this.linkPort) {
            if (this.isStarted.get()) {
                this.stop();
            }
            this.linkConn = new UdpConnection(this.handler, udpPort, 1500, true, 42);
            this.linkConn.setIpConnectionListener(this);
            this.linkPort = udpPort;
        }
        Log.d((String)TAG, (String)"Starting video manager");
        this.handler.removeCallbacks(this.reconnectTask);
        this.isStarted.set(true);
        this.streamRecorder.startConverterThread();
        this.linkConn.connect(this.linkProvider.getConnectionExtras());
        this.linkListener = listener;
    }

    private void stop() {
        Log.d((String)TAG, (String)"Stopping video manager");
        this.handler.removeCallbacks(this.reconnectTask);
        this.isStarted.set(false);
        if (this.linkConn != null) {
            this.linkConn.disconnect();
            this.linkConn = null;
        }
        this.linkPort = -1;
        this.streamRecorder.stopConverterThread();
    }

    @Override
    public void onIpConnected() {
        Log.d((String)TAG, (String)"Connected to video stream");
        this.handler.removeCallbacks(this.reconnectTask);
        this.wasConnected.set(true);
        if (this.linkListener != null) {
            this.linkListener.onLinkConnected();
        }
    }

    @Override
    public void onIpDisconnected() {
        Log.d((String)TAG, (String)"Video stream disconnected");
        if (this.isStarted.get()) {
            if (this.shouldReconnect()) {
                this.handler.postDelayed(this.reconnectTask, 1000L);
            }
            if (this.linkListener != null && this.wasConnected.get()) {
                this.linkListener.onLinkDisconnected();
            }
            this.wasConnected.set(false);
        }
    }

    @Override
    public void onPacketReceived(ByteBuffer packetBuffer) {
        if (!this.videoStreamObserverUsed.get()) {
            this.mediaCodecManager.onInputDataReceived(packetBuffer.array(), packetBuffer.limit());
        }
    }

    protected void postSuccessEvent(final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onSuccess();
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    protected void postTimeoutEvent(final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onTimeout();
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    protected void postErrorEvent(final int error, final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(error);
                    }
                    catch (RemoteException e) {
                        Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    protected boolean shouldReconnect() {
        return true;
    }

    private void checkForLocalRecording(String appId, Bundle videoProps) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return;
        }
        boolean isLocalRecordingEnabled = videoProps.getBoolean("extra_video_enable_local_recording");
        if (isLocalRecordingEnabled) {
            String localRecordingFilename = videoProps.getString("extra_video_local_recording_filename");
            if (TextUtils.isEmpty((CharSequence)localRecordingFilename)) {
                localRecordingFilename = appId + "." + FILE_DATE_FORMAT.format(new Date());
            }
            if (!localRecordingFilename.equalsIgnoreCase(this.streamRecorder.getRecordingFilename())) {
                if (this.streamRecorder.isRecordingEnabled()) {
                    this.disableLocalRecording();
                }
                this.enableLocalRecording(localRecordingFilename);
            }
        } else {
            this.disableLocalRecording();
        }
    }

    public void startVideoStream(Bundle videoProps, String appId, String newVideoTag, Surface videoSurface, final ICommandListener listener) {
        Timber.d((String)"Video stream start request from %s. Video owner is %s.", (Object[])new Object[]{appId, this.videoOwnerId.get()});
        if (!this.isAppIdValid(appId, listener)) {
            return;
        }
        int udpPort = videoProps.getInt("extra_video_props_udp_port", -1);
        if (videoSurface == null || udpPort == -1) {
            this.postErrorEvent(4, listener);
            return;
        }
        if (newVideoTag == null) {
            newVideoTag = "";
        }
        if (appId.equals(this.videoOwnerId.get())) {
            String currentVideoTag = this.videoTagRef.get();
            if (currentVideoTag == null) {
                currentVideoTag = "";
            }
            if (newVideoTag.equals(currentVideoTag)) {
                this.checkForLocalRecording(appId, videoProps);
                this.postSuccessEvent(listener);
                return;
            }
        }
        if (this.videoOwnerId.compareAndSet(NO_VIDEO_OWNER, appId)) {
            this.videoTagRef.set(newVideoTag);
            this.checkForLocalRecording(appId, videoProps);
            Timber.i((String)"Starting video decoding.", (Object[])new Object[0]);
            this.startDecoding(udpPort, videoSurface, new DecoderListener(){

                @Override
                public void onDecodingStarted() {
                    Timber.i((String)"Video decoding started.", (Object[])new Object[0]);
                    VideoManager.this.postSuccessEvent(listener);
                }

                @Override
                public void onDecodingError() {
                    Timber.i((String)"Video decoding failed.", (Object[])new Object[0]);
                    VideoManager.this.postErrorEvent(4, listener);
                    VideoManager.this.reset();
                }

                @Override
                public void onDecodingEnded() {
                    Timber.i((String)"Video decoding ended successfully.", (Object[])new Object[0]);
                    VideoManager.this.reset();
                }
            });
        } else {
            this.postErrorEvent(2, listener);
        }
    }

    public void startVideoStreamForObserver(String appId, String newVideoTag, ICommandListener listener) {
        Timber.d((String)"Video stream start request from %s. Video owner is %s.", (Object[])new Object[]{appId, this.videoOwnerId.get()});
        if (!this.isAppIdValid(appId, listener)) {
            return;
        }
        if (newVideoTag == null) {
            newVideoTag = "";
        }
        if (appId.equals(this.videoOwnerId.get())) {
            String currentVideoTag = this.videoTagRef.get();
            if (currentVideoTag == null) {
                currentVideoTag = "";
            }
            if (newVideoTag.equals(currentVideoTag)) {
                this.postSuccessEvent(listener);
                return;
            }
        }
        if (this.videoOwnerId.compareAndSet(NO_VIDEO_OWNER, appId)) {
            this.videoTagRef.set(newVideoTag);
            Timber.i((String)"Successful lock obtained for app with id %s.", (Object[])new Object[]{appId});
            this.videoStreamObserverUsed.set(true);
            this.postSuccessEvent(listener);
        } else {
            this.postErrorEvent(2, listener);
        }
    }

    public void stopVideoStream(String appId, String currentVideoTag, final ICommandListener listener) {
        Timber.d((String)"Video stream stop request from %s. Video owner is %s.", (Object[])new Object[]{appId, this.videoOwnerId.get()});
        if (!this.isAppIdValid(appId, listener)) {
            return;
        }
        String currentVideoOwner = this.videoOwnerId.get();
        if (NO_VIDEO_OWNER.equals(currentVideoOwner)) {
            Timber.d((String)"No video owner set. Nothing to do.", (Object[])new Object[0]);
            this.disableLocalRecording();
            this.postSuccessEvent(listener);
            return;
        }
        if (currentVideoTag == null) {
            currentVideoTag = "";
        }
        if (appId.equals(currentVideoOwner) && currentVideoTag.equals(this.videoTagRef.get()) && this.videoOwnerId.compareAndSet(currentVideoOwner, NO_VIDEO_OWNER)) {
            this.videoTagRef.set("");
            this.disableLocalRecording();
            Timber.d((String)"Stopping video decoding. Current owner is %s.", (Object[])new Object[]{currentVideoOwner});
            Timber.i((String)"Stopping video decoding.", (Object[])new Object[0]);
            this.stopDecoding(new DecoderListener(){

                @Override
                public void onDecodingStarted() {
                }

                @Override
                public void onDecodingError() {
                    VideoManager.this.postSuccessEvent(listener);
                }

                @Override
                public void onDecodingEnded() {
                    VideoManager.this.postSuccessEvent(listener);
                }
            });
        } else {
            this.postErrorEvent(2, listener);
        }
    }

    public void stopVideoStreamForObserver(String appId, String currentVideoTag, ICommandListener listener) {
        Timber.d((String)"Video stream stop request from %s. Video owner is %s.", (Object[])new Object[]{appId, this.videoOwnerId.get()});
        if (!this.isAppIdValid(appId, listener)) {
            return;
        }
        String currentVideoOwner = this.videoOwnerId.get();
        if (NO_VIDEO_OWNER.equals(currentVideoOwner)) {
            Timber.d((String)"No video owner set. Nothing to do.", (Object[])new Object[0]);
            this.postSuccessEvent(listener);
            return;
        }
        if (currentVideoTag == null) {
            currentVideoTag = "";
        }
        if (appId.equals(currentVideoOwner) && currentVideoTag.equals(this.videoTagRef.get()) && this.videoOwnerId.compareAndSet(currentVideoOwner, NO_VIDEO_OWNER)) {
            this.videoTagRef.set("");
            Timber.d((String)"Stopping video decoding. Current owner is %s.", (Object[])new Object[]{currentVideoOwner});
            Timber.i((String)"Stop using video observer...", (Object[])new Object[0]);
            this.videoStreamObserverUsed.set(false);
            this.postSuccessEvent(listener);
        } else {
            this.postErrorEvent(2, listener);
        }
    }

    public void tryStoppingVideoStream(String parentId) {
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            return;
        }
        String videoOwner = this.videoOwnerId.get();
        if (NO_VIDEO_OWNER.equals(videoOwner)) {
            return;
        }
        if (videoOwner.equals(parentId)) {
            Timber.d((String)"Stopping video owned by %s", (Object[])new Object[]{parentId});
            if (this.videoStreamObserverUsed.get()) {
                this.stopVideoStreamForObserver(parentId, this.videoTagRef.get(), null);
            } else {
                this.stopVideoStream(parentId, this.videoTagRef.get(), null);
            }
        }
    }

    private boolean isAppIdValid(String appId, ICommandListener listener) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            Timber.w((String)"Owner id is empty.", (Object[])new Object[0]);
            this.postErrorEvent(2, listener);
            return false;
        }
        return true;
    }

    public static interface LinkListener {
        public void onLinkConnected();

        public void onLinkDisconnected();
    }
}

