/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.waypoints;

import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemType;
import org.droidplanner.services.android.impl.core.mission.waypoints.SpatialCoordItem;

public class CircleImpl
extends SpatialCoordItem {
    private double radius = 10.0;
    private int turns = 1;

    public CircleImpl(MissionItemImpl item) {
        super(item);
    }

    public CircleImpl(MissionImpl missionImpl, LatLongAlt coord) {
        super(missionImpl, coord);
    }

    public CircleImpl(msg_mission_item msg, MissionImpl missionImpl) {
        super(missionImpl, null);
        this.unpackMAVMessage(msg);
    }

    public void setTurns(int turns) {
        this.turns = Math.abs(turns);
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public int getNumberOfTurns() {
        return this.turns;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        ArrayList<msg_mission_item> list = new ArrayList<msg_mission_item>();
        this.packSingleCircle(list);
        return list;
    }

    private void packSingleCircle(List<msg_mission_item> list) {
        msg_mission_item mavMsg = new msg_mission_item();
        list.add(mavMsg);
        mavMsg.autocontinue = 1;
        mavMsg.frame = (short)3;
        mavMsg.x = (float)this.coordinate.getLatitude();
        mavMsg.y = (float)this.coordinate.getLongitude();
        mavMsg.z = (float)this.coordinate.getAltitude();
        mavMsg.command = 18;
        mavMsg.param1 = Math.abs(this.turns);
        mavMsg.param3 = (float)this.radius;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
        super.unpackMAVMessage(mavMsg);
        this.setTurns((int)mavMsg.param1);
        this.setRadius(mavMsg.param3);
    }

    @Override
    public MissionItemType getType() {
        return MissionItemType.CIRCLE;
    }
}

