/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission;

import android.util.Pair;
import com.MAVLink.common.msg_mission_ack;
import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.drone.property.Attitude;
import com.o3dr.services.android.lib.drone.property.Gps;
import com.o3dr.services.android.lib.drone.property.Home;
import com.o3dr.services.android.lib.drone.property.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.generic.GenericMavLinkDrone;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.commands.ChangeSpeedImpl;
import org.droidplanner.services.android.impl.core.mission.commands.ReturnToHomeImpl;
import org.droidplanner.services.android.impl.core.mission.commands.TakeoffImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.LandImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.RegionOfInterestImpl;
import org.droidplanner.services.android.impl.core.mission.waypoints.SpatialCoordItem;
import org.droidplanner.services.android.impl.core.mission.waypoints.WaypointImpl;
import org.droidplanner.services.android.impl.utils.MissionUtils;

public class MissionImpl
extends DroneVariable<GenericMavLinkDrone> {
    private List<MissionItemImpl> items = new ArrayList<MissionItemImpl>();
    private final List<MissionItemImpl> componentItems = new ArrayList<MissionItemImpl>();

    public MissionImpl(GenericMavLinkDrone myDrone) {
        super(myDrone);
    }

    public void removeWaypoint(MissionItemImpl item) {
        this.items.remove(item);
        this.notifyMissionUpdate();
    }

    public void removeWaypoints(List<MissionItemImpl> toRemove) {
        this.items.removeAll(toRemove);
        this.notifyMissionUpdate();
    }

    public void addMissionItems(List<MissionItemImpl> missionItemImpls) {
        this.items.addAll(missionItemImpls);
        this.notifyMissionUpdate();
    }

    public void clearMissionItems() {
        this.items.clear();
        this.notifyMissionUpdate();
    }

    public void addMissionItem(MissionItemImpl missionItemImpl) {
        this.items.add(missionItemImpl);
        this.notifyMissionUpdate();
    }

    public void addMissionItem(int index, MissionItemImpl missionItemImpl) {
        this.items.add(index, missionItemImpl);
        this.notifyMissionUpdate();
    }

    public void notifyMissionUpdate() {
        this.updateComponentItems();
        ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.MISSION_UPDATE);
    }

    public void replace(MissionItemImpl oldItem, MissionItemImpl newItem) {
        int index = this.items.indexOf(oldItem);
        if (index == -1) {
            return;
        }
        this.items.remove(index);
        this.items.add(index, newItem);
        this.notifyMissionUpdate();
    }

    public void replaceAll(List<Pair<MissionItemImpl, MissionItemImpl>> updatesList) {
        if (updatesList == null || updatesList.isEmpty()) {
            return;
        }
        boolean wasUpdated = false;
        for (Pair<MissionItemImpl, MissionItemImpl> updatePair : updatesList) {
            MissionItemImpl oldItem = (MissionItemImpl)updatePair.first;
            int index = this.items.indexOf(oldItem);
            if (index == -1) continue;
            MissionItemImpl newItem = (MissionItemImpl)updatePair.second;
            this.items.remove(index);
            this.items.add(index, newItem);
            wasUpdated = true;
        }
        if (wasUpdated) {
            this.notifyMissionUpdate();
        }
    }

    public void reverse() {
        Collections.reverse(this.items);
        this.notifyMissionUpdate();
    }

    public void onWriteWaypoints(msg_mission_ack msg) {
        ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.MISSION_SENT);
    }

    public List<MissionItemImpl> getItems() {
        return this.items;
    }

    public List<MissionItemImpl> getComponentItems() {
        return this.componentItems;
    }

    public int getOrder(MissionItemImpl waypoint) {
        return this.items.indexOf(waypoint) + 1;
    }

    public double getAltitudeDiffFromPreviousItem(SpatialCoordItem waypoint) throws IllegalArgumentException {
        MissionItemImpl previous;
        int i = this.items.indexOf(waypoint);
        if (i > 0 && (previous = this.items.get(i - 1)) instanceof SpatialCoordItem) {
            return waypoint.getCoordinate().getAltitude() - ((SpatialCoordItem)previous).getCoordinate().getAltitude();
        }
        throw new IllegalArgumentException("Last waypoint doesn't have an altitude");
    }

    public double getDistanceFromLastWaypoint(SpatialCoordItem waypoint) throws IllegalArgumentException {
        MissionItemImpl previous;
        int i = this.items.indexOf(waypoint);
        if (i > 0 && (previous = this.items.get(i - 1)) instanceof SpatialCoordItem) {
            return GeoTools.getDistance(waypoint.getCoordinate(), ((SpatialCoordItem)previous).getCoordinate());
        }
        throw new IllegalArgumentException("Last waypoint doesn't have a coordinate");
    }

    public boolean hasItem(MissionItemImpl item) {
        return this.items.contains(item);
    }

    public void onMissionReceived(List<msg_mission_item> msgs) {
        if (msgs != null) {
            ((GenericMavLinkDrone)this.myDrone).processHomeUpdate(msgs.get(0));
            msgs.remove(0);
            this.items.clear();
            this.items.addAll(MissionUtils.processMavLinkMessages(this, msgs));
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.MISSION_RECEIVED);
            this.notifyMissionUpdate();
        }
    }

    public void onMissionLoaded(List<msg_mission_item> msgs) {
        if (msgs != null) {
            ((GenericMavLinkDrone)this.myDrone).processHomeUpdate(msgs.get(0));
            msgs.remove(0);
            this.items.clear();
            this.items.addAll(MissionUtils.processMavLinkMessages(this, msgs));
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.MISSION_RECEIVED);
            this.notifyMissionUpdate();
        }
    }

    public void sendMissionToAPM() {
        List<msg_mission_item> msgMissionItems = this.getMsgMissionItems();
        ((GenericMavLinkDrone)this.myDrone).getWaypointManager().writeWaypoints(msgMissionItems);
        this.updateComponentItems(msgMissionItems);
    }

    private void updateComponentItems() {
        List<msg_mission_item> msgMissionItems = this.getMsgMissionItems();
        this.updateComponentItems(msgMissionItems);
    }

    private void updateComponentItems(List<msg_mission_item> msgMissionItems) {
        this.componentItems.clear();
        if (msgMissionItems == null || msgMissionItems.isEmpty()) {
            return;
        }
        msg_mission_item firstItem = msgMissionItems.get(0);
        if (firstItem.seq == 0) {
            msgMissionItems.remove(0);
        }
        this.componentItems.addAll(MissionUtils.processMavLinkMessages(this, msgMissionItems));
    }

    public msg_mission_item packHomeMavlink() {
        Home home = (Home)((GenericMavLinkDrone)this.myDrone).getAttribute("com.o3dr.services.android.lib.attribute.HOME");
        LatLongAlt coordinate = home.getCoordinate();
        msg_mission_item mavMsg = new msg_mission_item();
        mavMsg.autocontinue = 1;
        mavMsg.command = 16;
        mavMsg.current = 0;
        mavMsg.frame = 0;
        mavMsg.target_system = ((GenericMavLinkDrone)this.myDrone).getSysid();
        mavMsg.target_component = ((GenericMavLinkDrone)this.myDrone).getCompid();
        if (home.isValid()) {
            mavMsg.x = (float)coordinate.getLatitude();
            mavMsg.y = (float)coordinate.getLongitude();
            mavMsg.z = (float)coordinate.getAltitude();
        }
        return mavMsg;
    }

    public List<msg_mission_item> getMsgMissionItems() {
        ArrayList<msg_mission_item> data = new ArrayList<msg_mission_item>();
        int waypointCount = 0;
        msg_mission_item home = this.packHomeMavlink();
        home.seq = waypointCount++;
        data.add(home);
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            MissionItemImpl item = this.items.get(i);
            for (msg_mission_item msg_item : item.packMissionItem()) {
                msg_item.seq = waypointCount++;
                data.add(msg_item);
            }
        }
        return data;
    }

    public double makeAndUploadDronie() {
        Gps droneGps = (Gps)((GenericMavLinkDrone)this.myDrone).getAttribute("com.o3dr.services.android.lib.attribute.GPS");
        LatLong currentPosition = droneGps.getPosition();
        if (currentPosition == null || droneGps.getSatellitesCount() <= 5) {
            ((GenericMavLinkDrone)this.myDrone).notifyDroneEvent(DroneInterfaces.DroneEventsType.WARNING_NO_GPS);
            return -1.0;
        }
        Attitude attitude = (Attitude)((GenericMavLinkDrone)this.myDrone).getAttribute("com.o3dr.services.android.lib.attribute.ATTITUDE");
        double bearing = 180.0 + attitude.getYaw();
        this.items.clear();
        this.items.addAll(this.createDronie(currentPosition, GeoTools.newCoordFromBearingAndDistance(currentPosition, bearing, 50.0)));
        this.sendMissionToAPM();
        this.notifyMissionUpdate();
        return bearing;
    }

    private double getSpeedParameter() {
        Parameter param = ((GenericMavLinkDrone)this.myDrone).getParameterManager().getParameter("WPNAV_SPEED");
        if (param == null) {
            return -1.0;
        }
        return param.getValue() / 100.0;
    }

    public List<MissionItemImpl> createDronie(LatLong start, LatLong end) {
        int startAltitude = 4;
        int roiDistance = -8;
        LatLong slowDownPoint = GeoTools.pointAlongTheLine(start, end, 5);
        double defaultSpeed = this.getSpeedParameter();
        if (defaultSpeed == -1.0) {
            defaultSpeed = 5.0;
        }
        ArrayList<MissionItemImpl> dronieItems = new ArrayList<MissionItemImpl>();
        dronieItems.add(new TakeoffImpl(this, 4.0));
        dronieItems.add(new RegionOfInterestImpl(this, new LatLongAlt(GeoTools.pointAlongTheLine(start, end, -8), 1.0)));
        dronieItems.add(new WaypointImpl(this, new LatLongAlt(end, 4.0 + GeoTools.getDistance(start, end) / 2.0)));
        dronieItems.add(new WaypointImpl(this, new LatLongAlt(slowDownPoint, 4.0 + GeoTools.getDistance(start, slowDownPoint) / 2.0)));
        dronieItems.add(new ChangeSpeedImpl(this, 1.0));
        dronieItems.add(new WaypointImpl(this, new LatLongAlt(start, 4.0)));
        dronieItems.add(new ChangeSpeedImpl(this, defaultSpeed));
        dronieItems.add(new LandImpl(this, start));
        return dronieItems;
    }

    public boolean hasTakeoffAndLandOrRTL() {
        return this.items.size() >= 2 && this.isFirstItemTakeoff() && this.isLastItemLandOrRTL();
    }

    public boolean isFirstItemTakeoff() {
        return !this.items.isEmpty() && this.items.get(0) instanceof TakeoffImpl;
    }

    public boolean isLastItemLandOrRTL() {
        if (this.items.isEmpty()) {
            return false;
        }
        MissionItemImpl last = this.items.get(this.items.size() - 1);
        return last instanceof ReturnToHomeImpl || last instanceof LandImpl;
    }
}

