/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import com.o3dr.services.android.lib.drone.companion.solo.button.ButtonPacket;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSetting;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingSetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproState;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproStateV2;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloMessageLocation;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.controller.ControllerLinkListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.controller.ControllerLinkManager;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.sololink.SoloLinkListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.sololink.SoloLinkManager;
import org.droidplanner.services.android.impl.utils.NetworkUtils;
import timber.log.Timber;

public class SoloComp
implements SoloLinkListener,
ControllerLinkListener {
    public static final String SOLO_LINK_WIFI_PREFIX = "SoloLink_";
    public static final String SSH_USERNAME = "root";
    public static final String SSH_PASSWORD = "TjSDBkAu";
    private final ControllerLinkManager controllerLinkManager;
    private final SoloLinkManager soloLinkMgr;
    private final Context context;
    private final Handler handler;
    private final ExecutorService asyncExecutor;
    private SoloCompListener compListener;
    private SoloGoproState goproState;
    private SoloGoproStateV2 goproStateV2;

    public SoloComp(Context context, Handler handler, DataLink.DataLinkProvider mavClient) {
        this.context = context;
        this.handler = handler;
        this.asyncExecutor = Executors.newCachedThreadPool();
        this.controllerLinkManager = new ControllerLinkManager(context, handler, this.asyncExecutor, mavClient);
        this.soloLinkMgr = new SoloLinkManager(context, handler, this.asyncExecutor, mavClient);
    }

    public SoloGoproState getGoproState() {
        return this.goproState;
    }

    public SoloGoproStateV2 getGoproStateV2() {
        return this.goproStateV2;
    }

    public boolean hasStreamingPermission() {
        return this.controllerLinkManager.hasStreamingPermission();
    }

    public void setListener(SoloCompListener listener) {
        this.compListener = listener;
    }

    public static boolean isAvailable(Context context) {
        return NetworkUtils.isOnSololinkNetwork(context);
    }

    public void start() {
        if (!SoloComp.isAvailable(this.context)) {
            return;
        }
        this.controllerLinkManager.start(this);
        this.soloLinkMgr.start(this);
    }

    public void stop() {
        this.soloLinkMgr.stop();
        this.controllerLinkManager.stop();
    }

    public void refreshState() {
        this.soloLinkMgr.refreshState();
        this.controllerLinkManager.refreshState();
    }

    public void destroy() {
        this.stop();
        this.asyncExecutor.shutdownNow();
    }

    @Override
    public void onTlvPacketReceived(TLVPacket packet) {
        if (packet == null) {
            return;
        }
        switch (packet.getMessageType()) {
            case 5005: {
                this.goproState = (SoloGoproState)packet;
                Timber.d((String)"Updated gopro state.", (Object[])new Object[0]);
                break;
            }
            case 5006: {
                this.goproStateV2 = (SoloGoproStateV2)packet;
                Timber.i((String)"Updated gopro state.", (Object[])new Object[0]);
            }
        }
        if (this.compListener != null) {
            this.compListener.onTlvPacketReceived(packet);
        }
    }

    @Override
    public void onWifiInfoUpdated(String wifiName, String wifiPassword) {
        if (this.compListener != null) {
            this.compListener.onWifiInfoUpdated(wifiName, wifiPassword);
        }
    }

    @Override
    public void onButtonPacketReceived(ButtonPacket packet) {
        if (this.compListener != null) {
            this.compListener.onButtonPacketReceived(packet);
        }
    }

    @Override
    public void onTxPowerComplianceCountryUpdated(String compliantCountry) {
        if (this.compListener != null) {
            this.compListener.onTxPowerComplianceCountryUpdated(compliantCountry);
        }
    }

    @Override
    public void onControllerModeUpdated() {
        if (this.compListener != null) {
            Bundle eventInfo = new Bundle();
            eventInfo.putInt("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_CONTROLLER_MODE", this.getControllerMode());
            this.compListener.onControllerEvent("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_CONTROLLER_MODE_UPDATED", eventInfo);
        }
    }

    @Override
    public void onControllerUnitUpdated(String trimmedResponse) {
        if (this.compListener != null) {
            Bundle eventInfo = new Bundle();
            eventInfo.putString("com.o3dr.services.android.lib.drone.companion.solo.event.extra.EXTRA_SOLO_CONTROLLER_UNIT", trimmedResponse);
            this.compListener.onControllerEvent("com.o3dr.services.android.lib.drone.companion.solo.event.SOLO_CONTROLLER_UNIT_UPDATED", eventInfo);
        }
    }

    @Override
    public void onPresetButtonLoaded(int buttonType, SoloButtonSetting buttonSettings) {
        if (this.compListener != null) {
            this.compListener.onPresetButtonLoaded(buttonType, buttonSettings);
        }
    }

    @Override
    public void onLinkConnected() {
        if (this.isConnected()) {
            if (this.compListener != null) {
                this.compListener.onConnected();
            }
        } else {
            if (!this.controllerLinkManager.isLinkConnected()) {
                this.controllerLinkManager.start(this);
            }
            if (!this.soloLinkMgr.isLinkConnected()) {
                this.soloLinkMgr.start(this);
            }
        }
    }

    @Override
    public void onLinkDisconnected() {
        if (this.compListener != null) {
            this.compListener.onDisconnected();
        }
        this.soloLinkMgr.stop();
        this.controllerLinkManager.stop();
    }

    @Override
    public void onVersionsUpdated() {
        if (this.compListener != null) {
            this.compListener.onVersionsUpdated();
        }
    }

    @Override
    public void onMacAddressUpdated() {
        String soloMacAddress = this.soloLinkMgr.getMacAddress();
        String artooMacAddress = this.controllerLinkManager.getMacAddress();
        if (!TextUtils.isEmpty((CharSequence)soloMacAddress) && !TextUtils.isEmpty((CharSequence)artooMacAddress) && this.compListener != null) {
            this.compListener.onControllerEvent("com.o3dr.services.android.lib.attribute.event.STATE_VEHICLE_UID", null);
        }
    }

    public boolean isConnected() {
        return this.controllerLinkManager.isLinkConnected() && this.soloLinkMgr.isLinkConnected();
    }

    public Pair<String, String> getWifiSettings() {
        return this.controllerLinkManager.getSoloLinkWifiInfo();
    }

    public String getTxPowerCompliantCountry() {
        return this.controllerLinkManager.getTxPowerCompliantCountry();
    }

    public void refreshSoloVersions() {
        this.soloLinkMgr.refreshSoloLinkVersions();
        this.controllerLinkManager.refreshControllerVersions();
    }

    public String getControllerVersion() {
        return this.controllerLinkManager.getArtooVersion();
    }

    public String getControllerFirmwareVersion() {
        return this.controllerLinkManager.getStm32Version();
    }

    public String getVehicleVersion() {
        return this.soloLinkMgr.getVehicleVersion();
    }

    public int getControllerMode() {
        return this.controllerLinkManager.getControllerMode();
    }

    public String getControllerUnit() {
        return this.controllerLinkManager.getControllerUnit();
    }

    public String getSoloMacAddress() {
        return this.soloLinkMgr.getMacAddress();
    }

    public String getControllerMacAddress() {
        return this.controllerLinkManager.getMacAddress();
    }

    public String getAutopilotVersion() {
        return this.soloLinkMgr.getPixhawkVersion();
    }

    public String getGimbalVersion() {
        return this.soloLinkMgr.getGimbalVersion();
    }

    public SoloButtonSetting getButtonSetting(int buttonType) {
        return this.soloLinkMgr.getLoadedPresetButton(buttonType);
    }

    public SparseArray<SoloButtonSetting> getButtonSettings() {
        SparseArray buttonSettings = new SparseArray(2);
        buttonSettings.append(4, (Object)this.soloLinkMgr.getLoadedPresetButton(4));
        buttonSettings.append(5, (Object)this.soloLinkMgr.getLoadedPresetButton(5));
        return buttonSettings;
    }

    public void sendSoloLinkMessage(TLVPacket message, ICommandListener listener) {
        this.soloLinkMgr.sendTLVPacket(message, listener);
    }

    public void updateWifiSettings(final String wifiSsid, final String wifiPassword, final ICommandListener listener) {
        this.postAsyncTask(new Runnable(){

            @Override
            public void run() {
                if (SoloComp.this.soloLinkMgr.updateSololinkWifi(wifiSsid, wifiPassword) && SoloComp.this.controllerLinkManager.updateSololinkWifi(wifiSsid, wifiPassword)) {
                    Timber.d((String)"Sololink wifi update successful.", (Object[])new Object[0]);
                    if (listener != null) {
                        SoloComp.this.postSuccessEvent(listener);
                    }
                } else {
                    Timber.d((String)"Sololink wifi update failed.", (Object[])new Object[0]);
                    if (listener != null) {
                        SoloComp.this.postErrorEvent(4, listener);
                    }
                }
            }
        });
    }

    public void pushButtonSettings(SoloButtonSettingSetter buttonSettings, ICommandListener listener) {
        this.soloLinkMgr.pushPresetButtonSettings(buttonSettings, listener);
    }

    public void updateControllerMode(int selectedMode, ICommandListener listener) {
        this.controllerLinkManager.updateControllerMode(selectedMode, listener);
    }

    public void updateControllerUnit(String selectedUnit, ICommandListener listener) {
        this.controllerLinkManager.updateControllerUnit(selectedUnit, listener);
    }

    public void updateTxPowerComplianceCountry(String compliantCountry, ICommandListener listener) {
        this.controllerLinkManager.setTxPowerComplianceCountry(compliantCountry, listener);
    }

    protected void postAsyncTask(Runnable task) {
        if (this.asyncExecutor != null && !this.asyncExecutor.isShutdown()) {
            this.asyncExecutor.execute(task);
        }
    }

    protected void postSuccessEvent(final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onSuccess();
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected void postTimeoutEvent(final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onTimeout();
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected void postErrorEvent(final int error, final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(error);
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    public void enableFollowDataConnection() {
        this.soloLinkMgr.enableFollowDataConnection();
    }

    public void disableFollowDataConnection() {
        this.soloLinkMgr.disableFollowDataConnection();
    }

    public void updateFollowCenter(SoloMessageLocation location) {
        this.soloLinkMgr.sendTLVPacket(location, true, null);
    }

    public static interface SoloCompListener {
        public void onConnected();

        public void onDisconnected();

        public void onTlvPacketReceived(TLVPacket var1);

        public void onPresetButtonLoaded(int var1, SoloButtonSetting var2);

        public void onWifiInfoUpdated(String var1, String var2);

        public void onButtonPacketReceived(ButtonPacket var1);

        public void onTxPowerComplianceCountryUpdated(String var1);

        public void onVersionsUpdated();

        public void onControllerEvent(String var1, Bundle var2);
    }
}

