/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink.connection;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.util.Pair;
import com.MAVLink.MAVLinkPacket;
import com.MAVLink.Parser;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import com.o3dr.services.android.lib.util.UriUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.core.MAVLink.connection.MavLinkConnectionListener;
import org.droidplanner.services.android.impl.core.model.Logger;

public abstract class MavLinkConnection {
    private static final String TAG = MavLinkConnection.class.getSimpleName();
    public static final int MAVLINK_DISCONNECTED = 0;
    public static final int MAVLINK_CONNECTING = 1;
    public static final int MAVLINK_CONNECTED = 2;
    private static final int READ_BUFFER_SIZE = 4096;
    public static final String EXTRA_NETWORK = "extra_network";
    private final ConcurrentHashMap<String, MavLinkConnectionListener> mListeners = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Pair<Uri, BufferedOutputStream>> loggingOutStreams = new ConcurrentHashMap();
    private final LinkedBlockingQueue<byte[]> mPacketsToSend = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<byte[]> mPacketsToLog = new LinkedBlockingQueue();
    private final AtomicInteger mConnectionStatus = new AtomicInteger(0);
    private final AtomicLong mConnectionTime = new AtomicLong(-1L);
    private final AtomicReference<Bundle> extrasHolder = new AtomicReference();
    private final Runnable mConnectingTask = new Runnable(){

        @Override
        public void run() {
            MavLinkConnection.this.loadPreferences();
            try {
                MavLinkConnection.this.openConnection((Bundle)MavLinkConnection.this.extrasHolder.get());
            }
            catch (IOException e) {
                if (MavLinkConnection.this.mConnectionStatus.get() != 0) {
                    MavLinkConnection.this.reportIOException(e);
                    MavLinkConnection.this.mLogger.logErr(TAG, e);
                }
                MavLinkConnection.this.disconnect();
            }
            MavLinkConnection.this.mLogger.logInfo(TAG, "Exiting connecting thread.");
        }
    };
    private final Runnable mManagerTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread sendingThread = null;
            Thread loggingThread = null;
            try {
                long connectionTime = System.currentTimeMillis();
                MavLinkConnection.this.mConnectionTime.set(connectionTime);
                MavLinkConnection.this.reportConnect(connectionTime);
                MavLinkConnection.this.mLogger.logInfo(TAG, "Starting sender thread.");
                sendingThread = new Thread(MavLinkConnection.this.mSendingTask, "MavLinkConnection-Sending Thread");
                sendingThread.start();
                MavLinkConnection.this.mLogger.logInfo(TAG, "Starting logging thread.");
                loggingThread = new Thread(MavLinkConnection.this.mLoggingTask, "MavLinkConnection-Logging Thread");
                loggingThread.start();
                Parser parser = new Parser();
                parser.stats.mavlinkResetStats();
                byte[] readBuffer = new byte[4096];
                while (MavLinkConnection.this.mConnectionStatus.get() == 2) {
                    int bufferSize = MavLinkConnection.this.readDataBlock(readBuffer);
                    this.handleData(parser, bufferSize, readBuffer);
                }
            }
            catch (IOException e) {
                if (MavLinkConnection.this.mConnectionStatus.get() != 0) {
                    MavLinkConnection.this.reportIOException(e);
                    MavLinkConnection.this.mLogger.logErr(TAG, e);
                }
            }
            finally {
                if (sendingThread != null && sendingThread.isAlive()) {
                    sendingThread.interrupt();
                }
                if (loggingThread != null && loggingThread.isAlive()) {
                    loggingThread.interrupt();
                }
                MavLinkConnection.this.disconnect();
                MavLinkConnection.this.mLogger.logInfo(TAG, "Exiting manager thread.");
            }
        }

        private void handleData(Parser parser, int bufferSize, byte[] buffer) {
            if (bufferSize < 1) {
                return;
            }
            for (int i = 0; i < bufferSize; ++i) {
                MAVLinkPacket receivedPacket = parser.mavlink_parse_char(buffer[i] & 0xFF);
                if (receivedPacket == null) continue;
                MavLinkConnection.this.queueToLog(receivedPacket);
                MavLinkConnection.this.reportReceivedPacket(receivedPacket);
            }
        }
    };
    private final Runnable mSendingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                block7: while (true) {
                    try {
                        while (MavLinkConnection.this.mConnectionStatus.get() == 2) {
                            byte[] buffer = (byte[])MavLinkConnection.this.mPacketsToSend.take();
                            try {
                                MavLinkConnection.this.sendBuffer(buffer);
                                MavLinkConnection.this.queueToLog(buffer);
                                continue block7;
                            }
                            catch (IOException e) {
                                MavLinkConnection.this.reportIOException(e);
                                MavLinkConnection.this.mLogger.logErr(TAG, e);
                            }
                        }
                        break block9;
                    }
                    catch (InterruptedException e) {
                        MavLinkConnection.this.mLogger.logVerbose(TAG, e.getMessage());
                        break block9;
                    }
                }
                finally {
                    MavLinkConnection.this.disconnect();
                }
            }
        }
    };
    private final Runnable mLoggingTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer logBuffer = ByteBuffer.allocate(8);
            logBuffer.order(ByteOrder.BIG_ENDIAN);
            try {
                while (MavLinkConnection.this.mConnectionStatus.get() == 2) {
                    byte[] packetData = (byte[])MavLinkConnection.this.mPacketsToLog.take();
                    logBuffer.clear();
                    logBuffer.putLong(System.currentTimeMillis() * 1000L);
                    for (Map.Entry entry : MavLinkConnection.this.loggingOutStreams.entrySet()) {
                        Pair logInfo = (Pair)entry.getValue();
                        Uri loggingFileUri = (Uri)logInfo.first;
                        try {
                            BufferedOutputStream logWriter = (BufferedOutputStream)logInfo.second;
                            if (logWriter == null) {
                                logWriter = new BufferedOutputStream(UriUtils.getOutputStream(MavLinkConnection.this.context, loggingFileUri));
                                MavLinkConnection.this.loggingOutStreams.put(entry.getKey(), Pair.create((Object)loggingFileUri, (Object)logWriter));
                            }
                            logWriter.write(logBuffer.array());
                            logWriter.write(packetData);
                        }
                        catch (IOException e) {
                            MavLinkConnection.this.mLogger.logErr(TAG, "IO Exception while writing to " + loggingFileUri, e);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                try {
                    String errorMessage = e.getMessage();
                    if (errorMessage != null) {
                        MavLinkConnection.this.mLogger.logVerbose(TAG, errorMessage);
                    }
                }
                catch (Throwable throwable) {
                    for (Pair entry : MavLinkConnection.this.loggingOutStreams.values()) {
                        Uri loggingFileUri = (Uri)entry.first;
                        try {
                            if (entry.second == null) continue;
                            ((BufferedOutputStream)entry.second).close();
                        }
                        catch (IOException e2) {
                            MavLinkConnection.this.mLogger.logErr(TAG, "IO Exception while closing " + loggingFileUri, e2);
                        }
                    }
                    MavLinkConnection.this.loggingOutStreams.clear();
                    throw throwable;
                }
                for (Pair entry : MavLinkConnection.this.loggingOutStreams.values()) {
                    Uri loggingFileUri = (Uri)entry.first;
                    try {
                        if (entry.second == null) continue;
                        ((BufferedOutputStream)entry.second).close();
                    }
                    catch (IOException e3) {
                        MavLinkConnection.this.mLogger.logErr(TAG, "IO Exception while closing " + loggingFileUri, e3);
                    }
                }
                MavLinkConnection.this.loggingOutStreams.clear();
            }
            for (Pair entry : MavLinkConnection.this.loggingOutStreams.values()) {
                Uri loggingFileUri = (Uri)entry.first;
                try {
                    if (entry.second == null) continue;
                    ((BufferedOutputStream)entry.second).close();
                }
                catch (IOException e) {
                    MavLinkConnection.this.mLogger.logErr(TAG, "IO Exception while closing " + loggingFileUri, e);
                }
            }
            MavLinkConnection.this.loggingOutStreams.clear();
        }
    };
    protected final Logger mLogger = this.initLogger();
    protected final Context context;
    private Thread mConnectThread;
    private Thread mTaskThread;

    private int getErrorCode(IOException e) {
        if (e instanceof BindException) {
            return -6;
        }
        return -7;
    }

    protected MavLinkConnection(Context context) {
        this.context = context;
    }

    public void connect(Bundle extras) {
        if (this.mConnectionStatus.compareAndSet(0, 1)) {
            this.extrasHolder.set(extras);
            this.mLogger.logInfo(TAG, "Starting connection thread.");
            this.mConnectThread = new Thread(this.mConnectingTask, "MavLinkConnection-Connecting Thread");
            this.mConnectThread.start();
            this.reportConnecting();
        }
    }

    protected void onConnectionOpened(Bundle extras) {
        if (this.mConnectionStatus.compareAndSet(1, 2)) {
            this.extrasHolder.set(extras);
            this.mLogger.logInfo(TAG, "Starting manager thread.");
            this.mTaskThread = new Thread(this.mManagerTask, "MavLinkConnection-Manager Thread");
            this.mTaskThread.start();
        }
    }

    protected void onConnectionStatus(LinkConnectionStatus connectionStatus) {
        this.reportConnectionStatus(connectionStatus);
        switch (connectionStatus.getStatusCode()) {
            case "FAILED": {
                this.mLogger.logInfo(TAG, "Unable to establish connection: " + connectionStatus.getStatusCode());
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.mConnectionStatus.get() == 0 || this.mConnectThread == null && this.mTaskThread == null) {
            return;
        }
        try {
            this.mConnectionStatus.set(0);
            this.mConnectionTime.set(-1L);
            this.extrasHolder.set(null);
            if (this.mConnectThread != null && this.mConnectThread.isAlive() && !this.mConnectThread.isInterrupted()) {
                this.mConnectThread.interrupt();
            }
            if (this.mTaskThread != null && this.mTaskThread.isAlive() && !this.mTaskThread.isInterrupted()) {
                this.mTaskThread.interrupt();
            }
            this.closeConnection();
            this.reportDisconnect();
        }
        catch (IOException e) {
            this.mLogger.logErr(TAG, e);
            this.reportIOException(e);
        }
    }

    public int getConnectionStatus() {
        return this.mConnectionStatus.get();
    }

    public void sendMavPacket(MAVLinkPacket packet) {
        byte[] packetData = packet.encodePacket();
        if (!this.mPacketsToSend.offer(packetData)) {
            this.mLogger.logErr(TAG, "Unable to send mavlink packet. Packet queue is full!");
        }
    }

    private void queueToLog(MAVLinkPacket packet) {
        if (packet != null) {
            this.queueToLog(packet.encodePacket());
        }
    }

    private void queueToLog(byte[] packetData) {
        if (packetData != null && !this.mPacketsToLog.offer(packetData)) {
            this.mLogger.logErr(TAG, "Unable to log mavlink packet. Queue is full!");
        }
    }

    public void addLoggingPath(String tag, Uri loggingUri) {
        if (tag == null || tag.length() == 0 || loggingUri == null) {
            return;
        }
        if (!this.loggingOutStreams.contains(tag)) {
            this.loggingOutStreams.put(tag, (Pair<Uri, BufferedOutputStream>)Pair.create((Object)loggingUri, null));
        }
    }

    public void removeLoggingPath(String tag) {
        BufferedOutputStream outStream;
        if (tag == null || tag.length() == 0) {
            return;
        }
        Pair<Uri, BufferedOutputStream> logInfo = this.loggingOutStreams.remove(tag);
        if (logInfo != null && (outStream = (BufferedOutputStream)logInfo.second) != null) {
            try {
                outStream.close();
            }
            catch (IOException e) {
                this.mLogger.logErr(TAG, "IO Exception while closing " + logInfo.first, e);
            }
        }
    }

    public void addMavLinkConnectionListener(String tag, MavLinkConnectionListener listener) {
        this.mListeners.put(tag, listener);
        if (this.getConnectionStatus() == 2) {
            Bundle extras = new Bundle();
            extras.putLong("extra_connection_time", this.mConnectionTime.get());
            listener.onConnectionStatus(new LinkConnectionStatus("CONNECTED", extras));
        }
    }

    public int getMavLinkConnectionListenersCount() {
        return this.mListeners.size();
    }

    public Bundle getConnectionExtras() {
        return this.extrasHolder.get();
    }

    public boolean hasMavLinkConnectionListener(String tag) {
        return this.mListeners.containsKey(tag);
    }

    public void removeMavLinkConnectionListener(String tag) {
        this.mListeners.remove(tag);
    }

    public void removeAllMavLinkConnectionListeners() {
        this.mListeners.clear();
    }

    protected abstract Logger initLogger();

    protected abstract void openConnection(Bundle var1) throws IOException;

    protected abstract int readDataBlock(byte[] var1) throws IOException;

    protected abstract void sendBuffer(byte[] var1) throws IOException;

    protected abstract void closeConnection() throws IOException;

    protected abstract void loadPreferences();

    public abstract int getConnectionType();

    protected Logger getLogger() {
        return this.mLogger;
    }

    protected void reportConnectionStatus(LinkConnectionStatus connectionStatus) {
        if (this.mListeners.isEmpty()) {
            return;
        }
        for (MavLinkConnectionListener listener : this.mListeners.values()) {
            listener.onConnectionStatus(connectionStatus);
        }
    }

    protected void reportConnecting() {
        this.reportConnectionStatus(new LinkConnectionStatus("CONNECTING", null));
    }

    protected void reportConnect(long connectionTime) {
        Bundle extras = new Bundle();
        extras.putLong("extra_connection_time", connectionTime);
        this.reportConnectionStatus(new LinkConnectionStatus("CONNECTED", extras));
    }

    protected void reportDisconnect() {
        this.reportConnectionStatus(new LinkConnectionStatus("DISCONNECTED", null));
    }

    private void reportReceivedPacket(MAVLinkPacket packet) {
        if (this.mListeners.isEmpty()) {
            return;
        }
        for (MavLinkConnectionListener listener : this.mListeners.values()) {
            listener.onReceivePacket(packet);
        }
    }

    protected void reportIOException(IOException e) {
        this.reportConnectionStatus(LinkConnectionStatus.newFailedConnectionStatus(this.getErrorCode(e), e.getMessage()));
    }
}

