/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.connection;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;

public class ConnectionParameter
implements Parcelable {
    private static final long DEFAULT_EVENTS_DISPATCHING_PERIOD = 0L;
    private final int connectionType;
    private final Bundle paramsBundle;
    private final Uri tlogLoggingUri;
    private final long eventsDispatchingPeriod;
    public static final Parcelable.Creator<ConnectionParameter> CREATOR = new Parcelable.Creator<ConnectionParameter>(){

        public ConnectionParameter createFromParcel(Parcel source) {
            return new ConnectionParameter(source);
        }

        public ConnectionParameter[] newArray(int size) {
            return new ConnectionParameter[size];
        }
    };

    public static ConnectionParameter newUsbConnection(@Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newUsbConnection(57600, tlogLoggingUri);
    }

    public static ConnectionParameter newUsbConnection(int usbBaudRate, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newUsbConnection(usbBaudRate, tlogLoggingUri, 0L);
    }

    public static ConnectionParameter newUsbConnection(int usbBaudRate, @Nullable Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        Bundle paramsBundle = new Bundle(1);
        paramsBundle.putInt("extra_usb_baud_rate", usbBaudRate);
        return new ConnectionParameter(0, paramsBundle, tlogLoggingUri, eventsDispatchingPeriod);
    }

    public static ConnectionParameter newUdpConnection(@Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newUdpConnection(14550, tlogLoggingUri);
    }

    public static ConnectionParameter newUdpConnection(int udpPort, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newUdpConnection(udpPort, tlogLoggingUri, 0L);
    }

    public static ConnectionParameter newUdpConnection(int udpPort, @Nullable Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        Bundle paramsBundle = new Bundle();
        paramsBundle.putInt("extra_udp_server_port", udpPort);
        return new ConnectionParameter(1, paramsBundle, tlogLoggingUri, eventsDispatchingPeriod);
    }

    public static ConnectionParameter newUdpWithPingConnection(int udpPort, String udpPingReceiverIp, int udpPingReceiverPort, byte[] udpPingPayload, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newUdpWithPingConnection(udpPort, udpPingReceiverIp, udpPingReceiverPort, udpPingPayload, 10000L, tlogLoggingUri);
    }

    public static ConnectionParameter newUdpWithPingConnection(int udpPort, String udpPingReceiverIp, int udpPingReceiverPort, byte[] udpPingPayload, long pingPeriod, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newUdpWithPingConnection(udpPort, udpPingReceiverIp, udpPingReceiverPort, udpPingPayload, pingPeriod, tlogLoggingUri, 0L);
    }

    public static ConnectionParameter newUdpWithPingConnection(int udpPort, String udpPingReceiverIp, int udpPingReceiverPort, byte[] udpPingPayload, long pingPeriod, @Nullable Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        Bundle paramsBundle = new Bundle();
        paramsBundle.putInt("extra_udp_server_port", udpPort);
        if (!TextUtils.isEmpty((CharSequence)udpPingReceiverIp)) {
            paramsBundle.putString("extra_udp_ping_receiver_ip", udpPingReceiverIp);
            paramsBundle.putInt("extra_udp_ping_receiver_port", udpPingReceiverPort);
            paramsBundle.putByteArray("extra_udp_ping_payload", udpPingPayload);
            paramsBundle.putLong("extra_udp_ping_period", pingPeriod);
        }
        return new ConnectionParameter(1, paramsBundle, tlogLoggingUri, eventsDispatchingPeriod);
    }

    public static ConnectionParameter newTcpConnection(String tcpServerIp, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newTcpConnection(tcpServerIp, 5763, tlogLoggingUri);
    }

    public static ConnectionParameter newTcpConnection(String tcpServerIp, int tcpServerPort, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newTcpConnection(tcpServerIp, tcpServerPort, tlogLoggingUri, 0L);
    }

    public static ConnectionParameter newTcpConnection(String tcpServerIp, int tcpServerPort, @Nullable Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        Bundle paramsBundle = new Bundle(2);
        paramsBundle.putString("extra_tcp_server_ip", tcpServerIp);
        paramsBundle.putInt("extra_tcp_server_port", tcpServerPort);
        return new ConnectionParameter(2, paramsBundle, tlogLoggingUri, eventsDispatchingPeriod);
    }

    public static ConnectionParameter newBluetoothConnection(String bluetoothAddress, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newBluetoothConnection(bluetoothAddress, tlogLoggingUri, 0L);
    }

    public static ConnectionParameter newBluetoothConnection(String bluetoothAddress, @Nullable Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        Bundle paramsBundle = new Bundle(1);
        paramsBundle.putString("extra_bluetooth_address", bluetoothAddress);
        return new ConnectionParameter(3, paramsBundle, tlogLoggingUri, eventsDispatchingPeriod);
    }

    public static ConnectionParameter newSoloConnection(String ssid, @Nullable String password, @Nullable Uri tlogLoggingUri) {
        return ConnectionParameter.newSoloConnection(ssid, password, tlogLoggingUri, 0L);
    }

    public static ConnectionParameter newSoloConnection(String ssid, @Nullable String password, @Nullable Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        String ssidWithoutQuotes = ssid.replaceAll("^\"|\"$", "");
        Bundle paramsBundle = new Bundle(2);
        paramsBundle.putString("extra_solo_link_id", ssidWithoutQuotes);
        paramsBundle.putString("extra_solo_link_password", password);
        return new ConnectionParameter(101, paramsBundle, tlogLoggingUri, eventsDispatchingPeriod);
    }

    private ConnectionParameter(int connectionType, Bundle paramsBundle) {
        this(connectionType, paramsBundle, null);
    }

    private ConnectionParameter(int connectionType, Bundle paramsBundle, Uri tlogLoggingUri) {
        this(connectionType, paramsBundle, tlogLoggingUri, 0L);
    }

    private ConnectionParameter(int connectionType, Bundle paramsBundle, Uri tlogLoggingUri, long eventsDispatchingPeriod) {
        this.connectionType = connectionType;
        this.paramsBundle = paramsBundle;
        this.tlogLoggingUri = tlogLoggingUri;
        this.eventsDispatchingPeriod = eventsDispatchingPeriod;
    }

    public long getEventsDispatchingPeriod() {
        return this.eventsDispatchingPeriod;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public Bundle getParamsBundle() {
        return this.paramsBundle;
    }

    public Uri getTLogLoggingUri() {
        return this.tlogLoggingUri;
    }

    public String getUniqueId() {
        String uniqueId;
        switch (this.connectionType) {
            case 1: {
                int udpPort = 14550;
                if (this.paramsBundle != null) {
                    udpPort = this.paramsBundle.getInt("extra_udp_server_port", udpPort);
                }
                uniqueId = "udp:" + udpPort;
                break;
            }
            case 3: {
                String btAddress = "";
                if (this.paramsBundle != null) {
                    btAddress = this.paramsBundle.getString("extra_bluetooth_address", "");
                }
                uniqueId = TextUtils.isEmpty((CharSequence)btAddress) ? "bluetooth" : "bluetooth:" + btAddress;
                break;
            }
            case 2: {
                String tcpIp = "";
                int tcpPort = 5763;
                if (this.paramsBundle != null) {
                    tcpIp = this.paramsBundle.getString("extra_tcp_server_ip", "");
                    tcpPort = this.paramsBundle.getInt("extra_tcp_server_port", tcpPort);
                }
                uniqueId = "tcp:" + tcpIp + ":" + tcpPort;
                break;
            }
            case 0: {
                uniqueId = "usb";
                break;
            }
            case 101: {
                String soloLinkId = "";
                if (this.paramsBundle != null) {
                    soloLinkId = this.paramsBundle.getString("extra_solo_link_id", "");
                }
                uniqueId = "solo:" + soloLinkId;
                break;
            }
            default: {
                uniqueId = "";
            }
        }
        return uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectionParameter)) {
            return false;
        }
        ConnectionParameter that = (ConnectionParameter)o;
        return this.getUniqueId().equals(that.getUniqueId());
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        String toString = "ConnectionParameter{connectionType=" + this.connectionType + ", paramsBundle=[";
        if (this.paramsBundle != null && !this.paramsBundle.isEmpty()) {
            boolean isFirst = true;
            for (String key : this.paramsBundle.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    toString = toString + ", ";
                }
                toString = toString + key + "=" + this.paramsBundle.get(key);
            }
        }
        toString = toString + "]}";
        return toString;
    }

    public ConnectionParameter clone() {
        return new ConnectionParameter(this.connectionType, this.paramsBundle);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.connectionType);
        dest.writeBundle(this.paramsBundle);
        dest.writeParcelable((Parcelable)this.tlogLoggingUri, flags);
        dest.writeLong(this.eventsDispatchingPeriod);
    }

    private ConnectionParameter(Parcel in) {
        int type;
        this.connectionType = type = in.readInt();
        this.paramsBundle = in.readBundle(this.getClass().getClassLoader());
        this.tlogLoggingUri = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.eventsDispatchingPeriod = in.readLong();
    }
}

