/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import java.nio.ByteBuffer;

public class SoloShotOptions
extends TLVPacket {
    public static final int PAUSED_CRUISE_SPEED = 0;
    public static final int MIN_ABS_CRUISE_SPEED = 1;
    public static final int MAX_ABS_CRUISE_SPEED = 8;
    public static final int DEFAULT_ABS_CRUISE_SPEED = 4;
    private float cruiseSpeed;
    public static final Parcelable.Creator<SoloShotOptions> CREATOR = new Parcelable.Creator<SoloShotOptions>(){

        public SoloShotOptions createFromParcel(Parcel source) {
            return new SoloShotOptions(source);
        }

        public SoloShotOptions[] newArray(int size) {
            return new SoloShotOptions[size];
        }
    };

    public SoloShotOptions() {
        this(20, 4, 0.0f);
    }

    public SoloShotOptions(float cruiseSpeed) {
        this(20, 4, cruiseSpeed);
    }

    protected SoloShotOptions(int type, int length, float cruiseSpeed) {
        super(type, length);
        this.cruiseSpeed = cruiseSpeed;
    }

    public float getCruiseSpeed() {
        return this.cruiseSpeed;
    }

    public void setCruiseSpeed(float cruiseSpeed) {
        this.cruiseSpeed = cruiseSpeed;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SoloShotOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SoloShotOptions that = (SoloShotOptions)o;
        return Float.compare(that.cruiseSpeed, this.cruiseSpeed) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.cruiseSpeed != 0.0f ? Float.floatToIntBits(this.cruiseSpeed) : 0);
        return result;
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putFloat(this.cruiseSpeed);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeFloat(this.cruiseSpeed);
    }

    protected SoloShotOptions(Parcel in) {
        super(in);
        this.cruiseSpeed = in.readFloat();
    }
}

