/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.content.Context;
import android.os.Parcel;
import com.o3dr.android.client.R;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.drone.property.VehicleMode;
import java.nio.ByteBuffer;

public abstract class SoloMessageShot
extends TLVPacket {
    public static final int SHOT_FREE_FLIGHT = -1;
    public static final int SHOT_SELFIE = 0;
    public static final int SHOT_ORBIT = 1;
    public static final int SHOT_CABLECAM = 2;
    public static final int SHOT_FOLLOW = 5;
    public static final int SHOT_MPCC = 6;
    public static final int SHOT_INSPECT = 100;
    public static final int SHOT_SURVEY = 102;
    public static final int SHOT_SCAN = 101;
    private int shotType;

    public SoloMessageShot(int type, int shotType) {
        super(type, 4);
        this.shotType = shotType;
    }

    public int getShotType() {
        return this.shotType;
    }

    public void setShotType(int shotType) {
        this.shotType = shotType;
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putInt(this.shotType);
    }

    public static CharSequence getShotLabel(Context context, int shotType) {
        if (context == null) {
            return null;
        }
        switch (shotType) {
            case -1: {
                return context.getText(R.string.label_free_flight);
            }
            case 0: {
                return context.getText(R.string.label_selfie);
            }
            case 1: {
                return context.getText(R.string.label_orbit);
            }
            case 2: 
            case 6: {
                return context.getText(R.string.label_cable_cam);
            }
            case 5: {
                return context.getText(R.string.label_follow);
            }
            case 100: {
                return context.getString(R.string.label_inspect);
            }
            case 102: {
                return context.getString(R.string.label_survey);
            }
            case 101: {
                return context.getString(R.string.label_scan);
            }
        }
        return null;
    }

    public static CharSequence getFlightModeLabel(Context context, VehicleMode flightMode) {
        if (context == null || flightMode == null) {
            return null;
        }
        switch (flightMode) {
            case COPTER_LOITER: {
                return context.getText(R.string.copter_loiter_label);
            }
            case COPTER_ALT_HOLD: {
                return context.getText(R.string.copter_alt_hold_label);
            }
            case COPTER_RTL: {
                return context.getText(R.string.copter_rtl_label);
            }
            case COPTER_GUIDED: {
                return null;
            }
            case COPTER_AUTOTUNE: {
                return context.getText(R.string.copter_auto_tune_label);
            }
            case COPTER_POSHOLD: {
                return context.getText(R.string.copter_pos_hold_label);
            }
            case COPTER_AUTO: {
                return null;
            }
        }
        return flightMode.getLabel();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.shotType);
    }

    protected SoloMessageShot(Parcel in) {
        super(in);
        this.shotType = in.readInt();
    }
}

