/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.os.Bundle;
import android.support.annotation.NonNull;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.android.client.interfaces.DroneListener;
import com.o3dr.services.android.lib.drone.connection.ConnectionResult;
import com.o3dr.services.android.lib.drone.property.Type;
import com.o3dr.services.android.lib.model.SimpleCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class GimbalApi
extends Api
implements DroneListener {
    private static final ConcurrentHashMap<Drone, GimbalApi> gimbalApiCache = new ConcurrentHashMap();
    private static final Api.Builder<GimbalApi> apiBuilder = new Api.Builder<GimbalApi>(){

        @Override
        public GimbalApi build(Drone drone) {
            return new GimbalApi(drone);
        }
    };
    private final ConcurrentLinkedQueue<GimbalOrientationListener> gimbalListeners = new ConcurrentLinkedQueue();
    private final Drone drone;
    private final GimbalOrientation gimbalOrientation = new GimbalOrientation();

    public static GimbalApi getApi(Drone drone) {
        return GimbalApi.getApi(drone, gimbalApiCache, apiBuilder);
    }

    private GimbalApi(Drone drone) {
        this.drone = drone;
        this.drone.registerDroneListener(this);
    }

    public GimbalOrientation getGimbalOrientation() {
        return new GimbalOrientation(this.gimbalOrientation);
    }

    public void startGimbalControl(final GimbalOrientationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener can't be null.");
        }
        Type vehicleType = (Type)this.drone.getAttribute("com.o3dr.services.android.lib.attribute.TYPE");
        if (vehicleType.getDroneType() != 2) {
            this.drone.post(new Runnable(){

                @Override
                public void run() {
                    listener.onGimbalOrientationCommandError(3);
                }
            });
            return;
        }
        this.gimbalListeners.add(listener);
        this.configureGimbalMountMode(listener);
    }

    private void configureGimbalMountMode(final GimbalOrientationListener listener) {
        Bundle params = new Bundle(1);
        params.putInt("gimbal_mount_mode", 2);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.gimbal.SET_GIMBAL_MOUNT_MODE", params), new SimpleCommandListener(){

            @Override
            public void onTimeout() {
                listener.onGimbalOrientationCommandError(4);
            }

            @Override
            public void onError(int error) {
                listener.onGimbalOrientationCommandError(error);
            }
        });
    }

    public void stopGimbalControl(final GimbalOrientationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener can't be null.");
        }
        if (!this.gimbalListeners.contains(listener)) {
            this.drone.post(new Runnable(){

                @Override
                public void run() {
                    listener.onGimbalOrientationCommandError(2);
                }
            });
            return;
        }
        this.gimbalListeners.remove(listener);
        Bundle params = new Bundle(1);
        params.putInt("gimbal_mount_mode", 3);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.gimbal.SET_GIMBAL_MOUNT_MODE", params), new SimpleCommandListener(){

            @Override
            public void onTimeout() {
                listener.onGimbalOrientationCommandError(4);
            }

            @Override
            public void onError(int error) {
                listener.onGimbalOrientationCommandError(error);
            }
        });
    }

    public void updateGimbalOrientation(GimbalOrientation orientation, @NonNull GimbalOrientationListener listener) {
        this.updateGimbalOrientation(orientation.pitch, orientation.roll, orientation.yaw, listener);
    }

    public void updateGimbalOrientation(float pitch, float roll, float yaw, final @NonNull GimbalOrientationListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must be non-null.");
        }
        if (!this.gimbalListeners.contains(listener)) {
            this.drone.post(new Runnable(){

                @Override
                public void run() {
                    listener.onGimbalOrientationCommandError(2);
                }
            });
            return;
        }
        Bundle params = new Bundle();
        params.putFloat("gimbal_pitch", pitch);
        params.putFloat("gimbal_roll", roll);
        params.putFloat("gimbal_yaw", yaw);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.gimbal.SET_GIMBAL_ORIENTATION", params), new SimpleCommandListener(){

            @Override
            public void onTimeout() {
                listener.onGimbalOrientationCommandError(4);
            }

            @Override
            public void onError(int error) {
                listener.onGimbalOrientationCommandError(error);
            }
        });
    }

    private void notifyGimbalOrientationUpdated(GimbalOrientation orientation) {
        if (this.gimbalListeners.isEmpty()) {
            return;
        }
        for (GimbalOrientationListener listener : this.gimbalListeners) {
            listener.onGimbalOrientationUpdate(orientation);
        }
    }

    @Override
    public void onDroneConnectionFailed(ConnectionResult result) {
    }

    @Override
    public void onDroneEvent(String event, Bundle extras) {
        switch (event) {
            case "com.o3dr.services.android.lib.attribute.event.GIMBAL_ORIENTATION_UPDATED": {
                float pitch = extras.getFloat("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_GIMBAL_ORIENTATION_PITCH");
                float roll = extras.getFloat("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_GIMBAL_ORIENTATION_ROLL");
                float yaw = extras.getFloat("com.o3dr.services.android.lib.attribute.event.extra.EXTRA_GIMBAL_ORIENTATION_YAW");
                this.gimbalOrientation.updateOrientation(pitch, roll, yaw);
                this.notifyGimbalOrientationUpdated(this.gimbalOrientation);
            }
        }
    }

    @Override
    public void onDroneServiceInterrupted(String errorMsg) {
    }

    public static class GimbalOrientation {
        private float pitch;
        private float roll;
        private float yaw;

        public float getPitch() {
            return this.pitch;
        }

        public float getRoll() {
            return this.roll;
        }

        public float getYaw() {
            return this.yaw;
        }

        private void updateOrientation(float pitch, float roll, float yaw) {
            this.pitch = pitch;
            this.roll = roll;
            this.yaw = yaw;
        }

        private GimbalOrientation() {
        }

        private GimbalOrientation(GimbalOrientation source) {
            this.pitch = source.pitch;
            this.roll = source.roll;
            this.yaw = source.yaw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GimbalOrientation)) {
                return false;
            }
            GimbalOrientation that = (GimbalOrientation)o;
            if (Float.compare(that.pitch, this.pitch) != 0) {
                return false;
            }
            if (Float.compare(that.roll, this.roll) != 0) {
                return false;
            }
            return Float.compare(that.yaw, this.yaw) == 0;
        }

        public int hashCode() {
            int result = this.pitch != 0.0f ? Float.floatToIntBits(this.pitch) : 0;
            result = 31 * result + (this.roll != 0.0f ? Float.floatToIntBits(this.roll) : 0);
            result = 31 * result + (this.yaw != 0.0f ? Float.floatToIntBits(this.yaw) : 0);
            return result;
        }

        public String toString() {
            return "GimbalOrientation{pitch=" + this.pitch + ", roll=" + this.roll + ", yaw=" + this.yaw + '}';
        }
    }

    public static interface GimbalOrientationListener {
        public void onGimbalOrientationUpdate(GimbalOrientation var1);

        public void onGimbalOrientationCommandError(int var1);
    }
}

