/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.os.Bundle;
import android.os.Parcelable;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class ControlApi
extends Api {
    private static final ConcurrentHashMap<Drone, ControlApi> apiCache = new ConcurrentHashMap();
    private static final Api.Builder<ControlApi> apiBuilder = new Api.Builder<ControlApi>(){

        @Override
        public ControlApi build(Drone drone) {
            return new ControlApi(drone);
        }
    };
    private final Drone drone;

    public static ControlApi getApi(Drone drone) {
        return ControlApi.getApi(drone, apiCache, apiBuilder);
    }

    private ControlApi(Drone drone) {
        this.drone = drone;
    }

    public void takeoff(double altitude, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putDouble("extra_altitude", altitude);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.DO_GUIDED_TAKEOFF", params), listener);
    }

    public void pauseAtCurrentLocation(AbstractCommandListener listener) {
        Bundle params = new Bundle();
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.action.control.action.SEND_BRAKE_VEHICLE", params), listener);
    }

    public void goTo(LatLong point, boolean force, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putBoolean("extra_force_guided_point", force);
        params.putParcelable("extra_guided_point", (Parcelable)point);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.SEND_GUIDED_POINT", params), listener);
    }

    public void lookAt(LatLongAlt point, boolean force, AbstractCommandListener listener) {
        Bundle params = new Bundle();
        params.putBoolean("extra_force_guided_point", force);
        params.putParcelable("extra_look_at_target", (Parcelable)point);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.action.control.action.LOOK_AT_TARGET", params), listener);
    }

    public void climbTo(double altitude) {
        Bundle params = new Bundle();
        params.putDouble("extra_altitude", altitude);
        this.drone.performAsyncAction(new Action("com.o3dr.services.android.action.SET_GUIDED_ALTITUDE", params));
    }

    public void turnTo(float targetAngle, float turnRate, boolean isRelative, AbstractCommandListener listener) {
        if (!ControlApi.isWithinBounds(targetAngle, 0.0f, 360.0f) || !ControlApi.isWithinBounds(turnRate, -1.0f, 1.0f)) {
            ControlApi.postErrorEvent(4, listener);
            return;
        }
        Bundle params = new Bundle();
        params.putFloat("extra_yaw_target_angle", targetAngle);
        params.putFloat("extra_yaw_change_rate", turnRate);
        params.putBoolean("extra_yaw_is_relative", isRelative);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.action.control.SET_CONDITION_YAW", params), listener);
    }

    public void manualControl(float vx, float vy, float vz, AbstractCommandListener listener) {
        if (!(ControlApi.isWithinBounds(vx, -1.0f, 1.0f) && ControlApi.isWithinBounds(vy, -1.0f, 1.0f) && ControlApi.isWithinBounds(vz, -1.0f, 1.0f))) {
            ControlApi.postErrorEvent(4, listener);
            return;
        }
        Bundle params = new Bundle();
        params.putFloat("extra_velocity_x", vx);
        params.putFloat("extra_velocity_y", vy);
        params.putFloat("extra_velocity_z", vz);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.action.control.SET_VELOCITY", params), listener);
    }

    public void enableManualControl(final boolean enable, final ManualControlStateListener listener) {
        AbstractCommandListener listenerWrapper = listener == null ? null : new AbstractCommandListener(){

            @Override
            public void onSuccess() {
                if (enable) {
                    listener.onManualControlToggled(true);
                } else {
                    listener.onManualControlToggled(false);
                }
            }

            @Override
            public void onError(int executionError) {
                if (enable) {
                    listener.onManualControlToggled(false);
                }
            }

            @Override
            public void onTimeout() {
                if (enable) {
                    listener.onManualControlToggled(false);
                }
            }
        };
        Bundle params = new Bundle();
        params.putBoolean("extra_do_enable", enable);
        this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.lib.drone.action.control.ENABLE_MANUAL_CONTROL", params), listenerWrapper);
    }

    private static boolean isWithinBounds(float value, float lowerBound, float upperBound) {
        return value <= upperBound && value >= lowerBound;
    }

    public static interface ManualControlStateListener {
        public void onManualControlToggled(boolean var1);
    }
}

