/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.util;

import com.nytimes.android.external.cache3.Cache;
import com.nytimes.android.external.cache3.CacheBuilder;
import com.nytimes.android.external.store3.base.Clearable;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class NoopPersister<Raw, Key>
implements Persister<Raw, Key>,
Clearable<Key> {
    protected final Cache<Key, Maybe<Raw>> networkResponses;

    NoopPersister(MemoryPolicy memoryPolicy) {
        if (memoryPolicy.hasAccessPolicy()) {
            this.networkResponses = CacheBuilder.newBuilder().expireAfterAccess(memoryPolicy.getExpireAfterAccess(), memoryPolicy.getExpireAfterTimeUnit()).build();
        } else if (memoryPolicy.hasWritePolicy()) {
            this.networkResponses = CacheBuilder.newBuilder().expireAfterWrite(memoryPolicy.getExpireAfterWrite(), memoryPolicy.getExpireAfterTimeUnit()).build();
        } else {
            throw new IllegalArgumentException("No expiry policy set on memory-policy.");
        }
    }

    public static <Raw, Key> NoopPersister<Raw, Key> create() {
        return NoopPersister.create(null);
    }

    public static <Raw, Key> NoopPersister<Raw, Key> create(MemoryPolicy memoryPolicy) {
        if (memoryPolicy == null) {
            MemoryPolicy defaultPolicy = MemoryPolicy.builder().setExpireAfterWrite(24L).setExpireAfterTimeUnit(TimeUnit.HOURS).build();
            return new NoopPersister<Raw, Key>(defaultPolicy);
        }
        return new NoopPersister<Raw, Key>(memoryPolicy);
    }

    @Override
    @Nonnull
    public Maybe<Raw> read(@Nonnull Key key) {
        Maybe cachedValue = (Maybe)this.networkResponses.getIfPresent(key);
        return cachedValue == null ? Maybe.empty() : cachedValue;
    }

    @Override
    @Nonnull
    public Single<Boolean> write(@Nonnull Key key, @Nonnull Raw raw) {
        this.networkResponses.put(key, (Object)Maybe.just(raw));
        return Single.just((Object)true);
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.networkResponses.invalidate(key);
    }
}

