/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl.room;

import com.nytimes.android.external.cache3.Cache;
import com.nytimes.android.external.store3.annotations.Experimental;
import com.nytimes.android.external.store3.base.Fetcher;
import com.nytimes.android.external.store3.base.impl.CacheFactory;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import com.nytimes.android.external.store3.base.impl.StalePolicy;
import com.nytimes.android.external.store3.base.impl.StoreUtil;
import com.nytimes.android.external.store3.base.impl.room.StoreRoom;
import com.nytimes.android.external.store3.base.room.RoomPersister;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Experimental
class RealStoreRoom<Raw, Parsed, Key>
extends StoreRoom<Parsed, Key> {
    private final Fetcher<Raw, Key> fetcher;
    private final RoomPersister<Raw, Parsed, Key> persister;
    private final Cache<Key, Observable<Parsed>> memCache;
    private final StalePolicy stalePolicy;
    private final Cache<Key, Observable<Parsed>> inFlightRequests;

    RealStoreRoom(Fetcher<Raw, Key> fetcher, RoomPersister<Raw, Parsed, Key> persister) {
        this(fetcher, persister, null, StalePolicy.UNSPECIFIED);
    }

    RealStoreRoom(Fetcher<Raw, Key> fetcher, RoomPersister<Raw, Parsed, Key> persister, StalePolicy stalePolicy) {
        this(fetcher, persister, null, stalePolicy);
    }

    RealStoreRoom(Fetcher<Raw, Key> fetcher, RoomPersister<Raw, Parsed, Key> persister, MemoryPolicy memoryPolicy, StalePolicy stalePolicy) {
        this.fetcher = fetcher;
        this.persister = persister;
        this.stalePolicy = stalePolicy;
        this.memCache = CacheFactory.createRoomCache(memoryPolicy);
        this.inFlightRequests = CacheFactory.createRoomInflighter(memoryPolicy);
    }

    @Override
    @Nonnull
    public Observable<Parsed> get(@Nonnull Key key) {
        return this.lazyCache(key).switchIfEmpty(this.fetch(key));
    }

    private Observable<Parsed> lazyCache(@Nonnull Key key) {
        return Observable.defer(() -> this.cache(key)).onErrorResumeNext((ObservableSource)Observable.empty());
    }

    Observable<Parsed> cache(@Nonnull Key key) {
        try {
            return (Observable)this.memCache.get(key, () -> this.disk(key));
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @Nonnull
    public Observable<Parsed> memory(@Nonnull Key key) {
        Observable cachedValue = (Observable)this.memCache.getIfPresent(key);
        return cachedValue == null ? Observable.empty() : cachedValue;
    }

    @Nonnull
    public Observable<Parsed> disk(@Nonnull Key key) {
        if (StoreUtil.shouldReturnNetworkBeforeStale(this.persister, this.stalePolicy, key)) {
            return Observable.empty();
        }
        return this.readDisk(key);
    }

    Observable<Parsed> readDisk(@Nonnull Key key) {
        return this.persister().read(key).doOnNext(this::guardAgainstEmptyCollection).onErrorResumeNext((ObservableSource)Observable.empty()).doOnNext(parsed -> {
            this.updateMemory(key, parsed);
            if (this.stalePolicy == StalePolicy.REFRESH_ON_STALE && StoreUtil.persisterIsStale(key, this.persister)) {
                this.backfillCache(key);
            }
        }).cache();
    }

    void backfillCache(@Nonnull Key key) {
        this.fetch(key).subscribe(it -> {}, it -> {});
    }

    @Override
    @Nonnull
    public Observable<Parsed> fetch(@Nonnull Key key) {
        return Observable.defer(() -> this.fetchAndPersist(key));
    }

    @Nullable
    Observable<Parsed> fetchAndPersist(@Nonnull Key key) {
        try {
            return (Observable)this.inFlightRequests.get(key, () -> this.response(key));
        }
        catch (ExecutionException e) {
            return Observable.error((Throwable)e);
        }
    }

    @Nonnull
    Observable<Parsed> response(@Nonnull Key key) {
        return this.fetcher().fetch(key).doOnSuccess(it -> this.persister().write(key, it)).flatMapObservable(it -> this.readDisk(key)).onErrorResumeNext(throwable -> {
            if (this.stalePolicy == StalePolicy.NETWORK_BEFORE_STALE) {
                return this.readDisk(key).switchIfEmpty((ObservableSource)Observable.error((Throwable)throwable));
            }
            return Observable.error((Throwable)throwable);
        }).doAfterTerminate(() -> this.inFlightRequests.invalidate(key)).cache();
    }

    void updateMemory(@Nonnull Key key, Parsed data) {
        this.memCache.put(key, (Object)Observable.just(data));
    }

    @Override
    public void clear() {
        for (Object cachedKey : this.memCache.asMap().keySet()) {
            this.clear((Key)cachedKey);
        }
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.inFlightRequests.invalidate(key);
        this.memCache.invalidate(key);
        StoreUtil.clearPersister(this.persister(), key);
    }

    RoomPersister<Raw, Parsed, Key> persister() {
        return this.persister;
    }

    Fetcher<Raw, Key> fetcher() {
        return this.fetcher;
    }

    private void guardAgainstEmptyCollection(Parsed v) {
        if (v instanceof Collection && ((Collection)v).isEmpty()) {
            throw new IllegalStateException("empty result set");
        }
    }
}

