/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.store3.base.BasePersister;
import com.nytimes.android.external.store3.base.Clearable;
import com.nytimes.android.external.store3.base.RecordProvider;
import com.nytimes.android.external.store3.base.RecordState;
import com.nytimes.android.external.store3.base.impl.RepeatWhenEmits;
import com.nytimes.android.external.store3.base.impl.StalePolicy;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.subjects.PublishSubject;
import javax.annotation.Nonnull;

public final class StoreUtil {
    private StoreUtil() {
    }

    @Nonnull
    public static <Parsed, Key> ObservableTransformer<Parsed, Parsed> repeatWhenSubjectEmits(PublishSubject<Key> refreshSubject, @Nonnull Key keyForRepeat) {
        Observable filter = refreshSubject.filter(key -> key.equals(keyForRepeat));
        return RepeatWhenEmits.from(filter);
    }

    public static <Raw, Key> boolean shouldReturnNetworkBeforeStale(BasePersister persister, StalePolicy stalePolicy, Key key) {
        return stalePolicy == StalePolicy.NETWORK_BEFORE_STALE && StoreUtil.persisterIsStale(key, persister);
    }

    public static <Raw, Key> boolean persisterIsStale(@Nonnull Key key, BasePersister persister) {
        if (persister instanceof RecordProvider) {
            RecordProvider provider = (RecordProvider)((Object)persister);
            RecordState recordState = provider.getRecordState(key);
            return recordState == RecordState.STALE;
        }
        return false;
    }

    public static <Raw, Key> void clearPersister(BasePersister persister, @Nonnull Key key) {
        boolean isPersisterClearable = persister instanceof Clearable;
        if (isPersisterClearable) {
            ((Clearable)((Object)persister)).clear(key);
        }
    }
}

