/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.base.impl;

import com.nytimes.android.external.cache3.Cache;
import com.nytimes.android.external.store.util.Result;
import com.nytimes.android.external.store3.annotations.Experimental;
import com.nytimes.android.external.store3.base.Fetcher;
import com.nytimes.android.external.store3.base.InternalStore;
import com.nytimes.android.external.store3.base.Persister;
import com.nytimes.android.external.store3.base.impl.CacheFactory;
import com.nytimes.android.external.store3.base.impl.MemoryPolicy;
import com.nytimes.android.external.store3.base.impl.StalePolicy;
import com.nytimes.android.external.store3.base.impl.StoreUtil;
import com.nytimes.android.external.store3.util.KeyParser;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.subjects.PublishSubject;
import java.util.AbstractMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RealInternalStore<Raw, Parsed, Key>
implements InternalStore<Parsed, Key> {
    Cache<Key, Single<Parsed>> inFlightRequests;
    Cache<Key, Maybe<Parsed>> memCache;
    StalePolicy stalePolicy;
    Persister<Raw, Key> persister;
    KeyParser<Key, Raw, Parsed> parser;
    private final PublishSubject<Key> refreshSubject = PublishSubject.create();
    private Fetcher<Raw, Key> fetcher;
    private PublishSubject<AbstractMap.SimpleEntry<Key, Parsed>> subject;

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, StalePolicy stalePolicy) {
        this(fetcher, persister, parser, null, stalePolicy);
    }

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy stalePolicy) {
        this.fetcher = fetcher;
        this.persister = persister;
        this.parser = parser;
        this.stalePolicy = stalePolicy;
        this.memCache = CacheFactory.createCache(memoryPolicy);
        this.inFlightRequests = CacheFactory.createInflighter(memoryPolicy);
        this.subject = PublishSubject.create();
    }

    @Override
    @Nonnull
    public Single<Parsed> get(@Nonnull Key key) {
        return this.lazyCache(key).switchIfEmpty((MaybeSource)this.fetch(key).toMaybe()).toSingle();
    }

    @Override
    @Nonnull
    public Single<Result<Parsed>> getWithResult(@Nonnull Key key) {
        return this.lazyCacheWithResult(key).switchIfEmpty((MaybeSource)this.fetchWithResult(key).toMaybe()).toSingle();
    }

    @Override
    @Nonnull
    @Experimental
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.get(key).toObservable().compose(StoreUtil.repeatWhenSubjectEmits(this.refreshSubject, key));
    }

    private Maybe<Parsed> lazyCache(@Nonnull Key key) {
        return Maybe.defer(() -> this.cache(key)).onErrorResumeNext((MaybeSource)Maybe.empty());
    }

    Maybe<Parsed> cache(@Nonnull Key key) {
        try {
            return (Maybe)this.memCache.get(key, () -> this.disk(key));
        }
        catch (ExecutionException e) {
            return Maybe.empty();
        }
    }

    private Maybe<Result<Parsed>> lazyCacheWithResult(@Nonnull Key key) {
        return Maybe.defer(() -> this.cacheWithResult(key)).onErrorResumeNext((MaybeSource)Maybe.empty());
    }

    Maybe<Result<Parsed>> cacheWithResult(@Nonnull Key key) {
        try {
            Maybe maybeResult = (Maybe)this.memCache.get(key, () -> this.disk(key));
            return maybeResult == null ? Maybe.empty() : maybeResult.map(Result::createFromCache);
        }
        catch (ExecutionException e) {
            return Maybe.empty();
        }
    }

    @Override
    @Nonnull
    public Maybe<Parsed> memory(@Nonnull Key key) {
        Maybe cachedValue = (Maybe)this.memCache.getIfPresent(key);
        return cachedValue == null ? Maybe.empty() : cachedValue;
    }

    @Override
    @Nonnull
    public Maybe<Parsed> disk(@Nonnull Key key) {
        if (StoreUtil.shouldReturnNetworkBeforeStale(this.persister, this.stalePolicy, key)) {
            return Maybe.empty();
        }
        return this.readDisk(key);
    }

    Maybe<Parsed> readDisk(@Nonnull Key key) {
        return this.persister().read(key).onErrorResumeNext((MaybeSource)Maybe.empty()).map(raw -> this.parser.apply(key, raw)).doOnSuccess(parsed -> {
            this.updateMemory(key, parsed);
            if (this.stalePolicy == StalePolicy.REFRESH_ON_STALE && StoreUtil.persisterIsStale(key, this.persister)) {
                this.backfillCache(key);
            }
        }).cache();
    }

    void backfillCache(@Nonnull Key key) {
        this.fetch(key).subscribe(parsed -> {}, throwable -> {});
    }

    @Override
    @Nonnull
    public Single<Parsed> fetch(@Nonnull Key key) {
        return Single.defer(() -> this.fetchAndPersist(key));
    }

    @Override
    @Nonnull
    public Single<Result<Parsed>> fetchWithResult(@Nonnull Key key) {
        return this.fetch(key).map(Result::createFromNetwork);
    }

    @Nullable
    Single<Parsed> fetchAndPersist(@Nonnull Key key) {
        try {
            return (Single)this.inFlightRequests.get(key, () -> this.response(key));
        }
        catch (ExecutionException e) {
            return Single.error((Throwable)e);
        }
    }

    @Nonnull
    Single<Parsed> response(@Nonnull Key key) {
        return this.fetcher().fetch(key).flatMap(raw -> this.persister().write(key, raw).flatMap(aBoolean -> this.readDisk(key).toSingle())).onErrorResumeNext(throwable -> {
            if (this.stalePolicy == StalePolicy.NETWORK_BEFORE_STALE) {
                return this.readDisk(key).switchIfEmpty((MaybeSource)Maybe.error((Throwable)throwable)).toSingle();
            }
            return Single.error((Throwable)throwable);
        }).doOnSuccess(data -> this.notifySubscribers(data, key)).doAfterTerminate(() -> this.inFlightRequests.invalidate(key)).cache();
    }

    void notifySubscribers(Parsed data, Key key) {
        this.subject.onNext(new AbstractMap.SimpleEntry<Key, Parsed>(key, data));
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(@Nonnull Key key) {
        return this.subject.hide().startWith((ObservableSource)this.get(key).toObservable().map(data -> new AbstractMap.SimpleEntry<Object, Object>(key, data))).filter(simpleEntry -> simpleEntry.getKey().equals(key)).map(AbstractMap.SimpleEntry::getValue);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.subject.hide().map(AbstractMap.SimpleEntry::getValue);
    }

    void updateMemory(@Nonnull Key key, Parsed data) {
        this.memCache.put(key, (Object)Maybe.just(data));
    }

    @Override
    @Deprecated
    public void clearMemory() {
        this.clear();
    }

    @Override
    @Deprecated
    public void clearMemory(@Nonnull Key key) {
        this.clear(key);
    }

    @Override
    public void clear() {
        for (Object cachedKey : this.memCache.asMap().keySet()) {
            this.clear((Key)cachedKey);
        }
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.inFlightRequests.invalidate(key);
        this.memCache.invalidate(key);
        StoreUtil.clearPersister(this.persister(), key);
        this.notifyRefresh(key);
    }

    private void notifyRefresh(@Nonnull Key key) {
        this.refreshSubject.onNext(key);
    }

    Persister<Raw, Key> persister() {
        return this.persister;
    }

    Fetcher<Raw, Key> fetcher() {
        return this.fetcher;
    }
}

