/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.store.base.Clearable;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.InternalStore;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.MemoryPolicy;
import com.nytimes.android.external.store.base.impl.StalePolicy;
import com.nytimes.android.external.store.base.impl.StoreUtil;
import com.nytimes.android.external.store.util.KeyParser;
import com.nytimes.android.external.store.util.OnErrorResumeWithEmpty;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rx.Observable;
import rx.annotations.Experimental;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subjects.BehaviorSubject;
import rx.subjects.PublishSubject;

final class RealInternalStore<Raw, Parsed, Key>
implements InternalStore<Parsed, Key> {
    Cache<Key, Observable<Parsed>> inFlightRequests;
    Cache<Key, Observable<Parsed>> memCache;
    Persister<Raw, Key> persister;
    KeyParser<Key, Raw, Parsed> parser;
    StalePolicy stalePolicy;
    private final PublishSubject<Key> refreshSubject = PublishSubject.create();
    private Fetcher<Raw, Key> fetcher;
    private BehaviorSubject<Parsed> subject;

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, StalePolicy stalePolicy) {
        this(fetcher, persister, parser, null, stalePolicy);
    }

    RealInternalStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, KeyParser<Key, Raw, Parsed> parser, MemoryPolicy memoryPolicy, StalePolicy stalePolicy) {
        this.fetcher = fetcher;
        this.persister = persister;
        this.parser = parser;
        this.stalePolicy = stalePolicy;
        if (memoryPolicy == null) {
            memoryPolicy = MemoryPolicy.builder().setMemorySize(this.getCacheSize()).setExpireAfter(this.getCacheTTL()).setExpireAfterTimeUnit(this.getCacheTTLTimeUnit()).build();
        }
        this.initMemCache(memoryPolicy);
        this.initFlightRequests(memoryPolicy);
        this.subject = BehaviorSubject.create();
    }

    private void initFlightRequests(MemoryPolicy memoryPolicy) {
        long maximumInFlightRequestsDuration;
        long expireAfterToSeconds = memoryPolicy.getExpireAfterTimeUnit().toSeconds(memoryPolicy.getExpireAfter());
        this.inFlightRequests = expireAfterToSeconds > (maximumInFlightRequestsDuration = TimeUnit.MINUTES.toSeconds(1L)) ? CacheBuilder.newBuilder().expireAfterWrite(maximumInFlightRequestsDuration, TimeUnit.SECONDS).build() : CacheBuilder.newBuilder().expireAfterWrite(memoryPolicy.getExpireAfter(), memoryPolicy.getExpireAfterTimeUnit()).build();
    }

    private void initMemCache(MemoryPolicy memoryPolicy) {
        this.memCache = CacheBuilder.newBuilder().maximumSize(memoryPolicy.getMaxSize()).expireAfterWrite(memoryPolicy.getExpireAfter(), memoryPolicy.getExpireAfterTimeUnit()).build();
    }

    @Override
    @Nonnull
    public Observable<Parsed> get(@Nonnull Key key) {
        return Observable.concat(this.lazyCache(key), this.fetch(key)).take(1);
    }

    @Override
    @Nonnull
    @Experimental
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.get(key).compose(StoreUtil.repeatWhenCacheEvicted(this.refreshSubject, key));
    }

    private Observable<Parsed> lazyCache(final @Nonnull Key key) {
        return Observable.defer((Func0)new Func0<Observable<Parsed>>(){

            public Observable<Parsed> call() {
                return RealInternalStore.this.cache(key);
            }
        }).onErrorResumeNext(new OnErrorResumeWithEmpty());
    }

    Observable<Parsed> cache(final @Nonnull Key key) {
        try {
            return (Observable)this.memCache.get(key, new Callable<Observable<Parsed>>(){

                @Override
                @Nonnull
                public Observable<Parsed> call() throws Exception {
                    return RealInternalStore.this.disk(key);
                }
            });
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @Override
    @Nonnull
    public Observable<Parsed> memory(@Nonnull Key key) {
        Observable cachedValue = (Observable)this.memCache.getIfPresent(key);
        return cachedValue == null ? Observable.empty() : cachedValue;
    }

    @Override
    @Nonnull
    public Observable<Parsed> disk(@Nonnull Key key) {
        if (StoreUtil.shouldReturnNetworkBeforeStale(this.persister, this.stalePolicy, key)) {
            return Observable.empty();
        }
        return this.readDisk(key);
    }

    Observable<Parsed> readDisk(final @Nonnull Key key) {
        return this.persister().read(key).onErrorResumeNext(new OnErrorResumeWithEmpty()).map(new Func1<Raw, Parsed>(){

            public Parsed call(Raw raw) {
                return RealInternalStore.this.parser.call(key, raw);
            }
        }).doOnNext(new Action1<Parsed>(){

            public void call(Parsed parsed) {
                RealInternalStore.this.updateMemory(key, parsed);
                if (RealInternalStore.this.stalePolicy == StalePolicy.REFRESH_ON_STALE && StoreUtil.persisterIsStale(key, RealInternalStore.this.persister)) {
                    RealInternalStore.this.backfillCache(key);
                }
            }
        }).cache();
    }

    void backfillCache(@Nonnull Key key) {
        this.fetch(key).subscribe(new Action1<Parsed>(){

            public void call(Parsed parsed) {
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
            }
        });
    }

    @Override
    @Nonnull
    public Observable<Parsed> fetch(final @Nonnull Key key) {
        return Observable.defer((Func0)new Func0<Observable<Parsed>>(){

            @Nullable
            public Observable<Parsed> call() {
                return RealInternalStore.this.fetchAndPersist(key);
            }
        });
    }

    @Nullable
    Observable<Parsed> fetchAndPersist(final @Nonnull Key key) {
        try {
            return (Observable)this.inFlightRequests.get(key, new Callable<Observable<Parsed>>(){

                @Override
                @Nonnull
                public Observable<Parsed> call() {
                    return RealInternalStore.this.response(key);
                }
            });
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @Nonnull
    Observable<Parsed> response(final @Nonnull Key key) {
        return this.fetcher().fetch(key).flatMap(new Func1<Raw, Observable<Parsed>>(){

            public Observable<Parsed> call(Raw raw) {
                return RealInternalStore.this.persister().write(key, raw).flatMap(new Func1<Boolean, Observable<Parsed>>(){

                    public Observable<Parsed> call(Boolean aBoolean) {
                        return RealInternalStore.this.readDisk(key);
                    }
                });
            }
        }).onErrorResumeNext(new Func1<Throwable, Observable<? extends Parsed>>(){

            public Observable<? extends Parsed> call(Throwable throwable) {
                if (RealInternalStore.this.stalePolicy == StalePolicy.NETWORK_BEFORE_STALE) {
                    return RealInternalStore.this.readDisk(key);
                }
                return Observable.error((Throwable)throwable);
            }
        }).doOnNext(new Action1<Parsed>(){

            public void call(Parsed data) {
                RealInternalStore.this.notifySubscribers(data);
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                RealInternalStore.this.inFlightRequests.invalidate(key);
            }
        }).cache();
    }

    void notifySubscribers(Parsed data) {
        this.subject.onNext(data);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(@Nonnull Key key) {
        Observable stream = this.subject.asObservable();
        if (!this.subject.hasValue()) {
            return stream.startWith(this.get(key));
        }
        return stream;
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.subject.asObservable();
    }

    void updateMemory(@Nonnull Key key, Parsed data) {
        this.memCache.put(key, (Object)Observable.just(data));
    }

    @Override
    @Deprecated
    public void clearMemory() {
        this.clear();
    }

    @Override
    @Deprecated
    public void clearMemory(@Nonnull Key key) {
        this.clear(key);
    }

    @Override
    public void clear() {
        for (Object cachedKey : this.memCache.asMap().keySet()) {
            this.clear((Key)cachedKey);
        }
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.inFlightRequests.invalidate(key);
        this.memCache.invalidate(key);
        this.clearPersister(key);
        this.notifyRefresh(key);
    }

    private void notifyRefresh(Key key) {
        this.refreshSubject.onNext(key);
    }

    private void clearPersister(Key key) {
        boolean isPersisterClearable = this.persister instanceof Clearable;
        if (isPersisterClearable) {
            ((Clearable)((Object)this.persister)).clear(key);
        }
    }

    private long getCacheTTL() {
        return TimeUnit.HOURS.toSeconds(24L);
    }

    private long getCacheSize() {
        return 100L;
    }

    private TimeUnit getCacheTTLTimeUnit() {
        return TimeUnit.SECONDS;
    }

    Persister<Raw, Key> persister() {
        return this.persister;
    }

    Fetcher<Raw, Key> fetcher() {
        return this.fetcher;
    }
}

