/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.store.base.DiskRead;
import com.nytimes.android.external.store.base.DiskWrite;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.MultiParser;
import com.nytimes.android.external.store.base.impl.RealInternalStore;
import com.nytimes.android.external.store.base.impl.RealStore;
import com.nytimes.android.external.store.base.impl.StalePolicy;
import com.nytimes.android.external.store.base.impl.Store;
import com.nytimes.android.external.store.util.NoopParserFunc;
import com.nytimes.android.external.store.util.NoopPersister;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import rx.Observable;

public class RealStoreBuilder<Raw, Parsed, Key> {
    private final List<Parser> parsers = new ArrayList<Parser>();
    private Persister<Raw, Key> persister;
    private Cache<Key, Observable<Parsed>> memCache;
    private Fetcher<Raw, Key> fetcher;
    private StalePolicy stalePolicy = StalePolicy.UNSPECIFIED;

    @Nonnull
    public static <Raw, Parsed, Key> RealStoreBuilder<Raw, Parsed, Key> builder() {
        return new RealStoreBuilder<Raw, Parsed, Key>();
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> fetcher(@Nonnull Fetcher<Raw, Key> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> persister(@Nonnull Persister<Raw, Key> persister) {
        this.persister = persister;
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> persister(final @Nonnull DiskRead<Raw, Key> diskRead, final @Nonnull DiskWrite<Raw, Key> diskWrite) {
        this.persister = new Persister<Raw, Key>(){

            @Override
            @Nonnull
            public Observable<Raw> read(@Nonnull Key key) {
                return diskRead.read(key);
            }

            @Override
            @Nonnull
            public Observable<Boolean> write(@Nonnull Key key, @Nonnull Raw raw) {
                return diskWrite.write(key, raw);
            }
        };
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> parser(@Nonnull Parser<Raw, Parsed> parser) {
        this.parsers.clear();
        this.parsers.add(parser);
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> parsers(@Nonnull List<Parser> parsers) {
        this.parsers.clear();
        this.parsers.addAll(parsers);
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> memory(Cache<Key, Observable<Parsed>> memCache) {
        this.memCache = memCache;
        return this;
    }

    public RealStoreBuilder<Raw, Parsed, Key> refreshOnStale() {
        this.stalePolicy = StalePolicy.REFRESH_ON_STALE;
        return this;
    }

    @Nonnull
    public RealStoreBuilder<Raw, Parsed, Key> networkBeforeStale() {
        this.stalePolicy = StalePolicy.NETWORK_BEFORE_STALE;
        return this;
    }

    @Nonnull
    public Store<Parsed, Key> open() {
        if (this.persister == null) {
            this.persister = new NoopPersister();
        }
        if (this.parsers.isEmpty()) {
            this.parser(new NoopParserFunc());
        }
        MultiParser multiParser = new MultiParser(this.parsers);
        RealInternalStore realInternalStore = this.memCache == null ? new RealInternalStore(this.fetcher, this.persister, multiParser, this.stalePolicy) : new RealInternalStore(this.fetcher, this.persister, multiParser, this.memCache, this.stalePolicy);
        return new RealStore(realInternalStore);
    }
}

