/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.InternalStore;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.RealInternalStore;
import com.nytimes.android.external.store.base.impl.StalePolicy;
import com.nytimes.android.external.store.base.impl.Store;
import com.nytimes.android.external.store.util.NoopParserFunc;
import com.nytimes.android.external.store.util.NoopPersister;
import javax.annotation.Nonnull;
import rx.Observable;

public class RealStore<Parsed, Key>
implements Store<Parsed, Key> {
    private final InternalStore<Parsed, Key> internalStore;

    RealStore(InternalStore<Parsed, Key> internalStore) {
        this.internalStore = internalStore;
    }

    public RealStore(Fetcher<Parsed, Key> fetcher) {
        this.internalStore = new RealInternalStore(fetcher, new NoopPersister(), new NoopParserFunc(), StalePolicy.UNSPECIFIED);
    }

    public RealStore(Fetcher<Parsed, Key> fetcher, Persister<Parsed, Key> persister) {
        this.internalStore = new RealInternalStore(fetcher, persister, new NoopParserFunc(), StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Parser<Raw, Parsed> parser) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, parser, StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Parser<Raw, Parsed> parser, Cache<Key, Observable<Parsed>> memCache) {
        this.internalStore = new RealInternalStore<Raw, Parsed, Key>(fetcher, persister, parser, memCache, StalePolicy.UNSPECIFIED);
    }

    public <Raw> RealStore(Fetcher<Raw, Key> fetcher, Persister<Raw, Key> persister, Cache<Key, Observable<Parsed>> memCache) {
        this.internalStore = new RealInternalStore(fetcher, persister, new NoopParserFunc(), memCache, StalePolicy.UNSPECIFIED);
    }

    @Override
    @Nonnull
    public Observable<Parsed> get(@Nonnull Key key) {
        return this.internalStore.get(key);
    }

    @Override
    public Observable<Parsed> getRefreshing(@Nonnull Key key) {
        return this.internalStore.getRefreshing(key);
    }

    @Override
    @Nonnull
    public Observable<Parsed> fetch(@Nonnull Key key) {
        return this.internalStore.fetch(key);
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream() {
        return this.internalStore.stream();
    }

    @Override
    @Nonnull
    public Observable<Parsed> stream(Key key) {
        return this.internalStore.stream(key);
    }

    @Override
    public void clearMemory() {
        this.internalStore.clearMemory();
    }

    @Override
    public void clearMemory(@Nonnull Key key) {
        this.internalStore.clearMemory(key);
    }

    @Override
    public void clear() {
        this.internalStore.clear();
    }

    @Override
    public void clear(@Nonnull Key key) {
        this.internalStore.clear();
    }

    protected Observable<Parsed> memory(@Nonnull Key key) {
        return this.internalStore.memory(key);
    }

    @Nonnull
    protected Observable<Parsed> disk(@Nonnull Key key) {
        return this.internalStore.disk(key);
    }
}

