/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.store.base.DiskRead;
import com.nytimes.android.external.store.base.DiskWrite;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.Store;
import com.nytimes.android.external.store.base.impl.BarCode;
import com.nytimes.android.external.store.base.impl.RealInternalStore;
import com.nytimes.android.external.store.base.impl.RealStore;
import com.nytimes.android.external.store.util.NoopParserFunc;
import com.nytimes.android.external.store.util.NoopPersister;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import rx.Observable;
import rx.functions.Func1;

public class StoreBuilder<T> {
    private Fetcher<T> fetcher;
    private Persister<T> persister;
    private Cache<BarCode, Observable<T>> memCache;

    @NotNull
    public static <Raw> StoreBuilder<Raw> builder() {
        return new StoreBuilder();
    }

    @NotNull
    public StoreBuilder<T> fetcher(@NotNull Fetcher<T> fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @NotNull
    public StoreBuilder<T> nonObservableFetcher(final @NotNull Func1<BarCode, T> fetcher) {
        this.fetcher = new Fetcher<T>(){

            @Override
            @NotNull
            public Observable<T> fetch(final BarCode barCode) {
                return Observable.fromCallable((Callable)new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return fetcher.call((Object)barCode);
                    }
                });
            }
        };
        return this;
    }

    @NotNull
    public StoreBuilder<T> persister(@NotNull Persister<T> persister) {
        this.persister = persister;
        return this;
    }

    @NotNull
    public StoreBuilder<T> persister(final @NotNull DiskRead<T> diskRead, final @NotNull DiskWrite<T> diskWrite) {
        this.persister = new Persister<T>(){

            @Override
            @NotNull
            public Observable<T> read(BarCode barCode) {
                return diskRead.read(barCode);
            }

            @Override
            @NotNull
            public Observable<Boolean> write(BarCode barCode, T t) {
                return diskWrite.write(barCode, t);
            }
        };
        return this;
    }

    @NotNull
    public StoreBuilder<T> memory(Cache<BarCode, Observable<T>> memCache) {
        this.memCache = memCache;
        return this;
    }

    @NotNull
    public Store<T> open() {
        if (this.persister == null) {
            this.persister = new NoopPersister<T>();
        }
        RealInternalStore internalStore = this.memCache == null ? new RealInternalStore(this.fetcher, this.persister, new NoopParserFunc()) : new RealInternalStore(this.fetcher, this.persister, new NoopParserFunc(), this.memCache);
        return new RealStore(internalStore);
    }
}

