/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.InternalStore;
import com.nytimes.android.external.store.base.Parser;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.Store;
import com.nytimes.android.external.store.base.impl.BarCode;
import com.nytimes.android.external.store.base.impl.RealInternalStore;
import com.nytimes.android.external.store.util.NoopParserFunc;
import com.nytimes.android.external.store.util.NoopPersister;
import org.jetbrains.annotations.NotNull;
import rx.Observable;
import rx.functions.Func1;

public class RealStore<Parsed>
implements Store<Parsed> {
    private final InternalStore<Parsed> internalStore;

    RealStore(InternalStore<Parsed> internalStore) {
        this.internalStore = internalStore;
    }

    public RealStore(Fetcher<Parsed> fetcher) {
        this.internalStore = new RealInternalStore(fetcher, new NoopPersister(), new NoopParserFunc());
    }

    public RealStore(Fetcher<Parsed> fetcher, Persister<Parsed> persister) {
        this.internalStore = new RealInternalStore(fetcher, persister, new NoopParserFunc());
    }

    public <Raw> RealStore(Fetcher<Raw> fetcher, Persister<Raw> persister, Parser<Raw, Parsed> parser) {
        this.internalStore = new RealInternalStore<Raw, Parsed>(fetcher, persister, parser);
    }

    public <Raw> RealStore(Fetcher<Raw> fetcher, Persister<Raw> persister, Func1<Raw, Parsed> parser, Cache<BarCode, Observable<Parsed>> memCache) {
        this.internalStore = new RealInternalStore<Raw, Parsed>(fetcher, persister, parser, memCache);
    }

    public <Raw> RealStore(Fetcher<Raw> fetcher, Persister<Raw> persister, Cache<BarCode, Observable<Parsed>> memCache) {
        this.internalStore = new RealInternalStore(fetcher, persister, new NoopParserFunc(), memCache);
    }

    @Override
    @NotNull
    public Observable<Parsed> get(@NotNull BarCode barCode) {
        return this.internalStore.get(barCode);
    }

    @Override
    @NotNull
    public Observable<Parsed> fetch(@NotNull BarCode barCode) {
        return this.internalStore.fetch(barCode);
    }

    @Override
    @NotNull
    public Observable<Parsed> stream() {
        return this.internalStore.stream();
    }

    @Override
    @NotNull
    public Observable<Parsed> stream(BarCode id) {
        return this.internalStore.stream(id);
    }

    @Override
    public void clearMemory() {
        this.internalStore.clearMemory();
    }

    @Override
    public void clearMemory(@NotNull BarCode barCode) {
        this.internalStore.clearMemory(barCode);
    }

    protected Observable<Parsed> memory(@NotNull BarCode id) {
        return this.internalStore.memory(id);
    }

    @NotNull
    protected Observable<Parsed> disk(@NotNull BarCode id) {
        return this.internalStore.disk(id);
    }
}

