/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.base.impl;

import com.nytimes.android.external.cache.Cache;
import com.nytimes.android.external.cache.CacheBuilder;
import com.nytimes.android.external.store.base.Fetcher;
import com.nytimes.android.external.store.base.InternalStore;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.BarCode;
import com.nytimes.android.external.store.util.OnErrorResumeWithEmpty;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subjects.BehaviorSubject;

final class RealInternalStore<Raw, Parsed>
implements InternalStore<Parsed> {
    Cache<BarCode, Observable<Parsed>> inFlightRequests;
    Cache<BarCode, Observable<Parsed>> memCache;
    private Fetcher<Raw> fetcher;
    private Persister<Raw> persister;
    private Func1<Raw, Parsed> parser;
    private BehaviorSubject<Parsed> subject;

    RealInternalStore(Fetcher<Raw> fetcher, Persister<Raw> persister, Func1<Raw, Parsed> parser) {
        this.memCache = CacheBuilder.newBuilder().maximumSize(this.getCacheSize()).expireAfterAccess(this.getCacheTTL(), TimeUnit.SECONDS).build();
        this.init(fetcher, persister, parser, this.memCache);
    }

    RealInternalStore(Fetcher<Raw> fetcher, Persister<Raw> persister, Func1<Raw, Parsed> parser, Cache<BarCode, Observable<Parsed>> memCache) {
        this.init(fetcher, persister, parser, memCache);
    }

    private void init(Fetcher<Raw> fetcher, Persister<Raw> persister, Func1<Raw, Parsed> parser, Cache<BarCode, Observable<Parsed>> memCache) {
        this.fetcher = fetcher;
        this.persister = persister;
        this.parser = parser;
        this.memCache = memCache;
        this.inFlightRequests = CacheBuilder.newBuilder().expireAfterWrite(TimeUnit.MINUTES.toSeconds(1L), TimeUnit.SECONDS).build();
        this.subject = BehaviorSubject.create();
    }

    @Override
    @NotNull
    public Observable<Parsed> get(@NotNull BarCode barCode) {
        return Observable.concat(this.lazyCache(barCode), this.fetch(barCode)).take(1);
    }

    private Observable<Parsed> lazyCache(final @NotNull BarCode barCode) {
        return Observable.defer((Func0)new Func0<Observable<Parsed>>(){

            public Observable<Parsed> call() {
                return RealInternalStore.this.cache(barCode);
            }
        }).onErrorResumeNext(new OnErrorResumeWithEmpty());
    }

    private Observable<Parsed> cache(final @NotNull BarCode barCode) {
        try {
            return (Observable)this.memCache.get((Object)barCode, new Callable<Observable<Parsed>>(){

                @Override
                @NotNull
                public Observable<Parsed> call() throws Exception {
                    return RealInternalStore.this.disk(barCode);
                }
            });
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @Override
    public Observable<Parsed> memory(@NotNull BarCode barCode) {
        Observable cachedValue = (Observable)this.memCache.getIfPresent((Object)barCode);
        return cachedValue == null ? Observable.empty() : cachedValue;
    }

    @Override
    public Observable<Parsed> disk(final @NotNull BarCode barCode) {
        return Observable.defer((Func0)new Func0<Observable<Parsed>>(){

            public Observable<Parsed> call() {
                return RealInternalStore.this.persister().read(barCode).onErrorResumeNext(new OnErrorResumeWithEmpty()).map(RealInternalStore.this.parser).doOnNext(new Action1<Parsed>(){

                    public void call(Parsed parsed) {
                        RealInternalStore.this.updateMemory(barCode, parsed);
                    }
                }).cache();
            }
        });
    }

    @Override
    @NotNull
    public Observable<Parsed> fetch(final @NotNull BarCode barCode) {
        return Observable.defer((Func0)new Func0<Observable<Parsed>>(){

            @Nullable
            public Observable<Parsed> call() {
                return RealInternalStore.this.fetchAndPersist(barCode);
            }
        });
    }

    @Nullable
    Observable<Parsed> fetchAndPersist(final @NotNull BarCode barCode) {
        try {
            return (Observable)this.inFlightRequests.get((Object)barCode, new Callable<Observable<Parsed>>(){

                @Override
                @NotNull
                public Observable<Parsed> call() {
                    return RealInternalStore.this.response(barCode);
                }
            });
        }
        catch (ExecutionException e) {
            return Observable.empty();
        }
    }

    @NotNull
    Observable<Parsed> response(final @NotNull BarCode barCode) {
        return this.fetcher().fetch(barCode).flatMap(new Func1<Raw, Observable<Parsed>>(){

            public Observable<Parsed> call(Raw raw) {
                return RealInternalStore.this.persister().write(barCode, raw).flatMap(new Func1<Boolean, Observable<Parsed>>(){

                    @NotNull
                    public Observable<Parsed> call(Boolean aBoolean) {
                        return RealInternalStore.this.disk(barCode);
                    }
                });
            }
        }).doOnNext(new Action1<Parsed>(){

            public void call(Parsed data) {
                RealInternalStore.this.notifySubscribers(data);
            }
        }).cache();
    }

    void notifySubscribers(Parsed data) {
        this.subject.onNext(data);
    }

    @Override
    @NotNull
    public Observable<Parsed> stream(@NotNull BarCode id) {
        Observable stream = this.subject.asObservable();
        if (!this.subject.hasValue()) {
            return stream.startWith(this.get(id));
        }
        return stream;
    }

    @Override
    @NotNull
    public Observable<Parsed> stream() {
        return this.subject.asObservable();
    }

    void updateMemory(@NotNull BarCode barCode, Parsed data) {
        this.memCache.put((Object)barCode, (Object)Observable.just(data));
    }

    @Override
    public void clearMemory() {
        this.memCache.invalidateAll();
    }

    @Override
    public void clearMemory(@NotNull BarCode barCode) {
        this.memCache.invalidate((Object)barCode);
    }

    private long getCacheTTL() {
        return TimeUnit.HOURS.toSeconds(24L);
    }

    private long getCacheSize() {
        return 100L;
    }

    Persister<Raw> persister() {
        return this.persister;
    }

    Fetcher<Raw> fetcher() {
        return this.fetcher;
    }
}

