/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware;

import com.google.gson.Gson;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.base.Parser;
import java.lang.reflect.Type;
import javax.inject.Inject;

public class GsonStringParser<Parsed>
implements Parser<String, Parsed> {
    private final Gson gson;
    private final Type type;

    @Inject
    public GsonStringParser(Gson gson, Type parsedClass) {
        Preconditions.checkNotNull((Object)gson, (String)"Gson can't be null");
        Preconditions.checkNotNull((Object)parsedClass, (String)"Type can't be null");
        this.gson = gson;
        this.type = parsedClass;
    }

    public Parsed call(String source) {
        return (Parsed)this.gson.fromJson(source, this.type);
    }
}

