/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware;

import com.google.gson.Gson;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.store.base.Parser;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class GsonReaderParser<Parsed>
implements Parser<Reader, Parsed> {
    private final Gson gson;
    private final Type type;

    @Inject
    public GsonReaderParser(Gson gson, Type type) {
        Preconditions.checkNotNull((Object)gson, (String)"Gson can't be null");
        Preconditions.checkNotNull((Object)type, (String)"Type can't be null");
        this.gson = gson;
        this.type = type;
    }

    public Parsed call(@NotNull Reader reader) {
        return (Parsed)this.gson.fromJson(reader, this.type);
    }
}

