/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store.middleware.moshi;

import com.nytimes.android.external.fs.BufferedSourceAdapter;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public class MoshiBufferedSourceAdapter<Parsed>
implements BufferedSourceAdapter<Parsed> {
    private final JsonAdapter<Parsed> jsonAdapter;

    @Inject
    public MoshiBufferedSourceAdapter(@Nonnull Moshi moshi, @Nonnull Type type) {
        this.jsonAdapter = moshi.adapter(type);
    }

    @Nonnull
    public BufferedSource toJson(@Nonnull Parsed value) {
        Buffer buffer = new Buffer();
        try {
            this.jsonAdapter.toJson((BufferedSink)buffer, value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return buffer;
    }
}

