/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.store3.middleware.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nytimes.android.external.fs3.BufferedSourceAdapter;
import io.reactivex.exceptions.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class JacksonBufferedSourceAdapter<Parsed>
implements BufferedSourceAdapter<Parsed> {
    private final ObjectMapper objectMapper;

    @Inject
    public JacksonBufferedSourceAdapter(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Nonnull
    public BufferedSource toJson(@Nonnull Parsed value) {
        try {
            return Okio.buffer((Source)Okio.source((InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(value))));
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

