/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3.filesystem;

import com.nytimes.android.external.cache3.CacheBuilder;
import com.nytimes.android.external.cache3.CacheLoader;
import com.nytimes.android.external.cache3.LoadingCache;
import com.nytimes.android.external.fs3.Util;
import com.nytimes.android.external.fs3.filesystem.BreadthFirstFileTreeIterator;
import com.nytimes.android.external.fs3.filesystem.FSFile;
import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.store3.base.RecordState;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okio.BufferedSource;

class FileSystemImpl
implements FileSystem {
    private final Util util = new Util();
    @Nonnull
    private final LoadingCache<String, FSFile> files;
    @Nonnull
    private final File root;

    FileSystemImpl(final @Nonnull File root) throws IOException {
        this.root = root;
        this.files = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, FSFile>(){

            @Nonnull
            public FSFile load(@Nonnull String path) throws IOException {
                return new FSFile(root, path);
            }
        });
        this.util.createParentDirs(root);
    }

    @Override
    @Nonnull
    public BufferedSource read(@Nonnull String path) throws FileNotFoundException {
        return this.getFile(path).source();
    }

    @Override
    public void write(@Nonnull String path, BufferedSource source) throws IOException {
        this.getFile(path).write(source);
    }

    @Override
    public void delete(@Nonnull String path) throws IOException {
        this.getFile(path).delete();
    }

    @Override
    @Nonnull
    public Collection<String> list(@Nonnull String directory) throws FileNotFoundException {
        Collection<FSFile> foundFiles = this.findFiles(directory);
        ArrayList<String> names = new ArrayList<String>(foundFiles.size());
        for (FSFile foundFile : foundFiles) {
            names.add(foundFile.path());
        }
        return names;
    }

    @Override
    public void deleteAll(@Nonnull String directory) throws FileNotFoundException {
        Collection<FSFile> foundFiles = this.findFiles(directory);
        for (FSFile foundFile : foundFiles) {
            foundFile.delete();
        }
    }

    @Override
    public boolean exists(@Nonnull String path) {
        return this.getFile(path).exists();
    }

    @Override
    public RecordState getRecordState(@Nonnull TimeUnit expirationUnit, long expirationDuration, @Nonnull String path) {
        FSFile file = this.getFile(path);
        if (!file.exists()) {
            return RecordState.MISSING;
        }
        long now = System.currentTimeMillis();
        long cuttOffPoint = now - TimeUnit.MILLISECONDS.convert(expirationDuration, expirationUnit);
        if (file.lastModified() < cuttOffPoint) {
            return RecordState.STALE;
        }
        return RecordState.FRESH;
    }

    @Nullable
    private FSFile getFile(@Nonnull String path) {
        return (FSFile)this.files.getUnchecked((Object)this.cleanPath(path));
    }

    @Nonnull
    private String cleanPath(@Nonnull String dirty) {
        return this.util.simplifyPath(dirty);
    }

    @Nonnull
    private Collection<FSFile> findFiles(@Nonnull String path) throws FileNotFoundException {
        File searchRoot = new File(this.root, this.util.simplifyPath(path));
        if (searchRoot.exists() && searchRoot.isFile()) {
            throw new FileNotFoundException(String.format("expecting a directory at %s, instead found a file", path));
        }
        ArrayList<FSFile> foundFiles = new ArrayList<FSFile>();
        BreadthFirstFileTreeIterator iterator = new BreadthFirstFileTreeIterator(searchRoot);
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            foundFiles.add((FSFile)this.files.getUnchecked((Object)this.util.simplifyPath(file.getPath().replaceFirst(this.root.getPath(), ""))));
        }
        return foundFiles;
    }
}

