/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs3;

import com.nytimes.android.external.fs3.filesystem.FileSystem;
import com.nytimes.android.external.store3.base.DiskAllRead;
import io.reactivex.Observable;
import io.reactivex.exceptions.Exceptions;
import java.io.FileNotFoundException;
import javax.annotation.Nonnull;
import okio.BufferedSource;

public class FSAllReader
implements DiskAllRead {
    final FileSystem fileSystem;

    public FSAllReader(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Nonnull
    public Observable<BufferedSource> readAll(@Nonnull String path) throws FileNotFoundException {
        return Observable.defer(() -> {
            Observable bufferedSourceObservable = null;
            try {
                bufferedSourceObservable = Observable.fromIterable(this.fileSystem.list(path)).map(s -> {
                    try {
                        return this.fileSystem.read((String)s);
                    }
                    catch (FileNotFoundException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                });
            }
            catch (FileNotFoundException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            return bufferedSourceObservable;
        });
    }
}

