/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs.filesystem;

import com.nytimes.android.external.fs.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

class FSFile {
    @Nonnull
    private final String pathValue;
    @Nonnull
    private final File file;

    FSFile(File root, @Nonnull String path) throws IOException {
        this.pathValue = path;
        this.file = new File(root, path);
        if (this.file.exists() && this.file.isDirectory()) {
            throw new FileNotFoundException(String.format("expecting a file at %s, instead found a directory", path));
        }
        Util util = new Util();
        util.createParentDirs(this.file);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        if (!this.file.delete()) {
            throw new IllegalStateException("unable to delete " + this.file);
        }
    }

    @Nonnull
    public String path() {
        return this.pathValue;
    }

    public void write(@Nonnull BufferedSource source) throws IOException {
        File tmpFile = File.createTempFile("new", "tmp", this.file.getParentFile());
        BufferedSink sink = null;
        try {
            sink = Okio.buffer((Sink)Okio.sink((File)tmpFile));
            sink.writeAll((Source)source);
            if (!tmpFile.renameTo(this.file)) {
                throw new IOException("unable to move tmp file to " + this.file.getPath());
            }
        }
        catch (Exception e) {
            throw new IOException("unable to write to file", e);
        }
        finally {
            tmpFile.delete();
            if (sink != null) {
                sink.close();
            }
            source.close();
        }
    }

    @Nonnull
    public BufferedSource source() throws FileNotFoundException {
        if (this.file.exists()) {
            return Okio.buffer((Source)Okio.source((File)this.file));
        }
        throw new FileNotFoundException(this.pathValue);
    }

    public long lastModified() {
        return this.file.lastModified();
    }
}

