/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.FSReader;
import com.nytimes.android.external.fs.FSWriter;
import com.nytimes.android.external.fs.PathResolver;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.RecordProvider;
import com.nytimes.android.external.store.base.RecordState;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okio.BufferedSource;
import rx.Observable;

public final class FileSystemRecordPersister<Key>
implements Persister<BufferedSource, Key>,
RecordProvider<Key> {
    private final FSReader<Key> fileReader;
    private final FSWriter<Key> fileWriter;
    private final FileSystem fileSystem;
    private final PathResolver<Key> pathResolver;
    private final long expirationDuration;
    @Nonnull
    private final TimeUnit expirationUnit;

    private FileSystemRecordPersister(FileSystem fileSystem, PathResolver<Key> pathResolver, long expirationDuration, @Nonnull TimeUnit expirationUnit) {
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
        this.expirationDuration = expirationDuration;
        this.expirationUnit = expirationUnit;
        this.fileReader = new FSReader<Key>(fileSystem, pathResolver);
        this.fileWriter = new FSWriter<Key>(fileSystem, pathResolver);
    }

    @Nonnull
    public static <T> FileSystemRecordPersister<T> create(FileSystem fileSystem, PathResolver<T> pathResolver, long expirationDuration, @Nonnull TimeUnit expirationUnit) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("root file cannot be null.");
        }
        return new FileSystemRecordPersister<T>(fileSystem, pathResolver, expirationDuration, expirationUnit);
    }

    @Nonnull
    public RecordState getRecordState(@Nonnull Key key) {
        return this.fileSystem.getRecordState(this.expirationUnit, this.expirationDuration, this.pathResolver.resolve(key));
    }

    @Nonnull
    public Observable<BufferedSource> read(@Nonnull Key key) {
        return this.fileReader.read(key);
    }

    @Nonnull
    public Observable<Boolean> write(@Nonnull Key key, @Nonnull BufferedSource bufferedSource) {
        return this.fileWriter.write(key, bufferedSource);
    }
}

