/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.fs;

import com.nytimes.android.external.fs.SourceFileReader;
import com.nytimes.android.external.fs.SourceFileWriter;
import com.nytimes.android.external.fs.filesystem.FileSystem;
import com.nytimes.android.external.store.base.Persister;
import com.nytimes.android.external.store.base.impl.BarCode;
import javax.inject.Inject;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import rx.Observable;

public class SourcePersister
implements Persister<BufferedSource> {
    @NotNull
    private final SourceFileReader sourceFileReader;
    @NotNull
    private final SourceFileWriter sourceFileWriter;

    @Inject
    public SourcePersister(FileSystem fileSystem) {
        this.sourceFileReader = new SourceFileReader(fileSystem);
        this.sourceFileWriter = new SourceFileWriter(fileSystem);
    }

    @NotNull
    public Observable<BufferedSource> read(@NotNull BarCode barCode) {
        return this.sourceFileReader.exists(barCode) ? this.sourceFileReader.read(barCode) : Observable.empty();
    }

    @NotNull
    public Observable<Boolean> write(@NotNull BarCode barCode, @NotNull BufferedSource data) {
        return this.sourceFileWriter.write(barCode, data);
    }

    @NotNull
    static String pathForBarcode(@NotNull BarCode barCode) {
        return barCode.getType() + barCode.getKey();
    }
}

