/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.cache3;

import com.nytimes.android.external.cache3.Preconditions;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class MoreObjects {
    public static <T> T firstNonNull(T first, T second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    @Nonnull
    public static ToStringHelper toStringHelper(@Nonnull Object self) {
        return new ToStringHelper(self.getClass().getSimpleName());
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper {
        private final String className;
        @Nonnull
        private ValueHolder holderHead;
        @Nonnull
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(@Nonnull String className) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(className);
        }

        @Nonnull
        public ToStringHelper add(@Nonnull String name, Object value) {
            return this.addHolder(name, value);
        }

        @Nonnull
        public ToStringHelper add(@Nonnull String name, int value) {
            return this.addHolder(name, String.valueOf(value));
        }

        @Nonnull
        public ToStringHelper add(@Nonnull String name, long value) {
            return this.addHolder(name, String.valueOf(value));
        }

        @Nonnull
        public ToStringHelper addValue(Object value) {
            return this.addHolder(value);
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object value = valueHolder.value;
                if (!omitNullValuesSnapshot || value != null) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    if (value != null && value.getClass().isArray()) {
                        Object[] objectArray = new Object[]{value};
                        String arrayString = Arrays.deepToString(objectArray);
                        builder.append(arrayString.substring(1, arrayString.length() - 1));
                    } else {
                        builder.append(value);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        @Nonnull
        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        @Nonnull
        private ToStringHelper addHolder(Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            return this;
        }

        @Nonnull
        private ToStringHelper addHolder(@Nonnull String name, Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = Preconditions.checkNotNull(name);
            return this;
        }

        private static final class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

