/*
 * Decompiled with CFR 0.152.
 */
package com.nytimes.android.external.cache;

import com.nytimes.android.external.cache.AbstractFuture;
import com.nytimes.android.external.cache.DirectExecutor;
import com.nytimes.android.external.cache.Function;
import com.nytimes.android.external.cache.FuturesGetChecked;
import com.nytimes.android.external.cache.ListenableFuture;
import com.nytimes.android.external.cache.Preconditions;
import com.nytimes.android.external.cache.Uninterruptibles;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Futures {
    private Futures() {
    }

    @Nullable
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        if (value == null) {
            return ImmediateSuccessfulFuture.NULL;
        }
        return new ImmediateSuccessfulFuture<V>(value);
    }

    @Nonnull
    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFailedFuture(throwable);
    }

    @Nonnull
    public static <I, O> ListenableFuture<O> transform(@Nonnull ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(function);
        ChainingFuture<? super I, ? extends O> output = new ChainingFuture<I, O>(input, function);
        input.addListener(output, DirectExecutor.INSTANCE);
        return output;
    }

    public static <V, X extends Exception> V getChecked(@Nonnull Future<V> future, Class<X> exceptionClass) throws X {
        return FuturesGetChecked.getChecked(future, exceptionClass);
    }

    public static <V, X extends Exception> V getChecked(@Nonnull Future<V> future, Class<X> exceptionClass, long timeout, @Nonnull TimeUnit unit) throws X {
        return FuturesGetChecked.getChecked(future, exceptionClass, timeout, unit);
    }

    private static abstract class ImmediateFuture<V>
    implements ListenableFuture<V> {
        private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

        private ImmediateFuture() {
        }

        @Override
        public void addListener(@Nonnull Runnable listener, @Nonnull Executor executor) {
            Preconditions.checkNotNull(listener, "Runnable was null.");
            Preconditions.checkNotNull(executor, "Executor was null.");
            try {
                executor.execute(listener);
            }
            catch (RuntimeException var4) {
                log.log(Level.SEVERE, "RuntimeException while executing runnable " + listener + " with executor " + executor, var4);
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public abstract V get() throws ExecutionException;

        @Override
        public V get(long timeout, @Nonnull TimeUnit unit) throws ExecutionException {
            Preconditions.checkNotNull(unit);
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    private static class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        @Nullable
        static final ImmediateSuccessfulFuture<Object> NULL = new ImmediateSuccessfulFuture<Object>(null);
        private final V value;

        ImmediateSuccessfulFuture(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }

    private static class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        private final Throwable thrown;

        ImmediateFailedFuture(Throwable thrown) {
            this.thrown = thrown;
        }

        @Override
        @Nonnull
        public V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }
    }

    private static abstract class AbstractChainingFuture<I, O, F>
    extends AbstractFuture.TrustedFuture<O>
    implements Runnable {
        @Nullable
        ListenableFuture<? extends I> inputFuture;
        @Nullable
        F function;

        AbstractChainingFuture(ListenableFuture<? extends I> inputFuture, F function) {
            this.inputFuture = Preconditions.checkNotNull(inputFuture);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public final void run() {
            try {
                I sourceResult;
                ListenableFuture<? extends I> localInputFuture = this.inputFuture;
                F localFunction = this.function;
                if (this.isCancelled() | localInputFuture == null | localFunction == null) {
                    return;
                }
                this.inputFuture = null;
                this.function = null;
                try {
                    sourceResult = Uninterruptibles.getUninterruptibly(localInputFuture);
                }
                catch (CancellationException e) {
                    this.cancel(false);
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    return;
                }
                this.doTransform(localFunction, sourceResult);
            }
            catch (UndeclaredThrowableException e) {
                this.setException(e.getCause());
            }
            catch (Throwable t) {
                this.setException(t);
            }
        }

        abstract void doTransform(F var1, I var2) throws Exception;

        @Override
        final void done() {
            this.maybePropagateCancellation(this.inputFuture);
            this.inputFuture = null;
        }
    }

    private static final class ChainingFuture<I, O>
    extends AbstractChainingFuture<I, O, Function<? super I, ? extends O>> {
        ChainingFuture(ListenableFuture<? extends I> inputFuture, Function<? super I, ? extends O> function) {
            super(inputFuture, function);
        }

        @Override
        void doTransform(@Nonnull Function<? super I, ? extends O> function, I input) {
            this.set(function.apply(input));
        }
    }
}

