/*
 * Decompiled with CFR 0.152.
 */
package com.nvvi9.model.streams;

import com.nvvi9.model.codecs.AudioCodec;
import com.nvvi9.model.codecs.VideoCodec;
import com.nvvi9.model.streams.Extension;
import com.nvvi9.model.streams.StreamDetails;
import com.nvvi9.model.streams.StreamType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/nvvi9/model/streams/Stream;", "", "url", "", "streamDetails", "Lcom/nvvi9/model/streams/StreamDetails;", "(Ljava/lang/String;Lcom/nvvi9/model/streams/StreamDetails;)V", "getStreamDetails", "()Lcom/nvvi9/model/streams/StreamDetails;", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "YTStream_release"})
public final class Stream {
    @NotNull
    private final String url;
    @NotNull
    private final StreamDetails streamDetails;
    private static final Map<Integer, StreamDetails> ITAG_MAP;
    public static final Companion Companion;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final StreamDetails getStreamDetails() {
        return this.streamDetails;
    }

    public Stream(@NotNull String url, @NotNull StreamDetails streamDetails) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)streamDetails, (String)"streamDetails");
        this.url = url;
        this.streamDetails = streamDetails;
    }

    static {
        Companion = new Companion(null);
        ITAG_MAP = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)140, (Object)new StreamDetails(140, StreamType.AUDIO, Extension.M4A, AudioCodec.AAC, null, null, 128, null, 128, null)), TuplesKt.to((Object)141, (Object)new StreamDetails(141, StreamType.AUDIO, Extension.M4A, AudioCodec.AAC, null, null, 256, null, 128, null)), TuplesKt.to((Object)256, (Object)new StreamDetails(256, StreamType.AUDIO, Extension.M4A, AudioCodec.AAC, null, null, 192, null, 128, null)), TuplesKt.to((Object)258, (Object)new StreamDetails(258, StreamType.AUDIO, Extension.M4A, AudioCodec.AAC, null, null, 384, null, 128, null)), TuplesKt.to((Object)171, (Object)new StreamDetails(171, StreamType.AUDIO, Extension.WEBM, AudioCodec.VORBIS, null, null, 128, null, 128, null)), TuplesKt.to((Object)249, (Object)new StreamDetails(249, StreamType.AUDIO, Extension.WEBM, AudioCodec.OPUS, null, null, 48, null, 128, null)), TuplesKt.to((Object)250, (Object)new StreamDetails(250, StreamType.AUDIO, Extension.WEBM, AudioCodec.OPUS, null, null, 64, null, 128, null)), TuplesKt.to((Object)251, (Object)new StreamDetails(251, StreamType.AUDIO, Extension.WEBM, AudioCodec.OPUS, null, null, 160, null, 128, null)), TuplesKt.to((Object)160, (Object)new StreamDetails(160, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 144, null, null, 128, null)), TuplesKt.to((Object)133, (Object)new StreamDetails(133, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 240, null, null, 128, null)), TuplesKt.to((Object)134, (Object)new StreamDetails(134, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 360, null, null, 128, null)), TuplesKt.to((Object)135, (Object)new StreamDetails(135, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 480, null, null, 128, null)), TuplesKt.to((Object)136, (Object)new StreamDetails(136, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 720, null, null, 128, null)), TuplesKt.to((Object)137, (Object)new StreamDetails(137, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 1080, null, null, 128, null)), TuplesKt.to((Object)264, (Object)new StreamDetails(264, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 1440, null, null, 128, null)), TuplesKt.to((Object)266, (Object)new StreamDetails(266, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 2160, null, null, 128, null)), TuplesKt.to((Object)298, (Object)new StreamDetails(298, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 720, null, 60)), TuplesKt.to((Object)299, (Object)new StreamDetails(299, StreamType.VIDEO, Extension.MP4, null, VideoCodec.H264, 1080, null, 60)), TuplesKt.to((Object)278, (Object)new StreamDetails(278, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 144, null, null, 128, null)), TuplesKt.to((Object)242, (Object)new StreamDetails(242, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 240, null, null, 128, null)), TuplesKt.to((Object)243, (Object)new StreamDetails(243, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 360, null, null, 128, null)), TuplesKt.to((Object)244, (Object)new StreamDetails(244, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 480, null, null, 128, null)), TuplesKt.to((Object)247, (Object)new StreamDetails(247, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 720, null, null, 128, null)), TuplesKt.to((Object)248, (Object)new StreamDetails(248, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 1080, null, null, 128, null)), TuplesKt.to((Object)271, (Object)new StreamDetails(271, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 1440, null, null, 128, null)), TuplesKt.to((Object)313, (Object)new StreamDetails(313, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 2160, null, null, 128, null)), TuplesKt.to((Object)302, (Object)new StreamDetails(302, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 720, null, 60)), TuplesKt.to((Object)308, (Object)new StreamDetails(308, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 1440, null, 60)), TuplesKt.to((Object)303, (Object)new StreamDetails(303, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 1080, null, 60)), TuplesKt.to((Object)315, (Object)new StreamDetails(315, StreamType.VIDEO, Extension.WEBM, null, VideoCodec.VP9, 2160, null, 60)), TuplesKt.to((Object)17, (Object)new StreamDetails(17, StreamType.MULTIPLEXED, Extension.3GP, AudioCodec.AAC, VideoCodec.MPEG4, 144, 24, null, 128, null)), TuplesKt.to((Object)36, (Object)new StreamDetails(36, StreamType.MULTIPLEXED, Extension.3GP, AudioCodec.AAC, VideoCodec.MPEG4, 240, 32, null, 128, null)), TuplesKt.to((Object)5, (Object)new StreamDetails(5, StreamType.MULTIPLEXED, Extension.FLV, AudioCodec.MP3, VideoCodec.H263, 144, 64, null, 128, null)), TuplesKt.to((Object)43, (Object)new StreamDetails(43, StreamType.MULTIPLEXED, Extension.WEBM, AudioCodec.VORBIS, VideoCodec.VP8, 360, 128, null, 128, null)), TuplesKt.to((Object)18, (Object)new StreamDetails(18, StreamType.MULTIPLEXED, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 360, 96, null, 128, null)), TuplesKt.to((Object)22, (Object)new StreamDetails(22, StreamType.MULTIPLEXED, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 720, 192, null, 128, null)), TuplesKt.to((Object)91, (Object)new StreamDetails(91, StreamType.LIVE, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 144, 48, null, 128, null)), TuplesKt.to((Object)92, (Object)new StreamDetails(92, StreamType.LIVE, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 240, 48, null, 128, null)), TuplesKt.to((Object)93, (Object)new StreamDetails(93, StreamType.LIVE, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 360, 128, null, 128, null)), TuplesKt.to((Object)94, (Object)new StreamDetails(94, StreamType.LIVE, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 480, 128, null, 128, null)), TuplesKt.to((Object)95, (Object)new StreamDetails(95, StreamType.LIVE, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 720, 256, null, 128, null)), TuplesKt.to((Object)96, (Object)new StreamDetails(96, StreamType.LIVE, Extension.MP4, AudioCodec.AAC, VideoCodec.H264, 1080, 256, null, 128, null))});
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final StreamDetails component2() {
        return this.streamDetails;
    }

    @NotNull
    public final Stream copy(@NotNull String url, @NotNull StreamDetails streamDetails) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)streamDetails, (String)"streamDetails");
        return new Stream(url, streamDetails);
    }

    public static /* synthetic */ Stream copy$default(Stream stream, String string, StreamDetails streamDetails, int n, Object object) {
        if ((n & 1) != 0) {
            string = stream.url;
        }
        if ((n & 2) != 0) {
            streamDetails = stream.streamDetails;
        }
        return stream.copy(string, streamDetails);
    }

    @NotNull
    public String toString() {
        return "Stream(url=" + this.url + ", streamDetails=" + this.streamDetails + ")";
    }

    public int hashCode() {
        String string = this.url;
        StreamDetails streamDetails = this.streamDetails;
        return (string != null ? string.hashCode() : 0) * 31 + (streamDetails != null ? ((Object)streamDetails).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Stream)) break block3;
                Stream stream = (Stream)object;
                if (!Intrinsics.areEqual((Object)this.url, (Object)stream.url) || !Intrinsics.areEqual((Object)this.streamDetails, (Object)stream.streamDetails)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/nvvi9/model/streams/Stream$Companion;", "", "()V", "ITAG_MAP", "", "", "Lcom/nvvi9/model/streams/StreamDetails;", "fromItag", "Lcom/nvvi9/model/streams/Stream;", "itag", "uri", "", "fromItag$YTStream_release", "YTStream_release"})
    public static final class Companion {
        @Nullable
        public final Stream fromItag$YTStream_release(int itag, @NotNull String uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String string = uri;
            Map map = ITAG_MAP;
            Integer n = itag;
            boolean bl = false;
            Object v = map.get(n);
            if (v == null) {
                String string2 = string;
                boolean bl2 = false;
                return null;
            }
            StreamDetails streamDetails = (StreamDetails)v;
            String string3 = string;
            return new Stream(string3, streamDetails);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

