/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.vmm.v4.ahv.config;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.vmm.annotations.VmmJsonDeserializer;
import com.nutanix.dp1.vmm.common.v1.response.ApiLink;
import com.nutanix.dp1.vmm.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import com.nutanix.dp1.vmm.deserializers.VmmOneOfDeserializer;
import com.nutanix.dp1.vmm.serializers.VmmOneOfSerializer;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.ADSFVmStorageConfig;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.ApcConfig;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.AvailabilityZoneReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.CategoryReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.CdRom;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.ClusterReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.CpuFeature;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.Disk;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.Gpu;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.GuestCustomizationParams;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.GuestTools;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.HostReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.LegacyBoot;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.MachineType;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.Nic;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.OwnershipInfo;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.PcieDevice;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.PowerState;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.ProtectionPolicyState;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.ProtectionType;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.SerialPort;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.UefiBoot;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.VmSourceReference;
import com.nutanix.dp1.vmm.vmm.v4.ahv.config.VtpmConfig;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vm
extends ExternalizableAbstractModel
implements Serializable,
VmmObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Vm.class);
    private OffsetDateTime createTime = null;
    private OffsetDateTime updateTime = null;
    private Boolean isLiveMigrateCapable = null;
    private Boolean isCrossClusterMigrationInProgress = null;
    @Size(max=80)
    @JsonProperty(value="name")
    public @Size(max=80) String name = null;
    @JsonProperty(value="description")
    public String description = null;
    @JsonProperty(value="source")
    public VmSourceReference source = null;
    @Min(value=1L)
    @JsonProperty(value="numSockets")
    public @Min(value=1L) Integer numSockets = null;
    @Min(value=1L)
    @JsonProperty(value="numCoresPerSocket")
    public @Min(value=1L) Integer numCoresPerSocket = null;
    @Min(value=1L)
    @JsonProperty(value="numThreadsPerCore")
    public @Min(value=1L) Integer numThreadsPerCore = null;
    @JsonProperty(value="numNumaNodes")
    public Integer numNumaNodes = null;
    @Min(value=1L)
    @JsonProperty(value="memorySizeBytes")
    public @Min(value=1L) Long memorySizeBytes = null;
    @JsonProperty(value="isVcpuHardPinningEnabled")
    public Boolean isVcpuHardPinningEnabled = null;
    @JsonProperty(value="isCpuPassthroughEnabled")
    public Boolean isCpuPassthroughEnabled = null;
    @Size(min=0, max=256)
    @JsonProperty(value="enabledCpuFeatures")
    public @Size(min=0, max=256) List<CpuFeature> enabledCpuFeatures = null;
    @JsonProperty(value="isMemoryOvercommitEnabled")
    public Boolean isMemoryOvercommitEnabled = null;
    @JsonProperty(value="isGpuConsoleEnabled")
    public Boolean isGpuConsoleEnabled = null;
    @JsonProperty(value="isCpuHotplugEnabled")
    public Boolean isCpuHotplugEnabled = null;
    @JsonProperty(value="isScsiControllerEnabled")
    public Boolean isScsiControllerEnabled = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="generationUuid")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String generationUuid = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="biosUuid")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String biosUuid = null;
    @Size(min=0, max=256)
    @JsonProperty(value="categories")
    public @Size(min=0, max=256) List<CategoryReference> categories = null;
    @JsonProperty(value="ownershipInfo")
    public OwnershipInfo ownershipInfo = null;
    @JsonProperty(value="host")
    public HostReference host = null;
    @JsonProperty(value="cluster")
    public ClusterReference cluster = null;
    @JsonProperty(value="availabilityZone")
    public AvailabilityZoneReference availabilityZone = null;
    @JsonProperty(value="guestCustomization")
    public GuestCustomizationParams guestCustomization = null;
    @JsonProperty(value="guestTools")
    public GuestTools guestTools = null;
    @Size(max=64)
    @JsonProperty(value="hardwareClockTimezone")
    public @Size(max=64) String hardwareClockTimezone = "UTC";
    @JsonProperty(value="isBrandingEnabled")
    public Boolean isBrandingEnabled = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $bootConfigItemDiscriminator = null;
    private OneOfBootConfigWrapper bootConfig = null;
    @JsonProperty(value="isVgaConsoleEnabled")
    public Boolean isVgaConsoleEnabled = null;
    @JsonProperty(value="machineType")
    public MachineType machineType = null;
    @JsonProperty(value="powerState")
    public PowerState powerState = null;
    @JsonProperty(value="vtpmConfig")
    public VtpmConfig vtpmConfig = null;
    @JsonProperty(value="isAgentVm")
    public Boolean isAgentVm = null;
    @JsonProperty(value="apcConfig")
    public ApcConfig apcConfig = null;
    @JsonProperty(value="storageConfig")
    public ADSFVmStorageConfig storageConfig = null;
    @Size(min=0, max=1024)
    @JsonProperty(value="disks")
    public @Size(min=0, max=1024) List<Disk> disks = null;
    @Size(min=0, max=10)
    @JsonProperty(value="cdRoms")
    public @Size(min=0, max=10) List<CdRom> cdRoms = null;
    @Size(min=0, max=64)
    @JsonProperty(value="nics")
    public @Size(min=0, max=64) List<Nic> nics = null;
    @Size(min=0, max=16)
    @JsonProperty(value="gpus")
    public @Size(min=0, max=16) List<Gpu> gpus = null;
    @Size(min=0, max=4)
    @JsonProperty(value="serialPorts")
    public @Size(min=0, max=4) List<SerialPort> serialPorts = null;
    @JsonProperty(value="protectionType")
    public ProtectionType protectionType = null;
    @JsonProperty(value="protectionPolicyState")
    public ProtectionPolicyState protectionPolicyState = null;
    @Size(min=0, max=64)
    @JsonProperty(value="pcieDevices")
    public @Size(min=0, max=64) List<PcieDevice> pcieDevices = null;

    public Vm() {
    }

    public Vm(String tenantId, String extId, List<ApiLink> links, String name, String description, OffsetDateTime createTime, OffsetDateTime updateTime, VmSourceReference source, Integer numSockets, Integer numCoresPerSocket, Integer numThreadsPerCore, Integer numNumaNodes, Long memorySizeBytes, Boolean isVcpuHardPinningEnabled, Boolean isCpuPassthroughEnabled, List<CpuFeature> enabledCpuFeatures, Boolean isMemoryOvercommitEnabled, Boolean isGpuConsoleEnabled, Boolean isCpuHotplugEnabled, Boolean isScsiControllerEnabled, String generationUuid, String biosUuid, List<CategoryReference> categories, OwnershipInfo ownershipInfo, HostReference host, ClusterReference cluster, AvailabilityZoneReference availabilityZone, GuestCustomizationParams guestCustomization, GuestTools guestTools, String hardwareClockTimezone, Boolean isBrandingEnabled, Object bootConfig, Boolean isVgaConsoleEnabled, MachineType machineType, PowerState powerState, VtpmConfig vtpmConfig, Boolean isAgentVm, ApcConfig apcConfig, Boolean isLiveMigrateCapable, Boolean isCrossClusterMigrationInProgress, ADSFVmStorageConfig storageConfig, List<Disk> disks, List<CdRom> cdRoms, List<Nic> nics, List<Gpu> gpus, List<SerialPort> serialPorts, ProtectionType protectionType, ProtectionPolicyState protectionPolicyState, List<PcieDevice> pcieDevices) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setCreateTime(createTime);
        this.setUpdateTime(updateTime);
        this.setSource(source);
        this.setNumSockets(numSockets);
        this.setNumCoresPerSocket(numCoresPerSocket);
        this.setNumThreadsPerCore(numThreadsPerCore);
        this.setNumNumaNodes(numNumaNodes);
        this.setMemorySizeBytes(memorySizeBytes);
        this.setIsVcpuHardPinningEnabled(isVcpuHardPinningEnabled);
        this.setIsCpuPassthroughEnabled(isCpuPassthroughEnabled);
        this.setEnabledCpuFeatures(enabledCpuFeatures);
        this.setIsMemoryOvercommitEnabled(isMemoryOvercommitEnabled);
        this.setIsGpuConsoleEnabled(isGpuConsoleEnabled);
        this.setIsCpuHotplugEnabled(isCpuHotplugEnabled);
        this.setIsScsiControllerEnabled(isScsiControllerEnabled);
        this.setGenerationUuid(generationUuid);
        this.setBiosUuid(biosUuid);
        this.setCategories(categories);
        this.setOwnershipInfo(ownershipInfo);
        this.setHost(host);
        this.setCluster(cluster);
        this.setAvailabilityZone(availabilityZone);
        this.setGuestCustomization(guestCustomization);
        this.setGuestTools(guestTools);
        this.setHardwareClockTimezone(hardwareClockTimezone);
        this.setIsBrandingEnabled(isBrandingEnabled);
        this.setBootConfigInWrapper(bootConfig);
        this.setIsVgaConsoleEnabled(isVgaConsoleEnabled);
        this.setMachineType(machineType);
        this.setPowerState(powerState);
        this.setVtpmConfig(vtpmConfig);
        this.setIsAgentVm(isAgentVm);
        this.setApcConfig(apcConfig);
        this.setIsLiveMigrateCapable(isLiveMigrateCapable);
        this.setIsCrossClusterMigrationInProgress(isCrossClusterMigrationInProgress);
        this.setStorageConfig(storageConfig);
        this.setDisks(disks);
        this.setCdRoms(cdRoms);
        this.setNics(nics);
        this.setGpus(gpus);
        this.setSerialPorts(serialPorts);
        this.setProtectionType(protectionType);
        this.setProtectionPolicyState(protectionPolicyState);
        this.setPcieDevices(pcieDevices);
    }

    @Override
    protected String initialize$objectType() {
        return "vmm.v4.ahv.config.Vm";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreateTime(OffsetDateTime createTime) {
        if (this.createTime == null) {
            this.createTime = createTime;
        } else {
            log.warn("Read-only property createTime already contains a non-null value and cannot be set again");
        }
    }

    public void setUpdateTime(OffsetDateTime updateTime) {
        if (this.updateTime == null) {
            this.updateTime = updateTime;
        } else {
            log.warn("Read-only property updateTime already contains a non-null value and cannot be set again");
        }
    }

    public void setIsLiveMigrateCapable(Boolean isLiveMigrateCapable) {
        if (this.isLiveMigrateCapable == null) {
            this.isLiveMigrateCapable = isLiveMigrateCapable;
        } else {
            log.warn("Read-only property isLiveMigrateCapable already contains a non-null value and cannot be set again");
        }
    }

    public void setIsCrossClusterMigrationInProgress(Boolean isCrossClusterMigrationInProgress) {
        if (this.isCrossClusterMigrationInProgress == null) {
            this.isCrossClusterMigrationInProgress = isCrossClusterMigrationInProgress;
        } else {
            log.warn("Read-only property isCrossClusterMigrationInProgress already contains a non-null value and cannot be set again");
        }
    }

    public String get$bootConfigItemDiscriminator() {
        if (this.bootConfig != null && this.$bootConfigItemDiscriminator == null) {
            this.$bootConfigItemDiscriminator = this.bootConfig.getDiscriminator();
        }
        return this.$bootConfigItemDiscriminator;
    }

    @JsonIgnore
    public void setBootConfigInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.bootConfig == null) {
            this.bootConfig = new OneOfBootConfigWrapper();
        }
        this.bootConfig.setValue(value);
        this.$bootConfigItemDiscriminator = this.bootConfig.getDiscriminator();
    }

    @JsonSerialize(using=VmmOneOfSerializer.class)
    public Object getBootConfig() {
        if (this.bootConfig == null) {
            log.debug("OneOf property bootConfig was never set. Returning null...");
            return null;
        }
        return this.bootConfig.getValue();
    }

    public static VmBuilder VmBuilder() {
        return new VmBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vm)) {
            return false;
        }
        Vm other = (Vm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createTime = this.getCreateTime();
        OffsetDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        OffsetDateTime this$updateTime = this.getUpdateTime();
        OffsetDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Boolean this$isLiveMigrateCapable = this.getIsLiveMigrateCapable();
        Boolean other$isLiveMigrateCapable = other.getIsLiveMigrateCapable();
        if (this$isLiveMigrateCapable == null ? other$isLiveMigrateCapable != null : !((Object)this$isLiveMigrateCapable).equals(other$isLiveMigrateCapable)) {
            return false;
        }
        Boolean this$isCrossClusterMigrationInProgress = this.getIsCrossClusterMigrationInProgress();
        Boolean other$isCrossClusterMigrationInProgress = other.getIsCrossClusterMigrationInProgress();
        if (this$isCrossClusterMigrationInProgress == null ? other$isCrossClusterMigrationInProgress != null : !((Object)this$isCrossClusterMigrationInProgress).equals(other$isCrossClusterMigrationInProgress)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        VmSourceReference this$source = this.getSource();
        VmSourceReference other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Integer this$numSockets = this.getNumSockets();
        Integer other$numSockets = other.getNumSockets();
        if (this$numSockets == null ? other$numSockets != null : !((Object)this$numSockets).equals(other$numSockets)) {
            return false;
        }
        Integer this$numCoresPerSocket = this.getNumCoresPerSocket();
        Integer other$numCoresPerSocket = other.getNumCoresPerSocket();
        if (this$numCoresPerSocket == null ? other$numCoresPerSocket != null : !((Object)this$numCoresPerSocket).equals(other$numCoresPerSocket)) {
            return false;
        }
        Integer this$numThreadsPerCore = this.getNumThreadsPerCore();
        Integer other$numThreadsPerCore = other.getNumThreadsPerCore();
        if (this$numThreadsPerCore == null ? other$numThreadsPerCore != null : !((Object)this$numThreadsPerCore).equals(other$numThreadsPerCore)) {
            return false;
        }
        Integer this$numNumaNodes = this.getNumNumaNodes();
        Integer other$numNumaNodes = other.getNumNumaNodes();
        if (this$numNumaNodes == null ? other$numNumaNodes != null : !((Object)this$numNumaNodes).equals(other$numNumaNodes)) {
            return false;
        }
        Long this$memorySizeBytes = this.getMemorySizeBytes();
        Long other$memorySizeBytes = other.getMemorySizeBytes();
        if (this$memorySizeBytes == null ? other$memorySizeBytes != null : !((Object)this$memorySizeBytes).equals(other$memorySizeBytes)) {
            return false;
        }
        Boolean this$isVcpuHardPinningEnabled = this.getIsVcpuHardPinningEnabled();
        Boolean other$isVcpuHardPinningEnabled = other.getIsVcpuHardPinningEnabled();
        if (this$isVcpuHardPinningEnabled == null ? other$isVcpuHardPinningEnabled != null : !((Object)this$isVcpuHardPinningEnabled).equals(other$isVcpuHardPinningEnabled)) {
            return false;
        }
        Boolean this$isCpuPassthroughEnabled = this.getIsCpuPassthroughEnabled();
        Boolean other$isCpuPassthroughEnabled = other.getIsCpuPassthroughEnabled();
        if (this$isCpuPassthroughEnabled == null ? other$isCpuPassthroughEnabled != null : !((Object)this$isCpuPassthroughEnabled).equals(other$isCpuPassthroughEnabled)) {
            return false;
        }
        List<CpuFeature> this$enabledCpuFeatures = this.getEnabledCpuFeatures();
        List<CpuFeature> other$enabledCpuFeatures = other.getEnabledCpuFeatures();
        if (this$enabledCpuFeatures == null ? other$enabledCpuFeatures != null : !((Object)this$enabledCpuFeatures).equals(other$enabledCpuFeatures)) {
            return false;
        }
        Boolean this$isMemoryOvercommitEnabled = this.getIsMemoryOvercommitEnabled();
        Boolean other$isMemoryOvercommitEnabled = other.getIsMemoryOvercommitEnabled();
        if (this$isMemoryOvercommitEnabled == null ? other$isMemoryOvercommitEnabled != null : !((Object)this$isMemoryOvercommitEnabled).equals(other$isMemoryOvercommitEnabled)) {
            return false;
        }
        Boolean this$isGpuConsoleEnabled = this.getIsGpuConsoleEnabled();
        Boolean other$isGpuConsoleEnabled = other.getIsGpuConsoleEnabled();
        if (this$isGpuConsoleEnabled == null ? other$isGpuConsoleEnabled != null : !((Object)this$isGpuConsoleEnabled).equals(other$isGpuConsoleEnabled)) {
            return false;
        }
        Boolean this$isCpuHotplugEnabled = this.getIsCpuHotplugEnabled();
        Boolean other$isCpuHotplugEnabled = other.getIsCpuHotplugEnabled();
        if (this$isCpuHotplugEnabled == null ? other$isCpuHotplugEnabled != null : !((Object)this$isCpuHotplugEnabled).equals(other$isCpuHotplugEnabled)) {
            return false;
        }
        Boolean this$isScsiControllerEnabled = this.getIsScsiControllerEnabled();
        Boolean other$isScsiControllerEnabled = other.getIsScsiControllerEnabled();
        if (this$isScsiControllerEnabled == null ? other$isScsiControllerEnabled != null : !((Object)this$isScsiControllerEnabled).equals(other$isScsiControllerEnabled)) {
            return false;
        }
        String this$generationUuid = this.getGenerationUuid();
        String other$generationUuid = other.getGenerationUuid();
        if (this$generationUuid == null ? other$generationUuid != null : !this$generationUuid.equals(other$generationUuid)) {
            return false;
        }
        String this$biosUuid = this.getBiosUuid();
        String other$biosUuid = other.getBiosUuid();
        if (this$biosUuid == null ? other$biosUuid != null : !this$biosUuid.equals(other$biosUuid)) {
            return false;
        }
        List<CategoryReference> this$categories = this.getCategories();
        List<CategoryReference> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        OwnershipInfo this$ownershipInfo = this.getOwnershipInfo();
        OwnershipInfo other$ownershipInfo = other.getOwnershipInfo();
        if (this$ownershipInfo == null ? other$ownershipInfo != null : !((Object)this$ownershipInfo).equals(other$ownershipInfo)) {
            return false;
        }
        HostReference this$host = this.getHost();
        HostReference other$host = other.getHost();
        if (this$host == null ? other$host != null : !((Object)this$host).equals(other$host)) {
            return false;
        }
        ClusterReference this$cluster = this.getCluster();
        ClusterReference other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !((Object)this$cluster).equals(other$cluster)) {
            return false;
        }
        AvailabilityZoneReference this$availabilityZone = this.getAvailabilityZone();
        AvailabilityZoneReference other$availabilityZone = other.getAvailabilityZone();
        if (this$availabilityZone == null ? other$availabilityZone != null : !((Object)this$availabilityZone).equals(other$availabilityZone)) {
            return false;
        }
        GuestCustomizationParams this$guestCustomization = this.getGuestCustomization();
        GuestCustomizationParams other$guestCustomization = other.getGuestCustomization();
        if (this$guestCustomization == null ? other$guestCustomization != null : !((Object)this$guestCustomization).equals(other$guestCustomization)) {
            return false;
        }
        GuestTools this$guestTools = this.getGuestTools();
        GuestTools other$guestTools = other.getGuestTools();
        if (this$guestTools == null ? other$guestTools != null : !((Object)this$guestTools).equals(other$guestTools)) {
            return false;
        }
        String this$hardwareClockTimezone = this.getHardwareClockTimezone();
        String other$hardwareClockTimezone = other.getHardwareClockTimezone();
        if (this$hardwareClockTimezone == null ? other$hardwareClockTimezone != null : !this$hardwareClockTimezone.equals(other$hardwareClockTimezone)) {
            return false;
        }
        Boolean this$isBrandingEnabled = this.getIsBrandingEnabled();
        Boolean other$isBrandingEnabled = other.getIsBrandingEnabled();
        if (this$isBrandingEnabled == null ? other$isBrandingEnabled != null : !((Object)this$isBrandingEnabled).equals(other$isBrandingEnabled)) {
            return false;
        }
        Object this$bootConfig = this.getBootConfig();
        Object other$bootConfig = other.getBootConfig();
        if (this$bootConfig == null ? other$bootConfig != null : !this$bootConfig.equals(other$bootConfig)) {
            return false;
        }
        Boolean this$isVgaConsoleEnabled = this.getIsVgaConsoleEnabled();
        Boolean other$isVgaConsoleEnabled = other.getIsVgaConsoleEnabled();
        if (this$isVgaConsoleEnabled == null ? other$isVgaConsoleEnabled != null : !((Object)this$isVgaConsoleEnabled).equals(other$isVgaConsoleEnabled)) {
            return false;
        }
        MachineType this$machineType = this.getMachineType();
        MachineType other$machineType = other.getMachineType();
        if (this$machineType == null ? other$machineType != null : !((Object)((Object)this$machineType)).equals((Object)other$machineType)) {
            return false;
        }
        PowerState this$powerState = this.getPowerState();
        PowerState other$powerState = other.getPowerState();
        if (this$powerState == null ? other$powerState != null : !((Object)((Object)this$powerState)).equals((Object)other$powerState)) {
            return false;
        }
        VtpmConfig this$vtpmConfig = this.getVtpmConfig();
        VtpmConfig other$vtpmConfig = other.getVtpmConfig();
        if (this$vtpmConfig == null ? other$vtpmConfig != null : !((Object)this$vtpmConfig).equals(other$vtpmConfig)) {
            return false;
        }
        Boolean this$isAgentVm = this.getIsAgentVm();
        Boolean other$isAgentVm = other.getIsAgentVm();
        if (this$isAgentVm == null ? other$isAgentVm != null : !((Object)this$isAgentVm).equals(other$isAgentVm)) {
            return false;
        }
        ApcConfig this$apcConfig = this.getApcConfig();
        ApcConfig other$apcConfig = other.getApcConfig();
        if (this$apcConfig == null ? other$apcConfig != null : !((Object)this$apcConfig).equals(other$apcConfig)) {
            return false;
        }
        ADSFVmStorageConfig this$storageConfig = this.getStorageConfig();
        ADSFVmStorageConfig other$storageConfig = other.getStorageConfig();
        if (this$storageConfig == null ? other$storageConfig != null : !((Object)this$storageConfig).equals(other$storageConfig)) {
            return false;
        }
        List<Disk> this$disks = this.getDisks();
        List<Disk> other$disks = other.getDisks();
        if (this$disks == null ? other$disks != null : !((Object)this$disks).equals(other$disks)) {
            return false;
        }
        List<CdRom> this$cdRoms = this.getCdRoms();
        List<CdRom> other$cdRoms = other.getCdRoms();
        if (this$cdRoms == null ? other$cdRoms != null : !((Object)this$cdRoms).equals(other$cdRoms)) {
            return false;
        }
        List<Nic> this$nics = this.getNics();
        List<Nic> other$nics = other.getNics();
        if (this$nics == null ? other$nics != null : !((Object)this$nics).equals(other$nics)) {
            return false;
        }
        List<Gpu> this$gpus = this.getGpus();
        List<Gpu> other$gpus = other.getGpus();
        if (this$gpus == null ? other$gpus != null : !((Object)this$gpus).equals(other$gpus)) {
            return false;
        }
        List<SerialPort> this$serialPorts = this.getSerialPorts();
        List<SerialPort> other$serialPorts = other.getSerialPorts();
        if (this$serialPorts == null ? other$serialPorts != null : !((Object)this$serialPorts).equals(other$serialPorts)) {
            return false;
        }
        ProtectionType this$protectionType = this.getProtectionType();
        ProtectionType other$protectionType = other.getProtectionType();
        if (this$protectionType == null ? other$protectionType != null : !((Object)((Object)this$protectionType)).equals((Object)other$protectionType)) {
            return false;
        }
        ProtectionPolicyState this$protectionPolicyState = this.getProtectionPolicyState();
        ProtectionPolicyState other$protectionPolicyState = other.getProtectionPolicyState();
        if (this$protectionPolicyState == null ? other$protectionPolicyState != null : !((Object)this$protectionPolicyState).equals(other$protectionPolicyState)) {
            return false;
        }
        List<PcieDevice> this$pcieDevices = this.getPcieDevices();
        List<PcieDevice> other$pcieDevices = other.getPcieDevices();
        return !(this$pcieDevices == null ? other$pcieDevices != null : !((Object)this$pcieDevices).equals(other$pcieDevices));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Vm;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        OffsetDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Boolean $isLiveMigrateCapable = this.getIsLiveMigrateCapable();
        result = result * 59 + ($isLiveMigrateCapable == null ? 43 : ((Object)$isLiveMigrateCapable).hashCode());
        Boolean $isCrossClusterMigrationInProgress = this.getIsCrossClusterMigrationInProgress();
        result = result * 59 + ($isCrossClusterMigrationInProgress == null ? 43 : ((Object)$isCrossClusterMigrationInProgress).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        VmSourceReference $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Integer $numSockets = this.getNumSockets();
        result = result * 59 + ($numSockets == null ? 43 : ((Object)$numSockets).hashCode());
        Integer $numCoresPerSocket = this.getNumCoresPerSocket();
        result = result * 59 + ($numCoresPerSocket == null ? 43 : ((Object)$numCoresPerSocket).hashCode());
        Integer $numThreadsPerCore = this.getNumThreadsPerCore();
        result = result * 59 + ($numThreadsPerCore == null ? 43 : ((Object)$numThreadsPerCore).hashCode());
        Integer $numNumaNodes = this.getNumNumaNodes();
        result = result * 59 + ($numNumaNodes == null ? 43 : ((Object)$numNumaNodes).hashCode());
        Long $memorySizeBytes = this.getMemorySizeBytes();
        result = result * 59 + ($memorySizeBytes == null ? 43 : ((Object)$memorySizeBytes).hashCode());
        Boolean $isVcpuHardPinningEnabled = this.getIsVcpuHardPinningEnabled();
        result = result * 59 + ($isVcpuHardPinningEnabled == null ? 43 : ((Object)$isVcpuHardPinningEnabled).hashCode());
        Boolean $isCpuPassthroughEnabled = this.getIsCpuPassthroughEnabled();
        result = result * 59 + ($isCpuPassthroughEnabled == null ? 43 : ((Object)$isCpuPassthroughEnabled).hashCode());
        List<CpuFeature> $enabledCpuFeatures = this.getEnabledCpuFeatures();
        result = result * 59 + ($enabledCpuFeatures == null ? 43 : ((Object)$enabledCpuFeatures).hashCode());
        Boolean $isMemoryOvercommitEnabled = this.getIsMemoryOvercommitEnabled();
        result = result * 59 + ($isMemoryOvercommitEnabled == null ? 43 : ((Object)$isMemoryOvercommitEnabled).hashCode());
        Boolean $isGpuConsoleEnabled = this.getIsGpuConsoleEnabled();
        result = result * 59 + ($isGpuConsoleEnabled == null ? 43 : ((Object)$isGpuConsoleEnabled).hashCode());
        Boolean $isCpuHotplugEnabled = this.getIsCpuHotplugEnabled();
        result = result * 59 + ($isCpuHotplugEnabled == null ? 43 : ((Object)$isCpuHotplugEnabled).hashCode());
        Boolean $isScsiControllerEnabled = this.getIsScsiControllerEnabled();
        result = result * 59 + ($isScsiControllerEnabled == null ? 43 : ((Object)$isScsiControllerEnabled).hashCode());
        String $generationUuid = this.getGenerationUuid();
        result = result * 59 + ($generationUuid == null ? 43 : $generationUuid.hashCode());
        String $biosUuid = this.getBiosUuid();
        result = result * 59 + ($biosUuid == null ? 43 : $biosUuid.hashCode());
        List<CategoryReference> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        OwnershipInfo $ownershipInfo = this.getOwnershipInfo();
        result = result * 59 + ($ownershipInfo == null ? 43 : ((Object)$ownershipInfo).hashCode());
        HostReference $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : ((Object)$host).hashCode());
        ClusterReference $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : ((Object)$cluster).hashCode());
        AvailabilityZoneReference $availabilityZone = this.getAvailabilityZone();
        result = result * 59 + ($availabilityZone == null ? 43 : ((Object)$availabilityZone).hashCode());
        GuestCustomizationParams $guestCustomization = this.getGuestCustomization();
        result = result * 59 + ($guestCustomization == null ? 43 : ((Object)$guestCustomization).hashCode());
        GuestTools $guestTools = this.getGuestTools();
        result = result * 59 + ($guestTools == null ? 43 : ((Object)$guestTools).hashCode());
        String $hardwareClockTimezone = this.getHardwareClockTimezone();
        result = result * 59 + ($hardwareClockTimezone == null ? 43 : $hardwareClockTimezone.hashCode());
        Boolean $isBrandingEnabled = this.getIsBrandingEnabled();
        result = result * 59 + ($isBrandingEnabled == null ? 43 : ((Object)$isBrandingEnabled).hashCode());
        Object $bootConfig = this.getBootConfig();
        result = result * 59 + ($bootConfig == null ? 43 : $bootConfig.hashCode());
        Boolean $isVgaConsoleEnabled = this.getIsVgaConsoleEnabled();
        result = result * 59 + ($isVgaConsoleEnabled == null ? 43 : ((Object)$isVgaConsoleEnabled).hashCode());
        MachineType $machineType = this.getMachineType();
        result = result * 59 + ($machineType == null ? 43 : ((Object)((Object)$machineType)).hashCode());
        PowerState $powerState = this.getPowerState();
        result = result * 59 + ($powerState == null ? 43 : ((Object)((Object)$powerState)).hashCode());
        VtpmConfig $vtpmConfig = this.getVtpmConfig();
        result = result * 59 + ($vtpmConfig == null ? 43 : ((Object)$vtpmConfig).hashCode());
        Boolean $isAgentVm = this.getIsAgentVm();
        result = result * 59 + ($isAgentVm == null ? 43 : ((Object)$isAgentVm).hashCode());
        ApcConfig $apcConfig = this.getApcConfig();
        result = result * 59 + ($apcConfig == null ? 43 : ((Object)$apcConfig).hashCode());
        ADSFVmStorageConfig $storageConfig = this.getStorageConfig();
        result = result * 59 + ($storageConfig == null ? 43 : ((Object)$storageConfig).hashCode());
        List<Disk> $disks = this.getDisks();
        result = result * 59 + ($disks == null ? 43 : ((Object)$disks).hashCode());
        List<CdRom> $cdRoms = this.getCdRoms();
        result = result * 59 + ($cdRoms == null ? 43 : ((Object)$cdRoms).hashCode());
        List<Nic> $nics = this.getNics();
        result = result * 59 + ($nics == null ? 43 : ((Object)$nics).hashCode());
        List<Gpu> $gpus = this.getGpus();
        result = result * 59 + ($gpus == null ? 43 : ((Object)$gpus).hashCode());
        List<SerialPort> $serialPorts = this.getSerialPorts();
        result = result * 59 + ($serialPorts == null ? 43 : ((Object)$serialPorts).hashCode());
        ProtectionType $protectionType = this.getProtectionType();
        result = result * 59 + ($protectionType == null ? 43 : ((Object)((Object)$protectionType)).hashCode());
        ProtectionPolicyState $protectionPolicyState = this.getProtectionPolicyState();
        result = result * 59 + ($protectionPolicyState == null ? 43 : ((Object)$protectionPolicyState).hashCode());
        List<PcieDevice> $pcieDevices = this.getPcieDevices();
        result = result * 59 + ($pcieDevices == null ? 43 : ((Object)$pcieDevices).hashCode());
        return result;
    }

    public OffsetDateTime getCreateTime() {
        return this.createTime;
    }

    public OffsetDateTime getUpdateTime() {
        return this.updateTime;
    }

    public Boolean getIsLiveMigrateCapable() {
        return this.isLiveMigrateCapable;
    }

    public Boolean getIsCrossClusterMigrationInProgress() {
        return this.isCrossClusterMigrationInProgress;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public VmSourceReference getSource() {
        return this.source;
    }

    public Integer getNumSockets() {
        return this.numSockets;
    }

    public Integer getNumCoresPerSocket() {
        return this.numCoresPerSocket;
    }

    public Integer getNumThreadsPerCore() {
        return this.numThreadsPerCore;
    }

    public Integer getNumNumaNodes() {
        return this.numNumaNodes;
    }

    public Long getMemorySizeBytes() {
        return this.memorySizeBytes;
    }

    public Boolean getIsVcpuHardPinningEnabled() {
        return this.isVcpuHardPinningEnabled;
    }

    public Boolean getIsCpuPassthroughEnabled() {
        return this.isCpuPassthroughEnabled;
    }

    public List<CpuFeature> getEnabledCpuFeatures() {
        return this.enabledCpuFeatures;
    }

    public Boolean getIsMemoryOvercommitEnabled() {
        return this.isMemoryOvercommitEnabled;
    }

    public Boolean getIsGpuConsoleEnabled() {
        return this.isGpuConsoleEnabled;
    }

    public Boolean getIsCpuHotplugEnabled() {
        return this.isCpuHotplugEnabled;
    }

    public Boolean getIsScsiControllerEnabled() {
        return this.isScsiControllerEnabled;
    }

    public String getGenerationUuid() {
        return this.generationUuid;
    }

    public String getBiosUuid() {
        return this.biosUuid;
    }

    public List<CategoryReference> getCategories() {
        return this.categories;
    }

    public OwnershipInfo getOwnershipInfo() {
        return this.ownershipInfo;
    }

    public HostReference getHost() {
        return this.host;
    }

    public ClusterReference getCluster() {
        return this.cluster;
    }

    public AvailabilityZoneReference getAvailabilityZone() {
        return this.availabilityZone;
    }

    public GuestCustomizationParams getGuestCustomization() {
        return this.guestCustomization;
    }

    public GuestTools getGuestTools() {
        return this.guestTools;
    }

    public String getHardwareClockTimezone() {
        return this.hardwareClockTimezone;
    }

    public Boolean getIsBrandingEnabled() {
        return this.isBrandingEnabled;
    }

    public Boolean getIsVgaConsoleEnabled() {
        return this.isVgaConsoleEnabled;
    }

    public MachineType getMachineType() {
        return this.machineType;
    }

    public PowerState getPowerState() {
        return this.powerState;
    }

    public VtpmConfig getVtpmConfig() {
        return this.vtpmConfig;
    }

    public Boolean getIsAgentVm() {
        return this.isAgentVm;
    }

    public ApcConfig getApcConfig() {
        return this.apcConfig;
    }

    public ADSFVmStorageConfig getStorageConfig() {
        return this.storageConfig;
    }

    public List<Disk> getDisks() {
        return this.disks;
    }

    public List<CdRom> getCdRoms() {
        return this.cdRoms;
    }

    public List<Nic> getNics() {
        return this.nics;
    }

    public List<Gpu> getGpus() {
        return this.gpus;
    }

    public List<SerialPort> getSerialPorts() {
        return this.serialPorts;
    }

    public ProtectionType getProtectionType() {
        return this.protectionType;
    }

    public ProtectionPolicyState getProtectionPolicyState() {
        return this.protectionPolicyState;
    }

    public List<PcieDevice> getPcieDevices() {
        return this.pcieDevices;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="source")
    public void setSource(VmSourceReference source) {
        this.source = source;
    }

    @JsonProperty(value="numSockets")
    public void setNumSockets(Integer numSockets) {
        this.numSockets = numSockets;
    }

    @JsonProperty(value="numCoresPerSocket")
    public void setNumCoresPerSocket(Integer numCoresPerSocket) {
        this.numCoresPerSocket = numCoresPerSocket;
    }

    @JsonProperty(value="numThreadsPerCore")
    public void setNumThreadsPerCore(Integer numThreadsPerCore) {
        this.numThreadsPerCore = numThreadsPerCore;
    }

    @JsonProperty(value="numNumaNodes")
    public void setNumNumaNodes(Integer numNumaNodes) {
        this.numNumaNodes = numNumaNodes;
    }

    @JsonProperty(value="memorySizeBytes")
    public void setMemorySizeBytes(Long memorySizeBytes) {
        this.memorySizeBytes = memorySizeBytes;
    }

    @JsonProperty(value="isVcpuHardPinningEnabled")
    public void setIsVcpuHardPinningEnabled(Boolean isVcpuHardPinningEnabled) {
        this.isVcpuHardPinningEnabled = isVcpuHardPinningEnabled;
    }

    @JsonProperty(value="isCpuPassthroughEnabled")
    public void setIsCpuPassthroughEnabled(Boolean isCpuPassthroughEnabled) {
        this.isCpuPassthroughEnabled = isCpuPassthroughEnabled;
    }

    @JsonProperty(value="enabledCpuFeatures")
    public void setEnabledCpuFeatures(List<CpuFeature> enabledCpuFeatures) {
        this.enabledCpuFeatures = enabledCpuFeatures;
    }

    @JsonProperty(value="isMemoryOvercommitEnabled")
    public void setIsMemoryOvercommitEnabled(Boolean isMemoryOvercommitEnabled) {
        this.isMemoryOvercommitEnabled = isMemoryOvercommitEnabled;
    }

    @JsonProperty(value="isGpuConsoleEnabled")
    public void setIsGpuConsoleEnabled(Boolean isGpuConsoleEnabled) {
        this.isGpuConsoleEnabled = isGpuConsoleEnabled;
    }

    @JsonProperty(value="isCpuHotplugEnabled")
    public void setIsCpuHotplugEnabled(Boolean isCpuHotplugEnabled) {
        this.isCpuHotplugEnabled = isCpuHotplugEnabled;
    }

    @JsonProperty(value="isScsiControllerEnabled")
    public void setIsScsiControllerEnabled(Boolean isScsiControllerEnabled) {
        this.isScsiControllerEnabled = isScsiControllerEnabled;
    }

    @JsonProperty(value="generationUuid")
    public void setGenerationUuid(String generationUuid) {
        this.generationUuid = generationUuid;
    }

    @JsonProperty(value="biosUuid")
    public void setBiosUuid(String biosUuid) {
        this.biosUuid = biosUuid;
    }

    @JsonProperty(value="categories")
    public void setCategories(List<CategoryReference> categories) {
        this.categories = categories;
    }

    @JsonProperty(value="ownershipInfo")
    public void setOwnershipInfo(OwnershipInfo ownershipInfo) {
        this.ownershipInfo = ownershipInfo;
    }

    @JsonProperty(value="host")
    public void setHost(HostReference host) {
        this.host = host;
    }

    @JsonProperty(value="cluster")
    public void setCluster(ClusterReference cluster) {
        this.cluster = cluster;
    }

    @JsonProperty(value="availabilityZone")
    public void setAvailabilityZone(AvailabilityZoneReference availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    @JsonProperty(value="guestCustomization")
    public void setGuestCustomization(GuestCustomizationParams guestCustomization) {
        this.guestCustomization = guestCustomization;
    }

    @JsonProperty(value="guestTools")
    public void setGuestTools(GuestTools guestTools) {
        this.guestTools = guestTools;
    }

    @JsonProperty(value="hardwareClockTimezone")
    public void setHardwareClockTimezone(String hardwareClockTimezone) {
        this.hardwareClockTimezone = hardwareClockTimezone;
    }

    @JsonProperty(value="isBrandingEnabled")
    public void setIsBrandingEnabled(Boolean isBrandingEnabled) {
        this.isBrandingEnabled = isBrandingEnabled;
    }

    public void setBootConfig(OneOfBootConfigWrapper bootConfig) {
        this.bootConfig = bootConfig;
    }

    @JsonProperty(value="isVgaConsoleEnabled")
    public void setIsVgaConsoleEnabled(Boolean isVgaConsoleEnabled) {
        this.isVgaConsoleEnabled = isVgaConsoleEnabled;
    }

    @JsonProperty(value="machineType")
    public void setMachineType(MachineType machineType) {
        this.machineType = machineType;
    }

    @JsonProperty(value="powerState")
    public void setPowerState(PowerState powerState) {
        this.powerState = powerState;
    }

    @JsonProperty(value="vtpmConfig")
    public void setVtpmConfig(VtpmConfig vtpmConfig) {
        this.vtpmConfig = vtpmConfig;
    }

    @JsonProperty(value="isAgentVm")
    public void setIsAgentVm(Boolean isAgentVm) {
        this.isAgentVm = isAgentVm;
    }

    @JsonProperty(value="apcConfig")
    public void setApcConfig(ApcConfig apcConfig) {
        this.apcConfig = apcConfig;
    }

    @JsonProperty(value="storageConfig")
    public void setStorageConfig(ADSFVmStorageConfig storageConfig) {
        this.storageConfig = storageConfig;
    }

    @JsonProperty(value="disks")
    public void setDisks(List<Disk> disks) {
        this.disks = disks;
    }

    @JsonProperty(value="cdRoms")
    public void setCdRoms(List<CdRom> cdRoms) {
        this.cdRoms = cdRoms;
    }

    @JsonProperty(value="nics")
    public void setNics(List<Nic> nics) {
        this.nics = nics;
    }

    @JsonProperty(value="gpus")
    public void setGpus(List<Gpu> gpus) {
        this.gpus = gpus;
    }

    @JsonProperty(value="serialPorts")
    public void setSerialPorts(List<SerialPort> serialPorts) {
        this.serialPorts = serialPorts;
    }

    @JsonProperty(value="protectionType")
    public void setProtectionType(ProtectionType protectionType) {
        this.protectionType = protectionType;
    }

    @JsonProperty(value="protectionPolicyState")
    public void setProtectionPolicyState(ProtectionPolicyState protectionPolicyState) {
        this.protectionPolicyState = protectionPolicyState;
    }

    @JsonProperty(value="pcieDevices")
    public void setPcieDevices(List<PcieDevice> pcieDevices) {
        this.pcieDevices = pcieDevices;
    }

    @Override
    public String toString() {
        return "Vm(createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", isLiveMigrateCapable=" + this.getIsLiveMigrateCapable() + ", isCrossClusterMigrationInProgress=" + this.getIsCrossClusterMigrationInProgress() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", source=" + this.getSource() + ", numSockets=" + this.getNumSockets() + ", numCoresPerSocket=" + this.getNumCoresPerSocket() + ", numThreadsPerCore=" + this.getNumThreadsPerCore() + ", numNumaNodes=" + this.getNumNumaNodes() + ", memorySizeBytes=" + this.getMemorySizeBytes() + ", isVcpuHardPinningEnabled=" + this.getIsVcpuHardPinningEnabled() + ", isCpuPassthroughEnabled=" + this.getIsCpuPassthroughEnabled() + ", enabledCpuFeatures=" + this.getEnabledCpuFeatures() + ", isMemoryOvercommitEnabled=" + this.getIsMemoryOvercommitEnabled() + ", isGpuConsoleEnabled=" + this.getIsGpuConsoleEnabled() + ", isCpuHotplugEnabled=" + this.getIsCpuHotplugEnabled() + ", isScsiControllerEnabled=" + this.getIsScsiControllerEnabled() + ", generationUuid=" + this.getGenerationUuid() + ", biosUuid=" + this.getBiosUuid() + ", categories=" + this.getCategories() + ", ownershipInfo=" + this.getOwnershipInfo() + ", host=" + this.getHost() + ", cluster=" + this.getCluster() + ", availabilityZone=" + this.getAvailabilityZone() + ", guestCustomization=" + this.getGuestCustomization() + ", guestTools=" + this.getGuestTools() + ", hardwareClockTimezone=" + this.getHardwareClockTimezone() + ", isBrandingEnabled=" + this.getIsBrandingEnabled() + ", bootConfig=" + this.getBootConfig() + ", isVgaConsoleEnabled=" + this.getIsVgaConsoleEnabled() + ", machineType=" + (Object)((Object)this.getMachineType()) + ", powerState=" + (Object)((Object)this.getPowerState()) + ", vtpmConfig=" + this.getVtpmConfig() + ", isAgentVm=" + this.getIsAgentVm() + ", apcConfig=" + this.getApcConfig() + ", storageConfig=" + this.getStorageConfig() + ", disks=" + this.getDisks() + ", cdRoms=" + this.getCdRoms() + ", nics=" + this.getNics() + ", gpus=" + this.getGpus() + ", serialPorts=" + this.getSerialPorts() + ", protectionType=" + (Object)((Object)this.getProtectionType()) + ", protectionPolicyState=" + this.getProtectionPolicyState() + ", pcieDevices=" + this.getPcieDevices() + ")";
    }

    public static class VmBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private OffsetDateTime createTime;
        private OffsetDateTime updateTime;
        private VmSourceReference source;
        private Integer numSockets;
        private Integer numCoresPerSocket;
        private Integer numThreadsPerCore;
        private Integer numNumaNodes;
        private Long memorySizeBytes;
        private Boolean isVcpuHardPinningEnabled;
        private Boolean isCpuPassthroughEnabled;
        private List<CpuFeature> enabledCpuFeatures;
        private Boolean isMemoryOvercommitEnabled;
        private Boolean isGpuConsoleEnabled;
        private Boolean isCpuHotplugEnabled;
        private Boolean isScsiControllerEnabled;
        private String generationUuid;
        private String biosUuid;
        private List<CategoryReference> categories;
        private OwnershipInfo ownershipInfo;
        private HostReference host;
        private ClusterReference cluster;
        private AvailabilityZoneReference availabilityZone;
        private GuestCustomizationParams guestCustomization;
        private GuestTools guestTools;
        private String hardwareClockTimezone;
        private Boolean isBrandingEnabled;
        private Object bootConfig;
        private Boolean isVgaConsoleEnabled;
        private MachineType machineType;
        private PowerState powerState;
        private VtpmConfig vtpmConfig;
        private Boolean isAgentVm;
        private ApcConfig apcConfig;
        private Boolean isLiveMigrateCapable;
        private Boolean isCrossClusterMigrationInProgress;
        private ADSFVmStorageConfig storageConfig;
        private List<Disk> disks;
        private List<CdRom> cdRoms;
        private List<Nic> nics;
        private List<Gpu> gpus;
        private List<SerialPort> serialPorts;
        private ProtectionType protectionType;
        private ProtectionPolicyState protectionPolicyState;
        private List<PcieDevice> pcieDevices;

        VmBuilder() {
        }

        public VmBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public VmBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public VmBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public VmBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VmBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VmBuilder createTime(OffsetDateTime createTime) {
            this.createTime = createTime;
            return this;
        }

        public VmBuilder updateTime(OffsetDateTime updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public VmBuilder source(VmSourceReference source) {
            this.source = source;
            return this;
        }

        public VmBuilder numSockets(Integer numSockets) {
            this.numSockets = numSockets;
            return this;
        }

        public VmBuilder numCoresPerSocket(Integer numCoresPerSocket) {
            this.numCoresPerSocket = numCoresPerSocket;
            return this;
        }

        public VmBuilder numThreadsPerCore(Integer numThreadsPerCore) {
            this.numThreadsPerCore = numThreadsPerCore;
            return this;
        }

        public VmBuilder numNumaNodes(Integer numNumaNodes) {
            this.numNumaNodes = numNumaNodes;
            return this;
        }

        public VmBuilder memorySizeBytes(Long memorySizeBytes) {
            this.memorySizeBytes = memorySizeBytes;
            return this;
        }

        public VmBuilder isVcpuHardPinningEnabled(Boolean isVcpuHardPinningEnabled) {
            this.isVcpuHardPinningEnabled = isVcpuHardPinningEnabled;
            return this;
        }

        public VmBuilder isCpuPassthroughEnabled(Boolean isCpuPassthroughEnabled) {
            this.isCpuPassthroughEnabled = isCpuPassthroughEnabled;
            return this;
        }

        public VmBuilder enabledCpuFeatures(List<CpuFeature> enabledCpuFeatures) {
            this.enabledCpuFeatures = enabledCpuFeatures;
            return this;
        }

        public VmBuilder isMemoryOvercommitEnabled(Boolean isMemoryOvercommitEnabled) {
            this.isMemoryOvercommitEnabled = isMemoryOvercommitEnabled;
            return this;
        }

        public VmBuilder isGpuConsoleEnabled(Boolean isGpuConsoleEnabled) {
            this.isGpuConsoleEnabled = isGpuConsoleEnabled;
            return this;
        }

        public VmBuilder isCpuHotplugEnabled(Boolean isCpuHotplugEnabled) {
            this.isCpuHotplugEnabled = isCpuHotplugEnabled;
            return this;
        }

        public VmBuilder isScsiControllerEnabled(Boolean isScsiControllerEnabled) {
            this.isScsiControllerEnabled = isScsiControllerEnabled;
            return this;
        }

        public VmBuilder generationUuid(String generationUuid) {
            this.generationUuid = generationUuid;
            return this;
        }

        public VmBuilder biosUuid(String biosUuid) {
            this.biosUuid = biosUuid;
            return this;
        }

        public VmBuilder categories(List<CategoryReference> categories) {
            this.categories = categories;
            return this;
        }

        public VmBuilder ownershipInfo(OwnershipInfo ownershipInfo) {
            this.ownershipInfo = ownershipInfo;
            return this;
        }

        public VmBuilder host(HostReference host) {
            this.host = host;
            return this;
        }

        public VmBuilder cluster(ClusterReference cluster) {
            this.cluster = cluster;
            return this;
        }

        public VmBuilder availabilityZone(AvailabilityZoneReference availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public VmBuilder guestCustomization(GuestCustomizationParams guestCustomization) {
            this.guestCustomization = guestCustomization;
            return this;
        }

        public VmBuilder guestTools(GuestTools guestTools) {
            this.guestTools = guestTools;
            return this;
        }

        public VmBuilder hardwareClockTimezone(String hardwareClockTimezone) {
            this.hardwareClockTimezone = hardwareClockTimezone;
            return this;
        }

        public VmBuilder isBrandingEnabled(Boolean isBrandingEnabled) {
            this.isBrandingEnabled = isBrandingEnabled;
            return this;
        }

        public VmBuilder bootConfig(Object bootConfig) {
            this.bootConfig = bootConfig;
            return this;
        }

        public VmBuilder isVgaConsoleEnabled(Boolean isVgaConsoleEnabled) {
            this.isVgaConsoleEnabled = isVgaConsoleEnabled;
            return this;
        }

        public VmBuilder machineType(MachineType machineType) {
            this.machineType = machineType;
            return this;
        }

        public VmBuilder powerState(PowerState powerState) {
            this.powerState = powerState;
            return this;
        }

        public VmBuilder vtpmConfig(VtpmConfig vtpmConfig) {
            this.vtpmConfig = vtpmConfig;
            return this;
        }

        public VmBuilder isAgentVm(Boolean isAgentVm) {
            this.isAgentVm = isAgentVm;
            return this;
        }

        public VmBuilder apcConfig(ApcConfig apcConfig) {
            this.apcConfig = apcConfig;
            return this;
        }

        public VmBuilder isLiveMigrateCapable(Boolean isLiveMigrateCapable) {
            this.isLiveMigrateCapable = isLiveMigrateCapable;
            return this;
        }

        public VmBuilder isCrossClusterMigrationInProgress(Boolean isCrossClusterMigrationInProgress) {
            this.isCrossClusterMigrationInProgress = isCrossClusterMigrationInProgress;
            return this;
        }

        public VmBuilder storageConfig(ADSFVmStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public VmBuilder disks(List<Disk> disks) {
            this.disks = disks;
            return this;
        }

        public VmBuilder cdRoms(List<CdRom> cdRoms) {
            this.cdRoms = cdRoms;
            return this;
        }

        public VmBuilder nics(List<Nic> nics) {
            this.nics = nics;
            return this;
        }

        public VmBuilder gpus(List<Gpu> gpus) {
            this.gpus = gpus;
            return this;
        }

        public VmBuilder serialPorts(List<SerialPort> serialPorts) {
            this.serialPorts = serialPorts;
            return this;
        }

        public VmBuilder protectionType(ProtectionType protectionType) {
            this.protectionType = protectionType;
            return this;
        }

        public VmBuilder protectionPolicyState(ProtectionPolicyState protectionPolicyState) {
            this.protectionPolicyState = protectionPolicyState;
            return this;
        }

        public VmBuilder pcieDevices(List<PcieDevice> pcieDevices) {
            this.pcieDevices = pcieDevices;
            return this;
        }

        public Vm build() {
            return new Vm(this.tenantId, this.extId, this.links, this.name, this.description, this.createTime, this.updateTime, this.source, this.numSockets, this.numCoresPerSocket, this.numThreadsPerCore, this.numNumaNodes, this.memorySizeBytes, this.isVcpuHardPinningEnabled, this.isCpuPassthroughEnabled, this.enabledCpuFeatures, this.isMemoryOvercommitEnabled, this.isGpuConsoleEnabled, this.isCpuHotplugEnabled, this.isScsiControllerEnabled, this.generationUuid, this.biosUuid, this.categories, this.ownershipInfo, this.host, this.cluster, this.availabilityZone, this.guestCustomization, this.guestTools, this.hardwareClockTimezone, this.isBrandingEnabled, this.bootConfig, this.isVgaConsoleEnabled, this.machineType, this.powerState, this.vtpmConfig, this.isAgentVm, this.apcConfig, this.isLiveMigrateCapable, this.isCrossClusterMigrationInProgress, this.storageConfig, this.disks, this.cdRoms, this.nics, this.gpus, this.serialPorts, this.protectionType, this.protectionPolicyState, this.pcieDevices);
        }

        public String toString() {
            return "Vm.VmBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + ", source=" + this.source + ", numSockets=" + this.numSockets + ", numCoresPerSocket=" + this.numCoresPerSocket + ", numThreadsPerCore=" + this.numThreadsPerCore + ", numNumaNodes=" + this.numNumaNodes + ", memorySizeBytes=" + this.memorySizeBytes + ", isVcpuHardPinningEnabled=" + this.isVcpuHardPinningEnabled + ", isCpuPassthroughEnabled=" + this.isCpuPassthroughEnabled + ", enabledCpuFeatures=" + this.enabledCpuFeatures + ", isMemoryOvercommitEnabled=" + this.isMemoryOvercommitEnabled + ", isGpuConsoleEnabled=" + this.isGpuConsoleEnabled + ", isCpuHotplugEnabled=" + this.isCpuHotplugEnabled + ", isScsiControllerEnabled=" + this.isScsiControllerEnabled + ", generationUuid=" + this.generationUuid + ", biosUuid=" + this.biosUuid + ", categories=" + this.categories + ", ownershipInfo=" + this.ownershipInfo + ", host=" + this.host + ", cluster=" + this.cluster + ", availabilityZone=" + this.availabilityZone + ", guestCustomization=" + this.guestCustomization + ", guestTools=" + this.guestTools + ", hardwareClockTimezone=" + this.hardwareClockTimezone + ", isBrandingEnabled=" + this.isBrandingEnabled + ", bootConfig=" + this.bootConfig + ", isVgaConsoleEnabled=" + this.isVgaConsoleEnabled + ", machineType=" + (Object)((Object)this.machineType) + ", powerState=" + (Object)((Object)this.powerState) + ", vtpmConfig=" + this.vtpmConfig + ", isAgentVm=" + this.isAgentVm + ", apcConfig=" + this.apcConfig + ", isLiveMigrateCapable=" + this.isLiveMigrateCapable + ", isCrossClusterMigrationInProgress=" + this.isCrossClusterMigrationInProgress + ", storageConfig=" + this.storageConfig + ", disks=" + this.disks + ", cdRoms=" + this.cdRoms + ", nics=" + this.nics + ", gpus=" + this.gpus + ", serialPorts=" + this.serialPorts + ", protectionType=" + (Object)((Object)this.protectionType) + ", protectionPolicyState=" + this.protectionPolicyState + ", pcieDevices=" + this.pcieDevices + ")";
        }
    }

    @JsonDeserialize(using=OneOfBootConfigWrapperJsonDeserializer.class)
    public static class OneOfBootConfigWrapper {
        @JsonIgnore
        private LegacyBoot oneOfType2001;
        @JsonIgnore
        private UefiBoot oneOfType2002;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfBootConfigWrapper() {
        }

        public OneOfBootConfigWrapper(LegacyBoot data) {
            this.oneOfType2001 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfBootConfigWrapper(UefiBoot data) {
            this.oneOfType2002 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType2001 != null && this.oneOfType2001.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2001;
            }
            if (this.oneOfType2002 != null && this.oneOfType2002.get$objectType().equals(this.discriminator)) {
                return this.oneOfType2002;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof LegacyBoot) {
                this.oneOfType2001 = (LegacyBoot)value;
                this.discriminator = this.oneOfType2001.get$objectType();
                this.$objectType = this.oneOfType2001.get$objectType();
                return;
            }
            if (value instanceof UefiBoot) {
                this.oneOfType2002 = (UefiBoot)value;
                this.discriminator = this.oneOfType2002.get$objectType();
                this.$objectType = this.oneOfType2002.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfBootConfigWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfBootConfigWrapper)) {
                return false;
            }
            OneOfBootConfigWrapper other = (OneOfBootConfigWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LegacyBoot this$oneOfType2001 = this.oneOfType2001;
            LegacyBoot other$oneOfType2001 = other.oneOfType2001;
            if (this$oneOfType2001 == null ? other$oneOfType2001 != null : !((Object)this$oneOfType2001).equals(other$oneOfType2001)) {
                return false;
            }
            UefiBoot this$oneOfType2002 = this.oneOfType2002;
            UefiBoot other$oneOfType2002 = other.oneOfType2002;
            if (this$oneOfType2002 == null ? other$oneOfType2002 != null : !((Object)this$oneOfType2002).equals(other$oneOfType2002)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfBootConfigWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LegacyBoot $oneOfType2001 = this.oneOfType2001;
            result = result * 59 + ($oneOfType2001 == null ? 43 : ((Object)$oneOfType2001).hashCode());
            UefiBoot $oneOfType2002 = this.oneOfType2002;
            result = result * 59 + ($oneOfType2002 == null ? 43 : ((Object)$oneOfType2002).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Vm.OneOfBootConfigWrapper(oneOfType2001=" + this.oneOfType2001 + ", oneOfType2002=" + this.oneOfType2002 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @VmmJsonDeserializer
        private static class OneOfBootConfigWrapperJsonDeserializer
        extends VmmOneOfDeserializer<OneOfBootConfigWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE2001 = TYPE_FACTORY.constructType(LegacyBoot.class);
            private static final JavaType ONE_OF_TYPE2002 = TYPE_FACTORY.constructType(UefiBoot.class);

            public OneOfBootConfigWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfBootConfigWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfBootConfigWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfBootConfigWrapper provided is null");
                }
                if (ONE_OF_TYPE2001.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE2002.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfBootConfigWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.vmm";
            }
        }
    }
}

