/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.vmm.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.nutanix.dp1.vmm.deserializers.VmmDeserializerUtils;
import com.nutanix.dp1.vmm.deserializers.VmmObjectTypeTypedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmmObjectTypeTypedObjectDeserializer
extends StdDeserializer<VmmObjectTypeTypedObject> {
    private static final Logger log = LoggerFactory.getLogger(VmmObjectTypeTypedObjectDeserializer.class);
    private final String packagePrefix = "com.nutanix.dp1.vmm";

    public VmmObjectTypeTypedObjectDeserializer() {
        super(VmmObjectTypeTypedObject.class);
    }

    public VmmObjectTypeTypedObject deserialize(JsonParser p, DeserializationContext ctxt) {
        ObjectCodec codec = p.getCodec();
        JsonNode targetNode = (JsonNode)codec.readTree(p);
        Class<?> clazz = VmmDeserializerUtils.getObjectTypedType(targetNode, this.packagePrefix);
        log.debug("Deserializing json node into instance of {}", clazz);
        return (VmmObjectTypeTypedObject)VmmDeserializerUtils.readValue(codec, targetNode, clazz);
    }
}

