/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.iam.java.client.api;

import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.iam.v4.authn.CertRevocationInfo;
import com.nutanix.dp1.iam.iam.v4.authn.CreateCertAuthProviderApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.DeleteCertAuthProviderApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.GetCertAuthProviderApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.ListCertAuthProvidersApiResponse;
import com.nutanix.dp1.iam.iam.v4.authn.UpdateCertAuthProviderApiResponse;
import com.nutanix.iam.java.client.ApiClient;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="com.nutanix.iam.java.client.api.CertificateAuthenticationProvidersApi")
public class CertificateAuthenticationProvidersApi {
    private static final Logger log = LoggerFactory.getLogger(CertificateAuthenticationProvidersApi.class);
    private ApiClient apiClient;
    private final Set<String> headersToSkip;

    public CertificateAuthenticationProvidersApi() {
        this(new ApiClient());
    }

    @Autowired
    public CertificateAuthenticationProvidersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.headersToSkip = new HashSet<String>(Arrays.asList("authorization", "cookie", "host", "user-agent"));
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateCertAuthProviderApiResponse createCertAuthProvider(String clientCaChain, String dirSvcExtID, String caCertFileName, Boolean isCertAuthEnabled, String name, Boolean isCacEnabled, CertRevocationInfo certRevocationInfo, String createdBy, String tenantId, OffsetDateTime createdTime, List<ApiLink> links, OffsetDateTime lastUpdatedTime, String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (clientCaChain == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'clientCaChain' when calling createCertAuthProvider");
        }
        if (dirSvcExtID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'dirSvcExtID' when calling createCertAuthProvider");
        }
        if (caCertFileName == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'caCertFileName' when calling createCertAuthProvider");
        }
        if (isCertAuthEnabled == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'isCertAuthEnabled' when calling createCertAuthProvider");
        }
        if (name == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'name' when calling createCertAuthProvider");
        }
        if (isCacEnabled == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'isCacEnabled' when calling createCertAuthProvider");
        }
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/cert-auth-providers").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        if (clientCaChain != null) {
            formParams.add((Object)"clientCaChain", (Object)clientCaChain);
        }
        if (dirSvcExtID != null) {
            formParams.add((Object)"dirSvcExtID", (Object)dirSvcExtID);
        }
        if (certRevocationInfo != null) {
            formParams.add((Object)"certRevocationInfo", (Object)certRevocationInfo);
        }
        if (caCertFileName != null) {
            formParams.add((Object)"caCertFileName", (Object)caCertFileName);
        }
        if (isCertAuthEnabled != null) {
            formParams.add((Object)"isCertAuthEnabled", (Object)isCertAuthEnabled);
        }
        if (createdBy != null) {
            formParams.add((Object)"createdBy", (Object)createdBy);
        }
        if (tenantId != null) {
            formParams.add((Object)"tenantId", (Object)tenantId);
        }
        if (name != null) {
            formParams.add((Object)"name", (Object)name);
        }
        if (createdTime != null) {
            formParams.add((Object)"createdTime", (Object)createdTime);
        }
        if (links != null) {
            formParams.add((Object)"links", links);
        }
        if (isCacEnabled != null) {
            formParams.add((Object)"isCacEnabled", (Object)isCacEnabled);
        }
        if (lastUpdatedTime != null) {
            formParams.add((Object)"lastUpdatedTime", (Object)lastUpdatedTime);
        }
        if (extId != null) {
            formParams.add((Object)"extId", (Object)extId);
        }
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<CreateCertAuthProviderApiResponse> returnType = new ParameterizedTypeReference<CreateCertAuthProviderApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.POST, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public DeleteCertAuthProviderApiResponse deleteCertAuthProviderById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling deleteCertAuthProviderById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/cert-auth-providers/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<DeleteCertAuthProviderApiResponse> returnType = new ParameterizedTypeReference<DeleteCertAuthProviderApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.DELETE, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public GetCertAuthProviderApiResponse getCertAuthProviderById(String extId, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling getCertAuthProviderById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/cert-auth-providers/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<GetCertAuthProviderApiResponse> returnType = new ParameterizedTypeReference<GetCertAuthProviderApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public ListCertAuthProvidersApiResponse listCertAuthProviders(Integer $page, Integer $limit, String $filter, String $orderby, String $select, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/cert-auth-providers").build().toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$page", $page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$filter", $filter));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$orderby", $orderby));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$select", $select));
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<ListCertAuthProvidersApiResponse> returnType = new ParameterizedTypeReference<ListCertAuthProvidersApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.GET, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }

    public UpdateCertAuthProviderApiResponse updateCertAuthProviderById(String extId, String clientCaChain, String dirSvcExtID, CertRevocationInfo certRevocationInfo, String caCertFileName, Boolean isCertAuthEnabled, String createdBy, String tenantId, String name, OffsetDateTime createdTime, List<ApiLink> links, Boolean isCacEnabled, OffsetDateTime lastUpdatedTime, String extId2, Map<String, Object> ... args) throws RestClientException {
        Map<Object, Object> argMap = args.length > 0 ? args[0] : new HashMap();
        Object postBody = null;
        if (extId == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'extId' when calling updateCertAuthProviderById");
        }
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        uriVariables.put("extId", extId);
        String uriPath = UriComponentsBuilder.fromPath((String)"/api/iam/v4.0/authn/cert-auth-providers/{extId}").buildAndExpand(uriVariables).toUriString();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        argMap.forEach((key, value) -> {
            String stringValue;
            if (!this.headersToSkip.contains(key.toLowerCase()) && (stringValue = this.apiClient.parameterToString(value)) != null && !stringValue.trim().isEmpty()) {
                headerParams.add(key, this.apiClient.parameterToString(value));
            }
        });
        if (clientCaChain != null) {
            formParams.add((Object)"clientCaChain", (Object)clientCaChain);
        }
        if (dirSvcExtID != null) {
            formParams.add((Object)"dirSvcExtID", (Object)dirSvcExtID);
        }
        if (certRevocationInfo != null) {
            formParams.add((Object)"certRevocationInfo", (Object)certRevocationInfo);
        }
        if (caCertFileName != null) {
            formParams.add((Object)"caCertFileName", (Object)caCertFileName);
        }
        if (isCertAuthEnabled != null) {
            formParams.add((Object)"isCertAuthEnabled", (Object)isCertAuthEnabled);
        }
        if (createdBy != null) {
            formParams.add((Object)"createdBy", (Object)createdBy);
        }
        if (tenantId != null) {
            formParams.add((Object)"tenantId", (Object)tenantId);
        }
        if (name != null) {
            formParams.add((Object)"name", (Object)name);
        }
        if (createdTime != null) {
            formParams.add((Object)"createdTime", (Object)createdTime);
        }
        if (links != null) {
            formParams.add((Object)"links", links);
        }
        if (isCacEnabled != null) {
            formParams.add((Object)"isCacEnabled", (Object)isCacEnabled);
        }
        if (lastUpdatedTime != null) {
            formParams.add((Object)"lastUpdatedTime", (Object)lastUpdatedTime);
        }
        if (extId2 != null) {
            formParams.add((Object)"extId", (Object)extId2);
        }
        String[] accepts = new String[]{"application/json"};
        List<MediaType> accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{"multipart/form-data"};
        MediaType contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"apiKeyAuthScheme", "basicAuthScheme"};
        ParameterizedTypeReference<UpdateCertAuthProviderApiResponse> returnType = new ParameterizedTypeReference<UpdateCertAuthProviderApiResponse>(){};
        return this.apiClient.invokeAPI(uriPath, HttpMethod.PUT, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, Object>)formParams, accept, contentType, authNames, returnType);
    }
}

